  @  /*~!drand48.c*/  +/* Name:  drand48.c Part No.: _______-____r +  *  - * Copyright 1992 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     !#ident	"@(#)nbclib:drand48.c	1.1" !    /*   @  / *	drand48, etc. pseudo-random number generator / B *	This implementation assumes unsigned short integers of at least B : *	16 bits, long integers of at least 32 bits, and ignores : < *	overflows on adding or multiplying two unsigned integers. < > *	Two's-complement representation is assumed in a few places. > > *	Some extra masking is done if unsigneds are exactly 16 bits > - *	or longs are exactly 32 bits, but so what? - F *	An assembly-language implementation would run significantly faster. F  */  #ifndef HAVEFP  #define HAVEFP 1  #endif  #define N	16  <#define MASK	((unsigned)(1 << (N - 1)) + (1 << (N - 1)) - 1) < %#define LOW(x)	((unsigned)(x) & MASK) % #define HIGH(x)	LOW((x) >> N)                                                      @  8#define MUL(x, y, z)	{ long l = (long)(x) * (long)(y); \ 8 &		(z)[0] = LOW(l); (z)[1] = HIGH(l); } & 2#define CARRY(x, y)	((long)(x) + (long)(y) > MASK) 2 =#define ADDEQU(x, y, z)	(z = CARRY(x, (y)), x = LOW(x + (y))) = #define X0	0x330E  #define X1	0xABCD  #define X2	0x1234  #define A0	0xE66D  #define A1	0xDEEC  #define A2	0x5  
#define C	0xB 
 I#define SET3(x, x0, x1, x2)	((x)[0] = (x0), (x)[1] = (x1), (x)[2] = (x2)) I N#define SETLOW(x, y, n) SET3(x, LOW((y)[n]), LOW((y)[(n)+1]), LOW((y)[(n)+2])) N J#define SEED(x0, x1, x2) (SET3(x, x0, x1, x2), SET3(a, A0, A1, A2), c = C) J N#define REST(v)	for (i = 0; i < 3; i++) { xsubi[i] = x[i]; x[i] = temp[i]; } \ N 
		return (v); 
                                                                   @  J#define NEST(TYPE, f, F)	TYPE f(xsubi) register unsigned short *xsubi; { \ J 5	register int i; register TYPE v; unsigned temp[3]; \ 5 E	for (i = 0; i < 3; i++) { temp[i] = x[i]; x[i] = LOW(xsubi[i]); }  \ E 	v = F(); REST(v); }  "#define HI_BIT	(1L << (2 * N - 1)) "    Dstatic unsigned x[3] = { X0, X1, X2 }, a[3] = { A0, A1, A2 }, c = C; D static unsigned short lastx[3];  static void next();     
#if HAVEFP 
 double  	drand48() 	 {  (	static double two16m = 1.0 / (1L << N); (    	next();  <	return (two16m * (two16m * (two16m * x[0] + x[1]) + x[2])); < }     NEST(double, erand48, drand48);     #else     long  
irand48(m) 
 A/* Treat x[i] as a 48-bit fraction, and multiply it by the 16-bit A                                @  0 * multiplier m.  Return integer part as result. 0  */  register unsigned short m;  {  !	unsigned r[4], p[2], carry0 = 0; !    	next();  	MUL(m, x[0], &r[0]);  	MUL(m, x[2], &r[2]);  	MUL(m, x[1], p);  	if (CARRY(r[1], p[0]))  		ADDEQU(r[2], 1, carry0);  ,	return (r[3] + carry0 + CARRY(r[2], p[1])); , }     long  krand48(xsubi, m)  >/* same as irand48, except user provides storage in xsubi[] */ > register unsigned short *xsubi;  unsigned short m;  {  	register int i;  	register long iv;  	unsigned temp[3];     	for (i = 0; i < 3; i++) {  		temp[i] = x[i];  		x[i] = xsubi[i];  	}  	iv = irand48(m);  
	REST(iv); 
 }  #endif     long  	lrand48() 	 {  	next();                                  @  0	return (((long)x[2] << (N - 1)) + (x[1] >> 1)); 0 }     long  	mrand48() 	 {  	register long l;     	next();  2	/* sign-extend in case length of a long > 32 bits 2 						(as on Honeywell) */  D	return ((l = ((long)x[2] << N) + x[1]) & HI_BIT ? l | -HI_BIT : l); D }     static void  next()  {  +	unsigned p[2], q[2], r[2], carry0, carry1; +    	MUL(a[0], x[0], p);  	ADDEQU(p[0], c, carry0);  	ADDEQU(p[1], carry0, carry1);  	MUL(a[0], x[1], q);  	ADDEQU(p[1], q[0], carry0);  	MUL(a[1], x[0], r);  ?	x[2] = LOW(carry0 + carry1 + CARRY(p[1], r[0]) + q[1] + r[1] + ? +		a[0] * x[2] + a[1] * x[1] + a[2] * x[0]); + 	x[1] = LOW(p[1] + r[0]);  	x[0] = LOW(p[0]);  }     void  srand48(seedval)  
long seedval; 
   @  {  '	SEED(X0, LOW(seedval), HIGH(seedval)); ' }     unsigned short *  seed48(seed16v)  unsigned short seed16v[3];  {  	SETLOW(lastx, x, 0);  9	SEED(LOW(seed16v[0]), LOW(seed16v[1]), LOW(seed16v[2])); 9 	return (lastx);  }     void  lcong48(param)  unsigned short param[7];  {  	SETLOW(x, param, 0);  	SETLOW(a, param, 3);  	c = LOW(param[6]);  }     NEST(long, nrand48, lrand48);     NEST(long, jrand48, mrand48);     
#ifdef DRIVER 
 /*  8	This should print the sequences of integers in Tables 2 8 		and 1 of the TM:  "	1623, 3442, 1447, 1829, 1305, ... " .	657EB7255101, D72A0C966378, 5A743C062A23, ... .  */  #include <stdio.h>     main()  {  	int i;     	for (i = 0; i < 80; i++) {           |@  *		printf("%4d ", (int)(4096 * drand48())); * -		printf("%.4X%.4X%.4X\n", x[2], x[1], x[0]); - 	}  }  #endif                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     