************************************************************************
*MI03                      MANAGEMENT INFORMATION                      *
*    DEVICE ID: HH-65A                 HID:       XX.XX-01             *
*    FILENAME:  JF_.A61                LANGUAGE:  ASSEMBLY             *
*    LOAD MODUL:                       SYSTEM:    JC                   *
*    COMPILER:                         ASSEMBLER: ASM V2.1A            *
*    TRNR CPU:                         CPU TYPE:  SEL 32/77            *
*    ITRTN RATE:                       MODE:                           *
*    LINK EDITR:                                                       *
*                                                                      *
************************************************************************
*PU02                             PURPOSE                              *
*                                                                      *
************************************************************************
*TI02                      TECHNICAL INFORMATION                       *
*    *KEYWORD* ENTP JF.                                                *
*                                                                      *
************************************************************************
*PA02                        PROGRAM ATTRIBUTES                        *
*    LOGICAL RECORDS:            352   GENERAL COMMENTS:             3 *
*    FORTRAN LINES:                0   NON-FORTRAN LINES:          352 *
*    EXECUTABLE FTN STMTS:         0   NON-EXEC FORTRAN STMTS:       0 *
*                                                                      *
************************************************************************
*SU01                         SUBPROGRAM USAGE                         *
*      NAME       NAME       NAME         NAME       NAME       NAME   *
*    JV.DELMF   PAIRDATA   PAIRDATX     SS.MCB     SS.MCW              *
*                                                                      *
************************************************************************
*CH02                          CHANGE HISTORY                          *
*    REV   DATE        SOFTWARE ANALYST               EMPLOYER         *
*                               DESCRIPTION OF CHANGE                  *
*    01  18JUL95   JOHN RUCKSTUHL             NAWCTSD CODE 493         *
*              INITIAL HEADER INSTALLATION                             *
*                                                                      *
************************************************************************
         TITLE     GRAPHICS INSTRUCTOR STATION SWITCH GATEWAY
         PROGRAM   JF.
*
*        REV 1     10/23/84        ADDED POWER-FAIL RESET SWITCH LOGIC
************************************************************************
*
**  EXTERNAL DEFINITIONS -
*
         DEF       JF.
*
************************************************************************
*
         EXT       PAIRDATA        TABLE OF PAGE AND PAIR PAGE NUMBERS
         EXT       PAIRDATX        END OF PAIR TABLE
         EXT       SS.MCW          MOVE CONSECUTIVES WORDS
         EXT       SS.MCB          MOVE CONSECUTIBE BYTES
         EXT       JV.DELMF        DELETE MALFUNCTION
*
         LIST      NOMAC
         ZG$                       GLOBAL COMMON EQUATES
*
         M.REQS                    REGISTER EQUATES
*
DATAPOOL COMMON    FFREEZE         FREEZE FLAG
DATAPOOL COMMON    FJFCROV         CRASH OVRD FLAG
DATAPOOL COMMON    FJFSTORE        STORE CONDITIONS FLAG
DATAPOOL COMMON    FJFRESET        RESET CONDITIONS FLAG
DATAPOOL COMMON    FJFPFRST        POWER-FAIL RESET CONDITIONS FLAG
*
DATAPOOL COMMON    IGTOC1CI        CURRENT DISPLAYED ID - CRT 1
DATAPOOL COMMON    IGTOC1RI        REQUESTED DISPLAY ID - CRT 1
DATAPOOL COMMON    IGTOC1RS        REQUESTED DISPLAY SUBPAGE - CRT 1
DATAPOOL COMMON    IGTOC1PI        PREVIOUS DISPLAY ID - CRT 1
DATAPOOL COMMON    IGTOC1PS        PREVIOUS DISPLAY SUBPAGE - CRT 1
DATAPOOL COMMON    IGTLSTCS        LAST CROSS COUNTRY MAP SCALE
DATAPOOL COMMON    IGTLSTMS        LAST APPR MAP SCALE
*
DATAPOOL COMMON    BGTOC1SB        STATUS BITS - CRT 1
*
DATAPOOL COMMON    TJKLINE1        ASCII KEYPAD TABLE - CRT 1
DATAPOOL COMMON    IJKCHAR1        NUMBER OF DISPLAYED CHARS - CRT 1
DATAPOOL COMMON    FJKENT1         KEYPAD ENTER SELECTION - CRT 1
DATAPOOL COMMON    IMFEDIT         MALF DESCR. DISPLAYED ON EDIT LINE
DATAPOOL COMMON    IMFDESCR        MALFUNCTION DESCRIPTION  (10*5W)
DATAPOOL COMMON    IMFINDEX        MALFUNCTION INDEX        (10H)
DATAPOOL COMMON    IMFEDNUM        MALF BIT NUMBER OF MALF ON EDIT LINE
*
FPRINLAT DATAB     0               PRINT DISPLAY LATCH FLAG
FLPLAT   DATAB     0               LAST PAGE LATCH FLAG
FMFLAT   DATAB     0               MALF OVRID LATCH FLAG
FCRLAT   DATAB     0               CRASH OVRD LATCH FLAG
FSCLAT   DATAB     0               STORE CONDITIONS LATCH FLAG
FRCLAT   DATAB     0               RESET CONDITIONS LATCH FLAG
FPAIRLAT DATAB     0               PAIR LATCH FLAG
FMRMVLAT DATAB     0               MALF REMOVE LATCH FLAG
FSTORE   DATAB     0               TRUE IF STORE BEFORE RESET
         BOUND     1W
*
************************************************************************
         PAGE
************************************************************************
*
JF.      EQU       $
         STF       R0,JF.SAVE      SAVE CALLER'S REGS
*
         LI        R7,-1
*
** CHECK DI'S AND SET APPROPRIATE FLAGS
*
JF.30    EQU       $              * LAST PAGE *
         TBM       05,ZG.DI+1H      TEST DI BIT
         BNS       JF.35           . BRANCH IF NOT SET
*
         LB        R6,FLPLAT       CHECK LATCH STATUS
         BNZ       JF.50           . BRANCH IF ALREADY LATCHED
*
         LH        R5,IGTOC1PI     SET R5 = PREVIOUS PAGE ID
         CAMH      R5,IGTOC1CI     CHECK IF TOGGLING BETWEEN MAP SCALES
         BNE       $+5W
         STH       R5,IGTOC1RI     . STORE AS REQUESTED PAGE ID
         LH        R5,IGTOC1PS     SET R5 = PREVIOUS SUBPAGE
         STH       R5,IGTOC1RS     . STORE AS REQUESTED SUBPAGE
         BU        JF.33
         STH       R5,IGTOC1RI     . STORE AS REQUESTED PAGE ID
         ZMH       IGTOC1RS        SET REQUESTED SUBPAGE TO 0
*
         ZR        R4              PREPARE FOR DIVIDE
         DVI       R4,100          R5 = 1ST DIGIT OF 3 DIGIT PAGE NUMBER
         CI        R5,5            CHECK IF MAP PAGE (500 - 511)
         BNE       JF.33           SKIP IF NOT
         CI        R4,12
         BGE       JF.33
*
         CI        R4,0            R4 = SUBPAGE (00 - 11)
         BNE       $+4W            IF NOT CROSS COUNTRY, MUST BE APR MAP
         LB        R5,IGTLSTCS     SET R5 = LAST CROSS COUNTRY MAP SCALE
         STH       R5,IGTOC1RS     . STORE AS REQUESTED SUBPAGE
         BU        JF.33
         LB        R5,IGTLSTMS     SET R5 = LAST APPR MAP SCALE
         STH       R5,IGTOC1RS     . STORE AS REQUESTED SUBPAGE
*
JF.33    SBM       00,BGTOC1SB     SET DISPLAY REQUEST BIT
         STB       R7,FLPLAT       SET LATCH FLAG
         BU        JF.50
*
JF.35    EQU       $
         ZMB       FLPLAT          CLEAR LATCH FLAG
*
************************************************************************
         PAGE
************************************************************************
*
JF.50    EQU       $              * PAIR *
         TBM       04,ZG.DI+1H     TEST DI BIT
         BNS       JF.58           . BRANCH IF DI NOT SET
*
         LB        R6,FPAIRLAT     CHECK LATCH STATUS
         BNZ       JF.60           . BRANCH IF ALREADY LATCHED
*
         LH        R6,IGTOC1CI     CURRENTLY DISPLAYED PAGE
         LA        R2,PAIRDATA     START ADDRESS OF PAIR DATA
JF.52    EQU       $
         CAMH      R6,0H,X2        COMPARE PAGE WITH TABLE ENTRY
         BEQ       JF.55           . BRANCH IF FOUND
         ABR       R2,29           BUMP INDEX BY 1 WORD
         CAMW      R2,PAIRDATX     TEST FOR END OF TABLE
         BLT       JF.52           . LOOP IF NOT DONE
         BU        JF.60           BRANCH IF NOT FOUND
*
JF.55    EQU       $
         LH        R5,1H,X2        PAIR PAGE
         STH       R5,IGTOC1RI     STORE AS REQUESTED PAGEE
         ZMH       IGTOC1RS        SET REQUESTED SUBPAGE TO 0
*
         ZR        R4              PREPARE FOR DIVIDE
         DVI       R4,100          R5 = 1ST DIGIT OF 3 DIGIT PAGE NUMBER
         CI        R5,5            CHECK IF MAP PAGE (500 - 511)
         BNE       JF.56           SKIP IF NOT
         CI        R4,12
         BGE       JF.56
*
         CI        R4,0            R4 = SUBPAGE (00 - 11)
         BNE       $+4W            IF NOT CROSS COUNTRY, MUST BE APR MAP
         LB        R5,IGTLSTCS     SET R5 = LAST CROSS COUNTRY MAP SCALE
         STH       R5,IGTOC1RS     . STORE AS REQUESTED SUBPAGE
         BU        JF.56
         LB        R5,IGTLSTMS     SET R5 = LAST APPR MAP SCALE
         STH       R5,IGTOC1RS     . STORE AS REQUESTED SUBPAGE
*
JF.56    SBM       00,BGTOC1SB     SET DISPLAY REQUEST BIT
         STB       R7,FPAIRLAT     SET LATCH FLAG
         BU        JF.60
*
JF.58    EQU       $
         ZMB       FPAIRLAT        CLEAR LATCH FLAG
*
************************************************************************
         PAGE
************************************************************************
*
JF.60    EQU       $              * STORE CONDITIONS *
         TBM       03,ZG.DI         TEST DI BIT
         BNS       JF.68           . BRANCH IF NOT SET
*
         LB        R6,FSCLAT       LOAD LATCH FLAG
         BNZ       JF.70           . BRANCH IF ALREADY LATCHED
*
         STB       R7,FSCLAT       SET LATCH FLAG
         STB       R7,FJFSTORE     SET STORE FLAG
         STB       R7,FSTORE       SET LOCAL STORE FLAG
         BU        JF.70
*
JF.68    EQU       $
         ZMB       FSCLAT          CLEAR LATCH FLAG
*
************************************************************************
         PAGE
************************************************************************
*
JF.70    EQU       $              * RESET CONDITIONS *
         TBM       07,ZG.DI         TEST DI BIT
         BNS       JF.78           . BRANCH IF NOT SET
*
         LB        R6,FRCLAT       LOAD LATCH FLAG
         BNZ       JF.80           . BRANCH IF ALTEADY LATCHED
*
         LB        R6,FFREEZE      CHECK IF IN FREEZE
         BZ        JF.80           . BRANCH IF NOT FREEZE
*
         STB       R7,FRCLAT       SET LATCH FLAG
         LB        R6,FSTORE       CHECK IF STORE CONDITIONS USED FIRST
         BZ        $+3W            IF NOT, SET POWER-FAIL RESET FLAG
*
         STB       R7,FJFRESET     SET STORE FLAG
         BU        JF.80
         STB       R7,FJFPFRST     SET POWER-FAIL RESET FLAG
         BU        JF.80
*
JF.78    EQU       $
         ZMB       FRCLAT          CLEAR LATCH FLAG
*
************************************************************************
         PAGE
************************************************************************
*
JF.80    EQU       $             * CRASH OVERRIDE *
         TBM       11,ZG.DI        TEST DI BIT
         BNS       JF.88           . BRANCH IF DI NOT SET
*
         LB        R6,FCRLAT       CHECK LATCH STATUS
         BNZ       JF.90           . BRANCH IF ALREADY LATCHED
*
         LB        R6,FJFCROV      LOAD CRASH OVRD FLAG
         TRC       R6,R6           TOGGLE FLAG VALUE
         STB       R6,FJFCROV      RESTORE FLAG VALUE
         STB       R7,FCRLAT       SET LATCH FLAG
         BU        JF.90
*
JF.88    EQU       $
         ZMB       FCRLAT          CLEAR LATCH FLAG
*
************************************************************************
         PAGE
************************************************************************
*
JF.90    EQU       $             * MALFUNCTION REMOVE *
         TBM       15,ZG.DI        TEST DI BIT
         BNS       JF.98           . BRANCH IF DI NOT SET
*
         LB        R6,FMRMVLAT     CHECK LATCH STATUS
         BNZ       JF.100          . BRANCH IF ALREADY LATCHED
*
         LA        R1,IMFDESCR     DESCRIPTION OF LAST ENTERED MALF
         LA        R2,IMFEDIT      TO BE DISPLAYED ON EDIT LINE
         LI        R4,5W           LENGTH OF DESCRIPTION IS 5W
         BL        SS.MCW          MOVE DESCRIPTION TO EDIT LINE
*
         LB        R1,IMFEDIT      CHECK IF A MALF IS ON EDIT LINE
         CI        R1,X'20'        IF BLANKS, NO MALF TO DELETE
         BNE       $+3W            BRANCH TO DELETE MALFUNCTION
         ZMB       IMFEDIT         ZERO 1ST BYTE TO ALLOW KEPAD ENTRY
         BU        JF.95           SKIP MALFUNCTION DELETION
*
         ZR        R2              DELETE TOP ENTRY IN MALF STACKS
         LH        R5,IMFINDEX     MALF BIT NUMBER OF LAST ENTERED MALF
         STH       R5,IMFEDNUM     MALF BIT NUM OF MALF MOVED TO EDIT LN
         BL        JV.DELMF        DELETE MALFUNCTION
*
JF.95    EQU       $
         STB       R7,FMRMVLAT     SET LATCH FLAG
         BU        JF.100
*
JF.98    EQU       $
         ZMB       FMRMVLAT        CLEAR LATCH FLAG
*
************************************************************************
         PAGE
************************************************************************
*
JF.100   EQU       $             * PRINT DISPLAY *
         TBM       06,ZG.DI+1H     TEST DI BIT
         BNS       JF.105          . BRANCH IF DI NOT SET
*
         LB        R6,FPRINLAT     CHECK LATCH STATUS
         BNZ       JF.200          . BRANCH IF ALREADY LATCHED
*
         SBM       01,BGTOC1SB     SET HARDCOPY DUMP REQUEST FLAG
         M.SUME    HCNAME          RESUME HC/
         LI        R7,-1
         STB       R7,FPRINLAT     SET LATCH FLAG
         BU        JF.200
*
JF.105   EQU       $
         TBM       01,BGTOC1SB     CHECK HARDCOPY REQUEST FLAG
         BS        JF.200          . BRANCH IF HARDCOPY IN PROGRESS
         ZMB       FPRINLAT        CLEAR LATCH FLAG
*
************************************************************************
         PAGE
         TITLE     GRAPHICS INSTRUCTOR STATION LIGHT/DO CONTROL
************************************************************************
*
JF.200   EQU       $
         ZBM       01,ZG.DO+1H     CLEAR DO BIT
         LB        R4,FJFCROV      CHECK CRASH OVRD FLAG
         BZ        $+2W
*
         SBM       01,ZG.DO+1H     SET DO BIT
*
         ZBM       04,ZG.DO+1H     CLEAR DO BIT
         LB        R4,FPRINLAT     CHECK PRINT DISPLAY FLAG
         BZ        $+2W
*
         SBM       04,ZG.DO+1H     SET DO BIT
*
         ZBM       02,ZG.DO+1H     CLEAR DO BIT
         LB        R4,FJFSTORE     CHECK STORE FLAG
         BZ        $+2W
*
         SBM       02,ZG.DO+1H     SET DO BIT
*
         ZBM       03,ZG.DO+1H     CLEAR DO BIT
         LB        R4,FJFRESET     CHECK RESET FLAG
         BZ        $+2W
*
         SBM       03,ZG.DO+1H     SET DO BIT
*
*
         LF        R0,JF.SAVE      RESTORE CALLER'S REGS
         TRSW      R0              RETURN TO CALLER
*
JF.SAVE  RES       1F              HOLDS CALLER'S REGS
*
************************************************************************
HCNAME   DATAD     C'HC/'          HARDCOPY TASK NAME
         END
