  @     ARCSINTRO(1)                                           RCSINTRO(1) A       NAME  .       rcsintro - introduction to RCS commands .    DESCRIPTION  A       The  Revision  Control System (RCS) manages multiple revi- A A       sions of files.  RCS  automates  the  storing,  retrieval, A A       logging, identification, and merging of revisions.  RCS is A A       useful for text that is revised  frequently,  for  example A A       programs,  documentation,  graphics, papers, and form let- A        ters.     A       The basic user interface is extremely simple.  The  novice A A       only  needs  to  learn  two  commands:  ci  and  co.   ci, A A       short for "check in", deposits the contents of a file into A                             @  A       an archival file called an RCS file.  An RCS file contains A A       all revisions of a particular file.  co, short for  "check A 2       out", retrieves revisions from an RCS file. 2       Functions of RCS  A       o      Store and retrieve multiple revisions of text.  RCS A A              saves all old revisions in a space  efficient  way. A A              Changes no longer destroy the original, because the A A              previous revisions  remain  accessible.   Revisions A A              can  be  retrieved  according to ranges of revision A A              numbers,  symbolic  names,  dates,   authors,   and A               states.     A       o      Maintain  a  complete history of changes.  RCS logs A                               @  A              all changes automatically.   Besides  the  text  of A A              each  revision, RCS stores the author, the date and A A              time of check-in, and a log message summarizing the A A              change.  The logging makes it easy to find out what A A              happened to a module,  without  having  to  compare A A              source listings or having to track down colleagues. A    A       o      Resolve access conflicts.  When two  or  more  pro- A A              grammers  wish  to  modify  the  same revision, RCS A A              alerts the programmers and prevents  one  modifica- A -              tion from corrupting the other. -    A       o      Maintain  a  tree  of  revisions.  RCS can maintain A               @  A              separate lines of development for each module.   It A A              stores  a tree structure that represents the ances- A 1              tral relationships among revisions. 1    A       o      Merge revisions and resolve conflicts.   Two  sepa- A A              rate  lines  of development of a module can be coa- A A              lesced by merging.  If the revisions to  be  merged A A              affect  the  same  sections of code, RCS alerts the A 1              user about the overlapping changes. 1    A       o      Control releases and configurations.  Revisions can A A              be  assigned symbolic names and marked as released, A A              stable, experimental, etc.  With these  facilities, A                           @  A              configurations  of  modules can be described simply A               and directly.     A       o      Automatically identify  each  revision  with  name, A A              revision  number,  creation time, author, etc.  The A A              identification is like a stamp that can be embedded A A              at  an appropriate place in the text of a revision. A A              The identification makes  it  simple  to  determine A A              which  revisions  of  which modules make up a given A               configuration.     A       o      Minimize secondary storage.  RCS needs little extra A A              space for the revisions (only the differences).  If A                                                                      @  A              intermediate revisions are deleted, the correspond- A 4              ing deltas are compressed accordingly. 4       Getting Started with RCS  A       Suppose  you  have  a  file f.c that you wish to put under A A       control of RCS.  If you have not already done so, make  an A %       RCS directory with the command %                  mkdir  RCS     '       Then invoke the check-in command '                  ci  f.c     A       This  command  creates  an  RCS file in the RCS directory, A A       stores f.c into it as revision 1.1, and deletes  f.c.   It A A       also  asks  you for a description.  The description should A A       be a synopsis of the contents  of  the  file.   All  later A                                @  A       check-in  commands  will  ask  you  for a log entry, which A 2       should summarize the changes that you made. 2    A       Files in the RCS directory are called RCS files; the  oth- A A       ers  are  called  working  files.  To get back the working A A       file f.c in the previous example, use the  check-out  com- A        mand                   co  f.c     A       This  command  extracts  the  latest revision from the RCS A A       file and writes it into f.c.  If you want to edit f.c, you A 8       must lock it as you check it out with the command 8                  co  -l  f.c            You can now edit f.c.     A       Suppose  after  some editing you want to know what changes A                                    @  '       that you have made.  The command '                  rcsdiff  f.c     A       tells  you  the  difference  between  the  most   recently A A       checked-in  version  and  the working file.  You can check A #       the file back in by invoking #                  ci  f.c     4       This increments the revision number properly. 4    '       If ci complains with the message '    0              ci error: no lock set by your name 0    A       then you have tried to check in a file even though you did A A       not lock it when you checked it out.  Of course, it is too A A       late now to do the check-out with locking, because another A A       check-out  would  overwrite  your modifications.  Instead, A 
       invoke 
        @                rcs  -l  f.c     A       This command will lock the latest revision for you, unless A A       somebody  else  got  ahead  of you already.  In this case, A 1       you'll have to negotiate with that person. 1    A       Locking assures that you, and only you, can check  in  the A A       next  update,  and avoids nasty problems if several people A A       work on the same file.  Even if a revision is  locked,  it A A       can still be checked out for reading, compiling, etc.  All A A       that locking prevents is a check-in  by  anybody  but  the A        locker.     A       If  your  RCS  file  is private, i.e., if you are the only A A       person who is going to deposit revisions into  it,  strict A                           @  A       locking  is not needed and you can turn it off.  If strict A A       locking is turned off, the owner of the RCS file need  not A A       have  a  lock  for check-in; all others still do.  Turning A :       strict locking off and on is done with the commands :    3              rcs  -U  f.c     and     rcs  -L  f.c 3    A       If you don't want to clutter your working  directory  with A A       RCS  files, create a subdirectory called RCS in your work- A A       ing directory, and move all your  RCS  files  there.   RCS A A       commands  will  look  first  into  that  directory to find A A       needed files.  All the commands discussed above will still A A       work,  without  any modification.  (Actually, pairs of RCS A                @  A       and working files can be specified in three ways: (a) both A A       are  given,  (b)  only the working file is given, (c) only A A       the RCS file is given.  Both RCS  and  working  files  may A A       have  arbitrary  path  prefixes; RCS commands pair them up A        intelligently.)     A       To avoid the deletion of the working file during  check-in A A       (in  case  you  want  to  continue  editing or compiling), A 
       invoke 
    0              ci  -l  f.c     or     ci  -u  f.c 0    A       These commands check in  f.c  as  usual,  but  perform  an A A       implicit check-out.  The first form also locks the checked A A       in revision, the second one doesn't.  Thus, these  options A                                 @  A       save  you one check-out operation.  The first form is use- A A       ful if you want to continue editing, the second one if you A A       just  want  to read the file.  Both update the identifica- A 5       tion markers in your working file (see below). 5    A       You can give ci the number you want assigned to a  checked A A       in revision.  Assume all your revisions were numbered 1.1, A A       1.2, 1.3, etc., and you would like  to  start  release  2. A        The command     4              ci  -r2  f.c     or     ci  -r2.1  f.c 4    A       assigns the number 2.1 to the new revision.  From then on, A A       ci will number the subsequent  revisions  with  2.2,  2.3, A *       etc.  The corresponding co commands *              @  5              co  -r2  f.c     and     co  -r2.1  f.c 5    A       retrieve the latest revision numbered 2.x and the revision A A       2.1, respectively.  co without a revision  number  selects A A       the  latest  revision on the trunk, i.e. the highest revi- A A       sion with a number consisting of two fields.  Numbers with A A       more  than  two fields are needed for branches.  For exam- A 5       ple, to start a branch at revision 1.3, invoke 5                  ci  -r1.3.1  f.c     A       This command starts a branch numbered 1 at  revision  1.3, A A       and  assigns  the number 1.3.1.1 to the new revision.  For A 6       more information about branches, see rcsfile.m. 6       Automatic Identification                         @  A       RCS can put special strings for identification  into  your A A       source  and  object  code.  To obtain such identification, A        place the marker                   $Id$     A       into your text, for instance inside a comment.   RCS  will A 4       replace this marker with a string of the form 4    A              $Id:  filename  revision  date  time  author  state A               $     A       With such a marker on the first page of each  module,  you A A       can  always  see with which revision you are working.  RCS A A       keeps the markers up to date automatically.  To  propagate A A       the  markers  into  your object code, simply put them into A                                                                    @  A       literal character strings.  In C, this is done as follows: A    +              static char rcsid[] = "$Id$"; +    A       The  command  ident  extracts  such markers from any file, A A       even object code and dumps.  Thus, ident lets you find out A A       which revisions of which modules were used in a given pro- A        gram.     A       You may also find it useful to put the marker  $Log$  into A A       your  text, inside a comment.  This marker accumulates the A A       log messages that are requested  during  check-in.   Thus, A A       you  can  maintain  the  complete  history  of  your  file A A       directly inside it.  There are several additional  identi- A .       fication markers; see co.m for details. .             @  IDENTIFICATION         Author: Walter F. Tichy.  6       Revision Number: 5.1; Release Date: 1991/04/21. 6 9       Copyright (C) 1982, 1988, 1989 by Walter F. Tichy. 9 /       Copyright (C) 1990, 1991 by Paul Eggert. / A       Ported to MPX-32 05/05/95 by James C. Bevier, J B Systems. A    SEE ALSO  A       ci.m,   co.m,   ident.m,  rcs.m,  rcsdiff.m,  rcsintro.m,  A        rcsmerge.m,  rlog.m  A       Walter  F.  Tichy,  RCS--A  System  for  Version  Control, A A       Software--Practice   &   Experience  15,  7  (July  1985), A        637-654.     AGNU - RCS - RCSINTRO        J B Systems                  05/05/95 A                                                                                                                       