  @     ACI(1)                                                       CI(1) A       NAME  "       ci - check in RCS revisions "    SYNOPSIS         ci [options] file ...     DESCRIPTION  A       ci  stores  new  revisions  into RCS files.  Each pathname A A       matching an RCS suffix is taken to be an  RCS  file.   All A A       others  are  assumed  to  be  working files containing new A A       revisions.  ci deposits the contents of each working  file A A       into  the  corresponding RCS file.  If only a working file A A       is given, ci tries to find the corresponding RCS  file  in A A       an  RCS subdirectory and then in the working file's direc- A 6       tory.  For more details, see FILE NAMING below. 6                      @  A       For ci to work, the caller's login must be on  the  access A A       list,  except if the access list is empty or the caller is A A       the superuser or the owner of the file.  To append  a  new A A       revision  to  an existing branch, the tip revision on that A A       branch must be locked by the caller.   Otherwise,  only  a A A       new  branch  can  be  created.   This  restriction  is not A A       enforced for the owner of the file if  non-strict  locking A A       is  used (see rcs.m).   A lock held by someone else may be A #       broken with the rcs command. #    A       Unless the -f option is given, ci checks whether the revi- A A       sion  to  be deposited differs from the preceding one.  If A                              @  A       not, instead of creating a new revision ci reverts to  the A A       preceding one.  To revert, ordinary ci removes the working A A       file and any lock; ci -l keeps and ci -u removes any lock, A A       and  then they both generate a new working file much as if A A       co -l or co -u had been applied to the preceding revision. A A       When reverting, any -n and -s options apply to the preced- A        ing revision.     A       For each revision deposited, ci prompts for a log message. A A       The  log  message  should summarize the change and must be A A       terminated by end-of-file or by  a  line  containing  . by A A       itself.   If  several files are checked in ci asks whether A                                             @  A       to reuse the previous log message.  If the standard  input A A       is  not  a terminal, ci suppresses the prompt and uses the A 4       same log message for all files.  See also -m. 4    A       If the RCS file does not exist, ci creates it and deposits A A       the  contents  of the working file as the initial revision A A       (default number: 1.1).  The access list is initialized  to A A       empty.   Instead  of the log message, ci requests descrip- A         tive text (see -t below).      A       The number rev of the deposited revision can be  given  by A A       any of the options -f, -I, -k, -l, -M, -q, -r, or -u.  rev A A       may be symbolic, numeric, or  mixed.   If  rev  is  $,  ci A                                         @  A       determines  the revision number from keyword values in the A        working file.     A       If rev is a revision number, it must be  higher  than  the A A       latest  one  on  the  branch to which rev belongs, or must A        start a new branch.     A       If rev is a branch rather than a revision number, the  new A A       revision  is appended to that branch.  The level number is A A       obtained by incrementing the tip revision number  of  that A A       branch.   If  rev  indicates  a  non-existing branch, that A A       branch is  created  with  the  initial  revision  numbered A 
       rev.1. 
    A       If  rev  is  omitted,  ci tries to derive the new revision A                                                         @  A       number from the caller's last lock.   If  the  caller  has A A       locked  the  tip revision of a branch, the new revision is A A       appended to that  branch.   The  new  revision  number  is A A       obtained  by incrementing the tip revision number.  If the A A       caller locked a non-tip revision, a new branch is  started A A       at that revision by incrementing the highest branch number A A       at that revision.  The default initial  branch  and  level A        numbers are 1.     A       If rev is omitted and the caller has no lock, but owns the A A       file and locking is not set to strict, then  the  revision A A       is appended to the default branch (normally the trunk; see A        the -b option in rcs.m).        @  A       Exception: On the trunk, revisions can be appended to  the A        end, but not inserted.     OPTIONS         -r[rev]  A              checks  in  a  revision, releases the corresponding A A              lock, and removes the working file.   This  is  the A               default.     A              The  -r  option  has  an unusual meaning in ci.  In A A              other RCS commands, -r merely specifies a  revision A A              number,  but  in  ci  it  also  releases a lock and A A              removes the working file.   See  -u  for  a  tricky A               example.            -l[rev]  A              works  like  -r,  except  it performs an additional A                                                                 @  A              co -l  for  the  deposited  revision.   Thus,   the A A              deposited revision is immediately checked out again A A              and locked.  This is useful for saving  a  revision A A              although one wants to continue editing it after the A               checkin.            -u[rev]  A              works like -l, except that the  deposited  revision A A              is not locked.  This lets one read the working file A (              immediately after checkin. (    A              The -l, -r, and -u options are  mutually  exclusive A A              and  silently  override  each  other.  For example, A A              ci -u -r is equivalent to ci -r  because  -r  over- A               rides -u.                 @         -f[rev]  A              forces  a  deposit;  the  new revision is deposited A >              even it is not different from the preceding one. >           -k[rev]  A              searches the working file  for  keyword  values  to A A              determine   its  revision  number,  creation  date, A A              state, and  author (see co.m),  and  assigns  these A A              values  to the deposited revision, rather than com- A A              puting them locally.  It also generates  a  default A A              login  message  noting  the login of the caller and A A              the actual checkin date.  This option is useful for A A              software  distribution.  A revision that is sent to A                                    @  A              several sites should be  checked  in  with  the  -k A A              option at these sites to preserve the original num- A A              ber, date, author, and state.  The  extracted  key- A A              word  values  and  the  default  log message may be A A              overridden with the options -d, -m, -s, -w, and any A 4              option that carries a revision number. 4           -q[rev]  A              quiet  mode;  diagnostic  output is not printed.  A A A              revision that is not different from  the  preceding A 7              one is not deposited, unless -f is given. 7           -d[date]  A              uses  date for the checkin date and time.  The date A                                                  @  A              is specified in free format as explained  in  co.m. A A              This  is  useful  for lying about the checkin date, A A              and for -k if no date is  available.   If  date  is A A              empty, the working file's time of last modification A               is used.            -M[rev]  A              Set the modification time on any new  working  file A A              to  be  the  date  of  the retrieved revision.  For A A              example, ci -d -M -u f does not alter f's modifica- A A              tion  time, even if f's contents change due to key- A A              word substitution.  Use this option with  care;  it A               can confuse make.                                                          @  A       -mmsg  uses  the  string  msg  as  the log message for all A #              revisions checked in. #    A       -nname assigns the symbolic name name to the number of the A A              checked-in revision.  ci prints an error message if A 9              name is already assigned to another number. 9    A       -Nname same as -n, except that  it  overrides  a  previous A !              assignment of name. !           -sstate  A              sets  the  state  of the checked-in revision to the A :              identifier state.  The default state is Exp. :    A       -tfile writes descriptive text from the  contents  of  the A A              named file into the RCS file, deleting the existing A                                            @  3              text.  The file may not begin with -. 3           -t-string  A              Write descriptive text from the string into the RCS A /              file, deleting the existing text. /    A              The  -t  option, in both its forms, has effect only A A              during an initial checkin; it is  silently  ignored A               otherwise.     A              During  the initial checkin, if -t is not given, ci A A              obtains the text from standard input, terminated by A A              end-of-file  or  by  a line containing . by itself. A A              The user is prompted for the text if interaction is A               possible.     A              For  backward  compatibility with older versions of A           @  /              RCS, a bare -t option is ignored. /           -wlogin  A              uses login for the author field  of  the  deposited A A              revision.   Useful  for lying about the author, and A /              for -k if no author is available. /    ;       -Vn    Emulate RCS version n.  See co.m for details. ;           -xsuffixes  A              specifies the suffixes for RCS files.   A  nonempty A A              suffix  matches  any pathname ending in the suffix. A A              An empty suffix matches any pathname  of  the  form A A              RCS/file or path/RCS/file.  The -x option can spec- A A              ify a list of suffixes separated by /.   For  exam- A                                                              @  A              ple, -x_v/ specifies two suffixes: _v and the empty A A              suffix.  If two or  more  suffixes  are  specified, A A              they  are  tried  in  order when looking for an RCS A A              file; the first one that works  is  used  for  that A A              file.   If no RCS file is found but an RCS file can A A              be created, the suffixes  are  tried  in  order  to A A              determine the new RCS file's name.  The default for A A              suffixes is installation-dependent; normally it  is A A              ,v/  for hosts like Unix that permit commas in file A A              names, and is empty (i.e. just  the  empty  suffix) A 1              for other hosts.  For MPX it is _v. 1                   @  FILE NAMING  A       Pairs  of  RCS files and working files may be specified in A 1       three ways (see also the example section). 1    A       1) Both the RCS file and the working file are given.   The A A       RCS  pathname is of the form path1/workfileX and the work- A A       ing pathname is of the form  path2/workfile  where  path1/ A A       and  path2/ are (possibly different or empty) paths, work- A A       file is a filename, and X is  an  RCS  suffix.   If  X  is A 7       empty, path1/ must be RCS/ or must end in /RCS/. 7    A       2)  Only  the RCS file is given.  Then the working file is A A       created in the current directory and its name  is  derived A A       from  the  name of the RCS file by removing path1/ and the A      @         suffix X.     A       3) Only the working file is given.  Then ci considers each A A       RCS  suffix X in turn, looking for an RCS file of the form A A       path2/RCS/workfileX or (if the former is not found  and  X A $       is nonempty) path2/workfileX. $    A       If  the RCS file is specified without a path in 1) and 2), A A       ci looks for the RCS file first in the directory ./RCS and A %       then in the current directory. %    A       ci  reports  an  error  if  an attempt to open an RCS file A A       fails for an unusual reason, even if the RCS file's  path- A A       name  is  just one of several possibilities.  For example, A A       to suppress use of RCS commands in a directory d, create a A                           @  A       regular  file  named  d/RCS so that casual attempts to use A ?       RCS commands in d fail because d/RCS is not a directory. ?    EXAMPLES  A       Suppose ,v is an RCS suffix and the current directory con- A A       tains  a  subdirectory  RCS with an RCS file io.c,v.  Then A A       each of the following commands check in  a  copy  of  io.c A =       into RCS/io.c,v as the latest revision, removing io.c. =    8              ci  io.c;    ci  RCS/io.c,v;   ci  io.c,v; 8 8              ci  io.c  RCS/io.c,v;    ci  io.c  io.c,v; 8 8              ci  RCS/io.c,v  io.c;    ci  io.c,v  io.c; 8    A       Suppose instead that the empty suffix is an RCS suffix and A A       the current directory contains a subdirectory RCS with  an A           @  A       RCS  file io.c.  The each of the following commands checks A        in a new revision.     (              ci  io.c;    ci  RCS/io.c; ( !              ci  io.c  RCS/io.c; ! !              ci  RCS/io.c  io.c; !    
FILE MODES 
 A       An RCS file created by ci inherits the  read  and  execute A A       permissions from the working file.  If the RCS file exists A A       already, ci preserves its read  and  execute  permissions. A >       ci always turns off all write permissions of RCS files. >    FILES  A       Several  temporary  files  may be created in the directory A A       containing the working file, and  also  in  the  temporary A A       directory  (see  TMPDIR  under  ENVIRONMENT).  A semaphore A                              @  A       file or files are created in the directory containing  the A A       RCS  file.   With  a  nonempty suffix, the semaphore names A A       begin with the first character of the  suffix;  therefore, A A       do  not  specify  an suffix whose first character could be A A       that of a working filename.  With  an  empty  suffix,  the A A       semaphore names end with _ so working filenames should not A        end in _.     A       ci never changes an RCS or  working  file.   Normally,  ci A A       unlinks  the  file  and  creates a new one; but instead of A A       breaking a chain of one or more symbolic links to  an  RCS A A       file, it unlinks the destination file instead.  Therefore, A                                                 @  A       ci breaks any hard or symbolic links to any  working  file A A       it  changes;  and hard links to RCS files are ineffective, A 5       but symbolic links to RCS files are preserved. 5    A       The effective user must be able to search  and  write  the A A       directory  containing  the  RCS  file.  Normally, the real A A       user must be able to read the RCS and working files and to A A       search  and  write  the  directory  containing the working A A       file; however,  some  older  hosts  cannot  easily  switch A A       between  real  and  effective users, so on these hosts the A A       effective user is used for all  accesses.   The  effective A A       user is the same as the real user unless your copies of ci A            @  A       and co have setuid privileges.  As described in  the  next A A       section,  these  privileges  yield  extra  security if the A A       effective user owns all RCS files and directories, and  if A 9       only the effective user can write RCS directories. 9    A       Users  can control access to RCS files by setting the per- A A       missions of the directory containing the files; only users A A       with write access to the directory can use RCS commands to A A       change its RCS files.  For example, in hosts that allow  a A A       user  to  belong to several groups, one can make a group's A A       RCS  directories  writable  to  that  group  only.    This A A       approach suffices for informal projects, but it means that A        @  A       any group member can arbitrarily change  the  group's  RCS A A       files, and can even remove them entirely.  Hence more for- A A       mal projects sometimes distinguish between an RCS adminis- A A       trator,  who  can  change the RCS files at will, and other A A       project members, who can check in new revisions but cannot A &       otherwise change the RCS files. &    
SETUID USE 
 A       To prevent anybody but their RCS administrator from delet- A A       ing revisions, a set of users can employ setuid privileges A        as follows.     A       o Check  that the host supports RCS setuid use.  Consult a A A         trustworthy expert if there are any doubts.  It is  best A                                                       @  A         if the seteuid() system call works as described in Posix A A         1003.1a Draft 5, because RCS can switch back  and  forth A A         easily  between  real  and  effective users, even if the A A         real user is root.  If not, the second best  is  if  the A A         setuid()   system   call   supports  saved  setuid  (the A A         {_POSIX_SAVED_IDS} behavior of Posix 1003.1-1990);  this A A         fails only if the real user is root.  If RCS detects any A 1         failure in setuid, it quits immediately. 1    A       o Choose a user A to serve as RCS  administrator  for  the A A         set  of  users.   Only  A will be able to invoke the rcs A A         command on the users' RCS files.  A should not  be  root A                @  A         or  any other user with special powers.  Mutually suspi- A A         cious sets of users should use different administrators. A    A       o Choose  a  path name B that will be a directory of files A %         to be executed by the users. %    A       o Have A set up B to contain copies of ci and co that  are A A         setuid  to A by copying the commands from their standard A -         installation directory D as follows: -                  mkdir  B                cp  D/c[io]  B  &              chmod  go-w,u+s  B/c[io] &    ;       o Have each user prepend B to their path as follows: ;    ;              PATH=B:$PATH;  export  PATH  # ordinary shell ; -              set  path=(B  $path)  # C shell -                           @  A       o Have A create each RCS directory  R  with  write  access A          only to A as follows:                   mkdir  R                chmod  go-w  R     A       o If  you  want  to  let  only  certain users read the RCS A A         files, put the users into a group G, and have A  further A .         protect the RCS directory as follows: .                  chgrp  G  R  !              chmod  g-w,o-rwx  R !    A       o Have  A  copy  old  RCS files (if any) into R, to ensure A          that A owns them.     A       o An RCS file's access list limits who can  check  in  and A A         lock revisions.  The default access list is empty, which A A         grants checkin access to anyone who  can  read  the  RCS A                  @  A         file.   If  you want limit checkin access, have A invoke A A         rcs -a  on  the  file;  see  rcs.m.     In   particular, A ,         rcs -e -aA limits access to just A. ,    A       o Have  A  initialize any new RCS files with rcs -i before A A         initial checkin, adding the -a option  if  you  want  to A          limit checkin access.     A       o Give  setuid privileges only to ci, co, and rcsclean; do A 6         not give them to rcs or to any other command. 6    A       o Do not use other setuid commands to invoke RCS commands; A +         setuid is trickier than you think! +    DIAGNOSTICS  A       For  each  revision,  ci  prints the RCS file, the working A                                                           @  A       file, and the number of both the deposited and the preced- A A       ing  revision.  The exit status is zero if and only if all A "       operations were successful. "    IDENTIFICATION         Author: Walter F. Tichy.  6       Revision Number: 5.9; Release Date: 1991/10/07. 6 9       Copyright (C) 1982, 1988, 1989 by Walter F. Tichy. 9 /       Copyright (C) 1990, 1991 by Paul Eggert. / A       Ported to MPX-32 05/05/95 by James C. Bevier, J B Systems. A    SEE ALSO  A       co.m,  ident.m,  make.m,  rcs.m,  rcsclean.m,   rcsdiff.m, A 4       rcsintro.m,  rcsmerge.m,  rlog.m,  rcsfile.m  4 A       Walter  F.  Tichy,  RCS--A  System  for  Version  Control, A A       Software--Practice  &  Experience  15,  7   (July   1985), A            j@         637-654.     AGNU - RCS - CI              J B Systems                  05/05/95 A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         