  @  /*~!signal.h*/  */* Name:  signal.h Part No.: _______-____r *  *  - * Copyright 1991 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     ##ident	"@(#)nbinclude:signal.h	1.1" #           @  #ifndef SIGNAL_H  #define SIGNAL_H     #define	SIGHUP	1	/* hangup */  )#define	SIGINT	2	/* interrupt (rubout) */ ) '#define	SIGQUIT	3	/* quit (ASCII FS) */ ' A#define	SIGILL	4	/* illegal instruction (not reset when caught)*/ A :#define	SIGTRAP	5	/* trace trap (not reset when caught) */ : &#define	SIGIOT	6	/* IOT instruction */ & D#define SIGABRT 6	/* used by abort, replace SIGIOT in the  future */ D &#define	SIGEMT	7	/* EMT instruction */ & /#define	SIGFPE	8	/* floating point exception */ / :#define	SIGKILL	9	/* kill (cannot be caught or ignored) */ : !#define	SIGBUS	10	/* bus error */ ! /#define	SIGSEGV	11	/* segmentation violation */ / 3#define	SIGSYS	12	/* bad argument to system call */ 3                                                       @  ?#define	SIGPIPE	13	/* write on a pipe with no one to read it */ ? $#define	SIGALRM	14	/* alarm clock */ $ >#define	SIGTERM	15	/* software termination signal from kill */ > .#define	SIGUSR1	16	/* user defined signal 1 */ . .#define	SIGUSR2	17	/* user defined signal 2 */ . (#define	SIGCLD	18	/* death of a child */ ( *#define	SIGPWR	19	/* power-fail restart */ * '#define SIGWINCH 20	/* window change */ '    &			/* SIGPHONE only used in UNIX/PC */ & 9/*#define SIGPHONE 21*/	/* handset, line status change */ 9    0#	define SIGPOLL 22	/* pollable event occured */ 0    +#define SIGCHLD SIGCLD  /* compatibility */ +    @#	define SIGSTOP 23      /* sendable stop signal not from tty */ @ 3#	define SIGTSTP 24      /* stop signal from tty */ 3             @  9#	define SIGCONT 25      /* continue a stopped process */ 9 G#	define SIGTTIN 26      /* to readers pgrp upon background tty read */ G K#	define SIGTTOU 27      /* like TTIN for output if (tp->t_local&TOSTOP) */ K    =#	define	SIGALL          (~(sigset_t)0L)		/* new for POSIX */ =    B#	define	NSIG	28	/* The valid signal number is from 1 to NSIG-1 */ B <#	define MAXSIG	32	/* size of u_signal[], NSIG-1 <= MAXSIG*/ < +			/* MAXSIG is larger than we need now. */ + .			/* In the future, we can add more signal */ . '			/* number without changing user.h */ '    C#	define	SIG_SETMASK	0	/* set mask in sigprocmask. new for POSIX */ C C#	define	SIG_BLOCK	1	/* union mask in sigprocmask. new for POSIX */ C                                                     @  G#	define	SIG_UNBLOCK	2	/* intrsct mask in sigprocmask. new for POSIX */ G    typedef	long	sigset_t;     1#define         sigbit(n)       (1L << ((n) - 1)) 1 .#define         sigemptyset(s)  *(s) = ~SIGALL . -#define         sigfillset(s)   *(s) = SIGALL - 1#define         sigaddset(s,n)  *(s) |= sigbit(n) 1 2#define         sigdelset(s,n)  *(s) &= ~sigbit(n) 2 F#define         sigismember(set,n) ((*(set) & sigbit(n)) == sigbit(n)) F    6int (*signal ()) ();		/* mpx is int instead of void */ 6    #define SIG_ERR	(int(*)())-1  #define	SIG_DFL	(int(*)())0  #define	SIG_IGN	(int(*)())1  #define SIG_HOLD (int(*)())2     #endif	/* SIGNAL_H */                                                                                             