  @  /*~!dirent.h*/  */* Name:  dirent.h Part No.: _______-____r *  *  - * Copyright 1990 - J B Systems, Morrison, CO -  *  G * The recipient of this product specifically agrees not to distribute, G G * disclose, or disseminate in any way, to any one, nor use for its own G G * benefit, or the benefit of others, any information contained  herein G 8 * without the expressed written consent of J B Systems. 8  *  / *                     RESTRICTED RIGHTS LEGEND /  *  D * Use, duplication, or disclosure by the Government is  subject  to D D * restriction  as  set forth in paragraph (b) (3) (B) of the Rights D D * in Technical Data and Computer Software  Clause  in  DAR  7-104.9 D  * (a).   */     #ifndef DIRENT_H  #define DIRENT_H           @  ##ident	"@(#)nbinclude:dirent.h	1.0" #    /*  <* A directory consists of some number of blocks of DIRBLKSIZ < B* bytes, where DIRBLKSIZ is chosen such that it can be transferred B I* to disk in a single atomic operation (e.g. 768 bytes on Gould machine). I *  ;* Each DIRBLKSIZ byte block contains twelve directory entry ; )* structures, which are of 64 bytes long. ) :* All names are maximum of 16 characters and blank filled. : ;* The maximum length of a name in a directory is MAXNAMLEN. ; *  I* The macro DIRENTSIZ(dp) gives the amount of space required to represent I A* a directory entry.  Free space in a directory is represented by A 1* entries which have bit zero cleared in d_flags. 1 */     #define DIRBLKSIZ 768                          @  8#define DIRBUF		768	/* buffer size for fs-indep. dirs */ 8 #define MAXNAMLEN 16  #ifndef	DIRSIZ  7#define	DIRSIZ	16		/* this is for UNIX compatibility */ 7 #endif  #ifndef DIR_MAX  0#define DIR_MAX 36		/* directory name storage */ 0 #endif     struct dirent {  =  char  d_name[MAXNAMLEN];      /* entry name blank filled */ = :  int   d_date;                 /* binary creation date */ : :  int   d_time;                 /* binary creation time */ : B  int   d_ino;                  /* inode number of rd for entry */ B 7  short d_rdflg;                /* resource ID flags */ 7 3  short d_rtype;                /* resource type */ 3 6                                /* 01 - volume type */ 6                                                         @  ?                                /* 02 - resource descr descr */ ? :                                /* 03 - descr map descr */ : :                                /* 04 - space map descr */ : 9                                /* 05 - root dir descr */ 9 =                                /* 06 - system image descr */ = :                                /* 07 - bad block descr */ : ;                                /* 08 - spool file descr */ ; >                                /* 09 - extra seg def descr */ > 4                                /* 10 - perm file */ 4 3                                /* 11 - perm dir */ 3 4                                /* 12 - temp file */ 4 3                                /* 13 - temp dir */ 3                                  @  :                                /* 14 - static mem part */ : 9                                /* 15 - dynam mem part */ 9 7                                /* 16 - device descr */ 7 6                                /* 17 - rd for DMAP */ 6 6                                /* 18 - rd for SMAP */ 6 5  int   d_colct;                /* collision count */ 5 :  int   d_hshct;                /* hash count for entry */ : M  int   d_flags;                /* flags - bit zero set means active entry */ M ;  int   d_diri;                 /* directory entry index */ ; A  char  d_ownr[8];              /* owner name of entry creator */ A ,  char  d_fill[8];              /* filler */ ,   };     /*                                                                    @  =* The DIRENTSIZ macro gives the record length which will hold = * the directory entry.  */     #undef DIRENTSIZ  .#define DIRENTSIZ(dp) (sizeof (struct dirent)) .    /*  <* Definitions for library routines operating on directories. < */     typedef struct _dirdesc {  >  int  dd_fd;           /* file descriptor used to read dir */ > 2  long dd_loc;          /* current entry number */ 2 A  long dd_size;         /* directory size in bytes (DIRBLKSIZ) */ A 4  char *dd_buf;		/* buffer to read directory into */ 4 ,  char dd_dir[DIR_MAX];	/* directory name */ , )} DIR;			/* stream data from opendir() */ )    #ifndef NULL  #define NULL 0  #endif     <extern struct dirent	*readdir ();       /* unix interface */ <                      @  ;extern struct dirent	*readmdir ();      /* mpx interface */ ; extern DIR		*opendir();  extern long		telldir();  extern void		seekdir();  extern int		closedir();  extern void		rewinddir();     #endif                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  