  @     	     NAME 	 1          varargs - handle variable argument list 1         SYNTAX            #include <varargs.h>               va_alist               va_dcl               void va_start(pvar)            va_list pvar;     !          type va_arg(pvar, type) !           va_list pvar;               void va_end(pvar)            va_list pvar;          DESCRIPTION  C          This set of macros allows portable procedures that accept C D          variable argument lists to be written.  Routines that have D C          variable argument lists (such as printf()) but do not use C C          varargs are inherently nonportable, as different machines C 5          use different argument-passing conventions. 5                     @  C          va_alist defines the parameter list in a function header. C    B          va_dcl defines a declaration for va_alist.  No semicolon B           should follow va_dcl.     A          va_list defines a type defined for the variable used to A           traverse the list.     A          va_start initializes pvar to the beginning of the list. A    D          va_arg returns the next argument in the list pointed to by D A          pvar.  Type is the type the argument is expected to be. A F          Different types can be mixed, but it is up to the routine to F A          know what type of argument is expected, as it cannot be A            determined at runtime.      0          va_end defines a variable to clean up. 0                   @  F          Multiple traversals, each bracketed by va_start ...  va_end, F           are possible.          EXAMPLE  @          This example is a possible implementation of vexecl(). @    (                    #include <varargs.h> ( +                    #define MAXARGS     100 +    +                    /*  vexecl is called by + F                             vexecl(file, arg1, arg2, ..., (char *)0); F                     */  $                    vexecl(va_alist) $                     va_dcl                      {  $                         va_list ap; $ $                         char *file; $ -                         char *args[MAXARGS]; - '                         int argno = 0; '    &                         va_start(ap); &            @  3                         file = va_arg(ap, char *); 3 R                         while ((args[argno++] = va_arg(ap, char *)) != (char *)0) R                               ;  $                         va_end(ap); $ 3                         return vexecv(file, args); 3                     }     
     SEE ALSO 
           exec.m, printf.m          SPECIAL CONSIDERATIONS  =          It is up to the calling routine to specify how many = A          arguments there are, since it is not always possible to A F          determine this from the stack frame.  For example, vexecl is F F          passed a zero pointer to signal the end of the list.  Printf F >          can tell how many arguments are there by the format. >                                @  A          It is nonportable to specify a second argument of char, A @          short, or float to va_arg, since arguments seen by the @ D          called function are not char, short, or float.  C converts D F          char and short arguments to int and converts float arguments F 6          to double before passing them to a function. 6    *          (printed 07/30/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                              