  @     	     NAME 	 9          utime - set file access and modification times. 9         SYNTAX             #include <sys/types.h>   !          int utime (path, times) !           char *path;             struct utimbuf *times;           DESCRIPTION  B          Path points to a pathname naming a file.  Utime sets the B :          access and modification times of the named file. :    D          If times is NULL, the access and modification times of the D B          file are set to the current time.  A process must be the B D          owner of the file or have write permission to use utime in D           this manner.     F          If times is not NULL, times is interpreted as a pointer to a F                                                  @  E          utimbuf structure and the access and modification times are E B          set to the values contained in the designated structure. B D          Only the owner of the file or the super-user may use utime D           this way.     F          The times in the following structure are measured in seconds F +          since 00:00:00 GMT, Jan. 1, 1970. +    !                struct  utimbuf { ! 9                      time_t actime;    /* access time */ 9 ?                      time_t modtime;   /* modification time */ ?                 };     C          Utime will fail if one or more of the following are true: C    8                The named file does not exist.  [ENOENT] 8                                                                 @  B                A component of the path prefix is not a directory. B                 [ENOTDIR]     F                Search permission is denied by a component of the path F                  prefix. [EACCES]      >                The user is not super-user (system) or not the > A                owner of the file and times is not NULL.  [EPERM] A    >                The user is not super-user (system) or not the > G                owner of the file and times is NULL and write access is G                  denied. [EACCES]      A                Times is not NULL and points outside the process' A 2                allocated address space.  [EFAULT] 2    B                Path points outside the process' allocated address B                         R@                   space.  [EFAULT]      
     SEE ALSO 
           stat.m          RETURN VALUE  ?          Upon successful completion, a value of 0 is returned. ? B          Otherwise, a value of -1 is returned and errno is set to B           indicate the error.     *          (printed 05/31/94 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                                                                                                 