  @     	     NAME 	 E          tsearch, tfind, tdelete, twalk - manage binary search trees E         SYNTAX            #include <search.h>     ?          char *tsearch ((char *) key, (char **) rootp, compar) ?           int (*compar)( );     =          char *tfind ((char *) key, (char **) rootp, compar) =           int (*compar)( );     ?          char *tdelete ((char *) key, (char **) rootp, compar) ?           int (*compar)( );     ,          void twalk ((char *) root, action) ,           void (*action)( );          DESCRIPTION  =          Tsearch, tfind, tdelete, and twalk are routines for = F          manipulating binary search trees.  They are generalized from F                                                                @  E          Knuth (6.2.2) Algorithms T and D.  All comparisons are done E D          with a user-supplied routine.  This routine is called with D E          two arguments, the pointers to the elements being compared. E D          It returns an integer less than, equal to, or greater than D =          0, according to whether the first argument is to be = C          considered less than, equal to or greater than the second C C          argument.  The comparison function need not compare every C E          byte, so arbitrary data may be contained in the elements in E 0          addition to the values being compared. 0    A          Tsearch is used to build and access the tree.  key is a A                                                                    @  E          pointer to a datum to be accessed or stored.  If there is a E B          datum in the tree equal to *key (the value pointed to by B F          key), a pointer to this found datum is returned.  Otherwise, F ?          *key is inserted, and a pointer to it returned.  Only ? D          pointers are copied, so the calling routine must store the D F          data.  rootp points to a variable that points to the root of F F          the tree.  A NULL value for the variable pointed to by rootp F C          denotes an empty tree; in this case, the variable will be C D          set to point to the datum which will be at the root of the D           new tree.     B          Like tsearch, tfind will search for a datum in the tree, B                   @  D          returning a pointer to it if found.  However, if it is not D E          found, tfind will return a NULL pointer.  The arguments for E ,          tfind are the same as for tsearch. ,    @          Tdelete deletes a node from a binary search tree.  The @ F          arguments are the same as for tsearch.  The variable pointed F F          to by rootp will be changed if the deleted node was the root F F          of the tree.  Tdelete returns a pointer to the parent of the F C          deleted node, or a NULL pointer if the node is not found. C    D          Twalk traverses a binary search tree.  root is the root of D D          the tree to be traversed.  (Any node in a tree may be used D                                                        @  E          as the root for a walk below that node.) Action is the name E D          of a routine to be invoked at each node.  This routine is, D F          in turn, called with three arguments.  The first argument is F E          the address of the node being visited.  The second argument E A          is a value from an enumeration data type typedef enum { A F          preorder, postorder, endorder, leaf } VISIT; (defined in the F C          <search.h> header file), depending on whether this is the C D          first, second or third time that the node has been visited D F          (during a depth-first, left-to-right traversal of the tree), F C          or whether the node is a leaf.  The third argument is the C                                         @  B          level of the node in the tree, with the root being level B           zero.     D          The pointers to the key and the root of the tree should be D B          of type pointer-to-element, and cast to type pointer-to- B C          character.  Similarly, although declared as type pointer- C C          to-character, the value returned should be cast into type C           pointer-to-element.          EXAMPLE  C          The following code reads in strings and stores structures C @          containing a pointer to each string and a count of its @ B          length.  It then walks the tree, printing out the stored B :          strings and their lengths in alphabetical order. :    "               #include <search.h> "                  @  !               #include <stdio.h> !    <              /* pointers to these are stored in the tree */ <                struct node {  !                    char *string; !                     int length;                 };  I               char string_space[10000];     /* space to store strings */ I A               struct node nodes[500];       /* nodes to store */ A J               struct node *root = NULL;     /* this points to the root */ J                   main( )                 {  0                    char *strptr = string_space; 0 1                    struct node *nodeptr = nodes; 1 1                    void print_node( ), twalk( ); 1 /                    int i = 0, node_compare( ); /                                               @  @                    while (gets(strptr) != NULL && i++ < 500)  { @ '                         /* set node */ ' 2                         nodeptr->string = strptr; 2 :                         nodeptr->length = strlen(strptr); : 5                         /* put node into the tree */ 5 ?                         (void) tsearch((char *)nodeptr, &root, ? .                                node_compare); . J                         /* adjust pointers, so we don't overwrite tree */ J 7                         strptr += nodeptr->length + 1; 7 #                         nodeptr++; #                     }  ,                    twalk(root, print_node); ,                }                 /*  @                    This routine compares two nodes, based on an @     @  >                    alphabetical ordering of the string field. >                */                 int  )               node_compare(node1, node2) ) *               struct node *node1, *node2; *                {  @                    return strcmp(node1->string, node2->string); @                }                 /*  B                    This routine prints out a node, the first time B (                    twalk encounters it. (                */                    void  -               print_node(node, order, level) - "               struct node **node; "                VISIT order;                 int level;                 {  >                    if (order == preorder || order == leaf)  { >                                       @  F                         (void)printf("string = %20s,  length = %d\n", F @                              (*node)->string, (*node)->length); @                     }                 }     
     SEE ALSO 
 )          bsearch.m, hsearch.m, lsearch.m )         DIAGNOSTICS  F          A NULL pointer is returned by tsearch if there is not enough F /          space available to create a new node. / E          A NULL pointer is returned by tsearch, tfind and tdelete if E !          rootp is NULL on entry. ! @          If the datum is found, both tsearch and tfind return a @ A          pointer to it.  If not, tfind returns NULL, and tsearch A 1          returns a pointer to the inserted item. 1    
     WARNINGS 
                                      @  E          The root argument to twalk is one level of indirection less E :          than the rootp arguments to tsearch and tdelete. : C          There are two nomenclatures used to refer to the order in C ?          which tree nodes are visited.  Tsearch uses preorder, ? D          postorder and endorder to respectively refer to visiting a D C          node before any of its children, after its left child and C =          before its right, and after both its children.  The = E          alternate nomenclature uses preorder, inorder and postorder E A          to refer to the same visits, which could result in some A 2          confusion over the meaning of postorder. 2         SPECIAL CONSIDERATIONS                                                     @  A          If the calling function alters the pointer to the root, A $          results are unpredictable. $    *          (printed 07/29/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      