  @     	     NAME 	 B          opendir, readdir, readmdir, telldir, seekdir, rewinddir, B )          closedir - directory operations )         SYNTAX            #include <dir.h>             #include <sys/types.h>      !          DIR *opendir (filename) !           char *filename;     '          struct dirent *readdir (dirp) '           DIR *dirp;     (          struct dirent *readmdir (dirp) (           DIR *dirp;               long telldir (dirp)            DIR *dirp;     "          void seekdir (dirp, loc) "           DIR *dirp;            long loc;               void rewinddir (dirp)            DIR *dirp;               void closedir(dirp)            DIR *dirp;          DESCRIPTION                           @  E          Opendir opens the directory named by filename, associates a E C          ``directory stream'' with it, and returns a pointer to be C =          used to identify the directory stream in subsequent = F          operations.  NULL is returned if filename cannot be accessed F ?          or is not a directory, or if not enough memory can be ? 8          obtained via malloc() to hold a DIR structure. 8    C          Readdir returns a pointer to the next directory entry and C D          advances the ``current position'' of the directory stream. D C          It returns NULL upon reaching the end of the directory or C E          upon detecting an invalid previous seekdir operation.  This E                                                              @  F          is the UNIX compatable interface and returns UNIX filenames. F    D          Readmdir returns a pointer to the next directory entry and D D          advances the ``current position'' of the directory stream. D C          It returns NULL upon reaching the end of the directory or C E          upon detecting an invalid previous seekdir operation.  This E 9          is the MPX interface and returns MPX filenames. 9    B          Telldir returns the current position associated with the B =          directory stream.  Always returns 0 for MPX-32 1.X. =    E          Seekdir sets the position for the next readdir operation on E D          the directory stream.  The new position reverts to the one D                                              @  @          associated with the directory stream when the previous @ F          telldir operation from which loc was obtained was performed. F F          Values returned by telldir are good only for the lifetime of F @          the DIR structure from which they are derived.  If the @ C          directory is closed and then reopened, the location value C E          from telldir may be invalidated due to undetected directory E A          compaction.  It is safe to use a previous telldir value A E          immediately after a call to opendir and before any calls to E :          readdir.  This entry does nothing on MPX-32 1.X. :    F          Rewinddir resets the position of the directory stream to the F                                                     @  B          beginning of the directory.  This entry does nothing on  B           MPX-32 1.X.     <          Closedir closes the directory stream and frees the < #          associated DIR structure. #         EXAMPLE  E          Sample code that searches a directory for an entry matching E           name:     *                    dirp = opendir( "." ); * <                    while ( (dp = readdir( dirp )) != NULL ) < ?                         if ( strcmp( dp->d_name, name ) == 0 ) ?                               {  /                              closedir( dirp ); / +                              return FOUND; +                               }  %                    closedir( dirp ); % %                    return NOT_FOUND; %              @  
     SEE ALSO 
 *          open.m, close.m, read.m, lseek.m *    
     WARNINGS 
 F          Rewinddir is implemented as a macro, so its function address F           cannot be taken.     >          All UNIX programs that examine directories should be > E          converted to use this package, since directory format is no E C          longer the same on all UNIX systems.  Unfortunately, this C <          package is not yet supplied with all UNIX systems. <    *          (printed 07/29/92 - J B Systems) *                                                                                                                                                                                                                                               