  @     	     NAME 	 ,          open - open for reading or writing ,         SYNTAX            #include <fcntl.h>     ,          int open (path, oflag [ , mode ] ) ,           char *path;            int oflag, mode;          DESCRIPTION  F          Path points to a path name naming a file.  Open opens a file F F          descriptor for the named file and sets the file status flags F <          according to the value of oflag.  Oflag values are < C          constructed by or-ing flags from the following list (only C :          one of the first three flags below may be used): :    )          O_RDONLY Open for reading only. )    )          O_WRONLY Open for writing only. )    0          O_RDWR   Open for reading and writing. 0         @  D          O_NDELAY This flag may affect subsequent reads and writes. D F                   See read.m and write.m.  This flag is not supported F D                   on MPX.  I/O is always issued as wait mode by the D %                   C runtime library. %    E          O_APPEND If set, the file pointer will be set to the end of E 0                   the file prior to each write. 0    ?          O_CREAT  If the file exists, this flag has no effect. ? C                   Otherwise, the low-order 9 bits (18 bits) of the C H                   file mode are set to the value of mode, if specified. H D                   The mode may be specified as MPX bits (RWMUAD) or D C                   UNIX style bits (RWX).  If the mode specified is C             @  D                   zero, the current default access rights in effect D <                   for setacc() will be used.  See setacc.m. <    C          O_TRUNC  If the file exists, its length is truncated to 0 C C                   and the mode and owner are unchanged.  This flag C $                   is unused on MPX. $    C          O_EXCL   If O_EXCL and O_CREAT are set, open will fail if C @                   the file exists.  This flag is unused on MPX. @    D          O_UNBLK  This flag specifies that the file is to opened in D F                   unblocked mode.  This flag is specific only to MPX. F    D          O_BIN    This flag specifies that the file is to opened in D                                                                     @  E                   blocked mode.  No newline translation will be made E D                   for read or write operations.  This is useful for D E                   reading or writing MPX object files.  This flag is E (                   specific only to MPX. (    D          O_DWAIT  This flag specifies that the file is to be opened D D                   only if it must not wait.  If the file is already D E                   opened by another task in an incompatable mode, an E C                   immediate return is made to the user.  This flag C +                   is specific only to MPX. +    C          The file pointer used to mark the current position within C 7          the file is set to the beginning of the file. 7                         @  F          The named file is opened unless one or more of the following F           are true:     @          [ENOTDIR]      A component of the path prefix is not a @ #                         directory. #    C          [ENOENT]       O_CREAT is not set and the named file does C #                         not exist. #    E          [EACCES]       A component of the path prefix denies search E $                         permission. $    A          [EACCES]       Oflag permission is denied for the named A                          file.     C          [EISDIR]       The named file is a directory and oflag is C -                         write or read/write. -    F          [EMFILE]       OPEN_MAX file descriptors are currently open. F        @  B          [EFAULT]       Path points outside the allocated address B .                         space of the process. .    B          [EEXIST]       O_CREAT and O_EXCL are set, and the named B 7                         file exists.  Not used on MPX. 7         RETURN VALUE  F          Upon successful completion, the file descriptor is returned. F E          Otherwise, a value of -1 (EOF) is returned and errno is set E            to indicate the error.      
     SEE ALSO 
 A          chmod.m, close.m, creat.m, lseek.m, setacc.m, getacc.m, A 7          setsiz.m, settype.m, read.m, umask.m, write.m 7         SPECIAL CONSIDERATIONS  D          MPX files are opened in blocked mode by default.  Newline  D                                           z@  C          translation is completed during read or write operations. C    B          All blocked file I/O is handled internally by the unixio B B          runtime module.  Eight sectors (6144 bytes) are buffered B A          internally.  Blocked files are opened in unblocked mode A           for processing.     *          (printed 05/31/94 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                                                         