  @     	     NAME 	 E          memccpy, memchr, memcmp, memcpy, memset - memory operations E         SYNTAX            #include <memory.h>     &          char *memccpy (s1, s2, c, n) &           char *s1, *s2;            int c, n;                char *memchr (s, c, n)             char *s;            int c, n;                int memcmp (s1, s2, n)             char *s1, *s2;            int n;     "          char *memcpy (s1, s2, n) "           char *s1, *s2;            int n;                char *memset (s, c, n)             char *s;            int c, n;          DESCRIPTION  F          These functions operate as efficiently as possible on memory F =          areas (arrays of characters bounded by a count, not =      @  E          terminated by a null character).  They do not check for the E 0          overflow of any receiving memory area. 0    @          Memccpy copies characters from memory area s2 into s1, @ E          stopping after the first occurrence of character c has been E C          copied, or after n characters have been copied, whichever C C          comes first.  It returns a pointer to the character after C F          the copy of c in s1, or a NULL pointer if c was not found in F '          the first n characters of s2. '    =          Memchr returns a pointer to the first occurrence of = F          character c in the first n characters of memory area s, or a F +          NULL pointer if c does not occur. +                                         @  ?          Memcmp compares its arguments, looking at the first n ? F          characters only, and returns an integer less than, equal to, F F          or greater than 0, according as s1 is lexicographically less F -          than, equal to, or greater than s2. -    C          Memcpy copies n characters from memory area s2 to s1.  It C           returns s1.     D          Memset sets the first n characters in memory area s to the D .          value of character c.  It returns s. .    	     NOTE 	 C          For user convenience, all these functions are declared in C %          the <string.h> header file. %         SPECIAL CONSIDERATIONS  E          Memcmp uses native character comparison, which is signed on E                                 @  E          some systems, and unsigned on others.  Thus the sign of the E F          value returned when one of the characters has its high-order F .          bit set is implementation-dependent. .    B          Character movement is performed differently in different B <          implementations.  Thus overlapping moves may yield <           surprises.     *          (printed 07/29/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                           