  @     	     NAME 	 !          lsearch - linear search !         SYNTAX            #include <stdio.h>            #include <search.h>     9          char *lsearch ((char *)key, (char *)base, nelp, 9           sizeof(*key), compar)            unsigned *nelp;            int (*compar)( );          DESCRIPTION  C          Lsearch is a linear search routine generalized from Knuth C ?          (6.1) Algorithm S.  It returns a pointer into a table ? C          indicating where a datum may be found.  If the datum does C E          not occur, it is added at the end of the table.  key points E E          to the datum to be sought in the table.  base points to the E @          first element in the table.  nelp points to an integer @               @  F          containing the current number of elements in the table.  The F D          integer is incremented if the datum is added to the table. D F          compar is the name of the comparison function which the user F C          must supply (strcmp, for example).  It is called with two C C          arguments that point to the elements being compared.  The C A          function must return zero if the elements are equal and A           non-zero otherwise.     
     NOTES 
 D          The pointers to the key and the element at the base of the D F          table should be of type pointer-to-element, and cast to type F           pointer-to-character.     A          The comparison function need not compare every byte, so A                          @  E          arbitrary data may be contained in the elements in addition E '          to the values being compared. '    C          Although declared as type pointer-to-character, the value C ?          returned should be cast into type pointer-to-element. ?         EXAMPLE  B          This fragment will read in < TABSIZE strings of length < B C          ELSIZE and store them in a table, eliminating duplicates. C    !               #include <stdio.h> ! "               #include <search.h> "    !               #define TABSIZE 50 ! !               #define ELSIZE 120 !    I                    char line[ELSIZE], tab[TABSIZE][ELSIZE], *lsearch( ); I %                    unsigned nel = 0; % "                    int strcmp( ); "                       @                      . . .  @                    while (fgets(line, ELSIZE, stdin) != NULL && @ %                       nel < TABSIZE) % @                         (void) lsearch(line, (char *)tab, &nel, @ 0                                ELSIZE, strcmp); 0                     . . .     
     SEE ALSO 
 *          bsearch.m, hsearch.m, tsearch.m. *         DIAGNOSTICS  ?          If the searched for datum is found, lsearch returns a ? A          pointer to it.  Otherwise, lsearch returns a pointer to A "          the newly added element. "         SPECIAL CONSIDERATIONS  D          Undefined results can occur if there is not enough room in D &          the table to add a new item. &    *          (printed 07/29/92 - J B Systems) *        @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         