  @     	     NAME 	 @          hsearch, hcreate, hdestroy - manage hash search tables @         SYNTAX            #include <search.h>     '          ENTRY *hsearch (item, action) '           ENTRY item;            ACTION action;               int hcreate (nel)            unsigned nel;               void hdestroy ( )          DESCRIPTION  A          Hsearch is a hash-table search routine generalized from A D          Knuth (6.4) Algorithm D.  It returns a pointer into a hash D @          table indicating the location at which an entry can be @ C          found.  Item is a structure of type ENTRY (defined in the C C          <search.h> header file) containing two pointers: item.key C                                                 @  C          points to the comparison key, and item.data points to any C B          other data to be associated with that key.  (Pointers to B B          types other than character should be cast to pointer-to- B F          character.) Action is a member of an enumeration type ACTION F A          indicating the disposition of the entry if it cannot be A F          found in the table.  ENTER indicates that the item should be F >          inserted in the table at an appropriate point.  FIND > ?          indicates that no entry should be made.  Unsuccessful ? B          resolution is indicated by the return of a NULL pointer. B    D          Hcreate allocates sufficient space for the table, and must D                                                        @  F          be called before hsearch is used.  Nel is an estimate of the F F          maximum number of entries that the table will contain.  This F D          number may be adjusted upward by the algorithm in order to D @          obtain certain mathematically favorable circumstances. @    D          Hdestroy destroys the search table, and may be followed by D "          another call to hcreate. "    
     NOTES 
 A          Hsearch uses open addressing with a multiplicative hash A D          function.  However, its source code has many other options D F          available which the user may select by compiling the hsearch F :          source with the following symbols defined to the :           preprocessor:                                     @  B               DIV      Use the remainder modulo table size as the B C                        hash function instead of the multiplicative C "                        algorithm. "    B               USCR     Use a User Supplied Comparison Routine for B C                        ascertaining table membership.  The routine C F                        should be named hcompar and should behave in a F E                        manner similar to strcmp (refer to string.m). E    D               CHAINED  Use a linked list to resolve collisions.  If D D                        this option is selected, the following other D 1                        options become available. 1    D                        START     Place new entries at the beginning D             @  C                                  of the linked list (default is at C +                                  the end). +    D                        SORTUP    Keep the linked list sorted by key D 5                                  in ascending order. 5    D                        SORTDOWN  Keep the linked list sorted by key D 6                                  in descending order. 6    B          Additionally, there are preprocessor flags for obtaining B F          debugging printout (-DDEBUG) and for including a test driver F E          in the calling routine (-DDRIVER).  Consult the source code E           for further details.          EXAMPLE  @          The following example reads in strings followed by two @                                @  =          numbers and stores them in a hash table, discarding = C          duplicates.  It then reads in strings, finds the matching C 5          entry in the hash table, and prints it out. 5    !               #include <stdio.h> ! "               #include <search.h> "    M               struct info {       /* this is the info stored in the table */ M <                    int age, room; /* other than the key. */ <                };  N               #define NUM_EMPL    5000    /* # of elements in search table */ N                   main( )                 {  0                    /* space to store strings */ 0 3                    char string_space[NUM_EMPL*20]; 3 6                    /* space to store employee info */ 6                      @  5                    struct info info_space[NUM_EMPL]; 5 :                    /* next avail space in string_space */ : 1                    char *str_ptr = string_space; 1 8                    /* next avail space in info_space */ 8 7                    struct info *info_ptr = info_space; 7 9                    ENTRY item, *found_item, *hsearch( ); 9 3                    /* name to look for in table */ 3 *                    char name_to_find[30]; *                     int i = 0;     &                    /* create table */ & -                    (void) hcreate(NUM_EMPL); - C                    while (scanf("%s%d%d", str_ptr, &info_ptr->age, C G                           &info_ptr->room) != EOF && i++ < NUM_EMPL) { G                                   @  K                         /* put info in structure, and structure in item */ K ,                         item.key = str_ptr; , 6                         item.data = (char *)info_ptr; 6 8                         str_ptr += strlen(str_ptr) + 1; 8 $                         info_ptr++; $ 2                         /* put item into table */ 2 5                         (void) hsearch(item, ENTER); 5                     }     &                    /* access table */ & ,                    item.key = name_to_find; , :                    while (scanf("%s", item.key) != EOF) { : I                        if ((found_item = hsearch(item, FIND)) != NULL) { I 6                         /* if item is in the table */ 6                                                   @  H                         (void)printf("found %s, age = %d, room = %d\n", H .                              found_item->key, . E                              ((struct info *)found_item->data)->age, E G                              ((struct info *)found_item->data)->room); G                          } else {   >                         (void)printf("no such employee %s\n", > +                              name_to_find) +                         }                      }                 }     
     SEE ALSO 
 =          bsearch.m, lsearch.m, malloc.m, string.m, tsearch.m =         DIAGNOSTICS  E          Hsearch returns a NULL pointer if either the action is FIND E D          and the item could not be found or the action is ENTER and D          @            the table is full.     E          Hcreate returns zero if it cannot allocate sufficient space E           for the table.          WARNING  =          Hsearch and hcreate use malloc() to allocate space. =         SPECIAL CONSIDERATIONS  E          Only one hash search table may be active at any given time. E    *          (printed 07/29/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                                      