  @     	     NAME 	 C          getc, getchar, fgetc, getw - get character or word from a C           stream          SYNTAX            #include <stdio.h>               int getc (stream)            FILE *stream;               int getchar ()               int fgetc (stream)            FILE *stream;               int getw (stream)            FILE *stream;          DESCRIPTION  E          Getc returns the next character (i.e., byte) from the named E >          input stream, as an integer.  It also moves the file > F          pointer, if defined, ahead one character in stream.  Getchar F B          is defined as getc(stdin).  Getc and getchar are macros. B                                                                      @  B          Fgetc behaves like getc, but is a function rather than a B E          macro.  Fgetc runs more slowly than getc, but it takes less E ?          space per invocation and its name can be passed as an ? !          argument to a function. !    C          Getw returns the next word (i.e., integer) from the named C E          input stream.  Getw increments the associated file pointer, E D          if defined, to point to the next word.  The size of a word D >          is the size of an integer and varies from machine to > B          machine.  Getw assumes no special alignment in the file. B    
     SEE ALSO 
 7          fclose.m, ferror.m, fopen.m, fread.m, gets.m, 7           putc.m, scanf.m          DIAGNOSTICS                          @  C          These functions return the constant EOF at end-of-file or C B          upon an error.  Because EOF is a valid integer, ferror() B /          should be used to detect getw errors. /         WARNING  E          If the integer value returned by getc, getchar, or fgetc is E D          stored into a character variable and then compared against D E          the integer constant EOF, the comparison may never succeed, E F          because sign-extension of a character on widening to integer F           is machine-dependent.          SPECIAL CONSIDERATIONS  ;          Because it is implemented as a macro, getc treats ; >          incorrectly a stream argument with side effects.  In >                                                           @  F          particular, getc(*f++) does not work sensibly.  Fgetc should F           be used instead.     A          Because of possible differences in word length and byte A C          ordering, files written using putw are machine-dependent, C B          and may not be read using getw on a different processor. B    *          (printed 07/30/92 - J B Systems) *                                                                                                                                                                                                                                                                                                                                                                                                    