/*~!mosde.h*/
/* Name:  mosde.h Part No.: _______-____r
 *
 * Copyright 1995 - J B Systems, Morrison CO.
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ifndef MOSDE_H
#define MOSDE_H

#ident	"@(#)nbinclude:mosde.h	1.1"

/* MPX  C dot equates */
#define    C_CDTA      0x0a94	/* CDT address */
#define    C_TSAD      0x0a80	/* TSA address */
#define    C_CURR      0x08e8	/* Current DQE address */

#define    DQE_ON      0x010	/* Ownername associated with task */
#define    DQE_PSN     0x020	/* Pseudonym associated with task */

#ifdef MPX1X
#define    C_CDTN      0x0c28	/* MPX 1.X address */
#define    C_UDTN      0x0c32	/* MPX 1.X address */
#define    C_UDTA      0x0b40	/* MPX 1.X address */
#define    T_LINBUF    0x05f0	/* MPX 1.X address */
#define	   T_PRNO      0x05cc	/* MPX 1.X address */
#define    T_LBSI      0x09	/* MPX 1.X line buf scan index offset */
#define    T_LBLEN     0x08	/* MPX 1.X line buf length len in wds offset */
/* equates for SMT's */
#define    C_SMTA       0xb04   /* Shared memory table address */
#define    C_SMTS       0xcba   /* Shared memory table size */
#define    C_SMTN       0xcad   /* Number of table entries */
/* equates for DQE's */
#define    C_DQEU       0xaa4	/* address of 1st dqe */
#define    C_NQUE       0xcab	/* number of dqe entries 1 byte */
#define    C_MTIM      0x0ae4	/* Clock interrupts per second */
#define    C_NTIM      0x0aec	/* Clock interrupts per time unit */

#else /* MPX2X & MPX3X */
#ifdef DEFS_FOR_MPX2X

#define    C_CDTN      0x0c30	/* MPX 2.X address */
#define    C_UDTN      0x0c38	/* MPX 2.X address */
#define    C_UDTA      0x0b38	/* MPX 2.X address */
#define	   T_PRNO      0x06dc	/* MPX 2.X address */
#define    T_LINBUF    0x0738	/* MPX 2.X address */
#define    T_LBSI      0x011	/* MPX 2.X line buf scan index offset */
#define    T_LBLEN     0x010	/* MPX 2.X line buf length len in wds offset */
/* equates for SMT's */
#define    C_SMTA       0xaf4
#define    C_SMTS       0xcc2
#define    C_SMTN       0xcb7
/* equates for DQE's */
#define    C_NDQE       0xcb5	/* number of dqe entries 1 byte */
#define    C_DQEA       0xa9c	/* address of 1st dqe */
#define    C_MTIM      0x0adc	/* Clock interrupts per second */
#define    C_NTIM      0x0ae0	/* Clock interrupts per time unit */
#endif

/* Defines for MPX 3X, these are the same as MPX 2.4 */
#define    C_CDTN      0x0c30	/* MPX 3.X address */
#define    C_UDTN      0x0c38	/* MPX 3.X address */
#define    C_UDTA      0x0b38	/* MPX 3.X address */
#define	   T_PRNO      0x06dc	/* MPX 3.X address */
#define    T_LINBUF    0x0738	/* MPX 3.X address */
#define    T_LBSI      0x011	/* MPX 3.X line buf scan index offset */
#define    T_LBLEN     0x010	/* MPX 3.X line buf length len in wds offset */
/* equates for SMT's */
#define    C_SMTA       0xaf4
#define    C_SMTS       0xcc2
#define    C_SMTN       0xcb7
/* equates for DQE's */
#define    C_NDQE       0xcb5	/* number of dqe entries 1 byte */
#define    C_DQEA       0xa9c	/* address of 1st dqe */
#define    C_MTIM      0x0adc	/* Clock interrupts per second */
#define    C_NTIM      0x0ae0	/* Clock interrupts per time unit */
#endif

/* equates for CDT's */
#define    CDT_CHAN     0x12
#define    CDT_FLAGS    0x18
#define    CDT_UT0      0x20
#define    CDT_SIZE     0x60

/* equates for UDT's */
#define    UDT_STAT     0x04
#define    UDT_CHAN     0x06
#define    UDT_CHAR     0x0e
#define    UDT_LINE     0x0f
#define    UDT_STA2     0x3e
#define    UDT_SIZE     0x40

/* equates for DQE's */
#define    C_ADAT       0xa88 /* address of dqe address table */

#endif
