/* code.c */
/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 * 	(c) Copyright 1990 J B Systems
 *	This file contains non-based support modifications
 *	for operation under MPX.  Derived from Encores' base
 *	mode C compiler.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: code.c,v 5.5 89/05/12 12:43:16 pcc Rel-3_0 $";
#endif

/*
    C compiler for Gould processors, base register instruction set.

    Ported from the 4.1c Berkeley Standard
	Distribution source for a VAX portable C compiler.
*/
#include "mfile1.h"
#if !defined(unix) && !defined(i386)
#include <types.h>
#else
#include <sys/types.h>
#endif

#ifdef i386
#define u370 1
#undef i386
#include <a.out.h>
#define i386
#else /* i386 */
#include <a.out.h>
#include "stab.h"
#endif /* i386 */

extern int lflag;

#ifdef MPX
int	handopt = 0;		/* handler option word */
#endif /* MPX */
int	proflg = 0;		/* are we generating profiling code? */
int	strftn = 0;		/* is the current function one which returns a value */
int	gdebug;			/* debugger symbols output if set */
int	fdefflag;		/* are we within a function definition ? */
int	SAflag;			/* warn if first arg is a struct */
char	NULLNAME[8];
int	labelno;
char	progname[16];		/* saved program name */
char	currprog[40];		/* copy of ftitle when progname set */
int	slineno;		/* last line number from orig file */

branch(n)
{
/* output a branch to label n */
/* exception is an ordinary function branching to retlab: then, return */
    if( n == retlab && !strftn ) {

#ifdef ONEPASS
            LclReturn(n);
#else
	    if ( retstat & RETVAL ) {
        	printf("%c%d\t%d\t\n", IRETURN, n, 1);
	    } else {
        	printf("%c%d\t%d\t\n", IRETURN, n, 0);
	    }
#endif

	/* do NOT put a retstat = 0 here!!!! */
    } else {

#ifdef ONEPASS
#ifndef NOCAID
    	    if(lflag)
    		lineid(lineno, ftitle);
#endif
     	    printf("	bu 	L%d\n", n);
#else
            printf( "%c%d\t\n", IBRANCH, n);
#endif

    }
}

#ifndef TESTING
int         lastloc = STAB;
#else
int         lastloc = PROG;
#endif

short       log2tab[] =
{
    0, 0, 1, 2, 2, 3, 3, 3, 3
};
#define LOG2SZ 9

defalign(n)
{
 /* cause the alignment to become a multiple of n */
    n /= SZCHAR;
    if (lastloc != PROG && n > 1)
#ifdef UAS
	printf("	bound	%d\n", n);
#else
	printf("	.align	%d\n", n >= 0 && n < LOG2SZ ? log2tab[n] : 0);
#endif
}

locctr(l)
{
    register    temp;
 /* l is PROG, ADATA, DATA, STRNG, ISTRNG, or STAB */

    if (l == lastloc )
	return(l);
    temp = lastloc;
    lastloc = l;
    switch (l) {

	case PROG:
#ifdef UAS
#ifdef MPX
	    if (handopt)
#ifdef TWOPASS
		printf ("%cdsect\n",IDATA);	/* all o/s code is dsect */
#else
		printf ("\tdsect\n");	/* all o/s code is dsect */
#endif
	    else
#ifdef TWOPASS
		printf ("%ccsect\n",ITEXT);
#else
		printf ("\tcsect\n");
#endif
#else
		printf("%ccsect\n",ITEXT);
#endif
#else
		printf("%c.text\n",ITEXT);
#endif
	    psline();
	    break;

	case FDATA:
#ifdef UAS
#ifdef MPX
#ifdef TWOPASS
	    printf ("%cdsect\n",IDATA);
#else
	    printf ("\tdsect\n");
#endif
#else
	    printf ("%cfardsect\n",IDATA);
#endif
#else
	    printf ("%c.fardata\n",IDATA);
#endif
	    break;

	case DATA:
	case ADATA:

#ifdef UAS
#ifdef MPX
#ifdef TWOPASS
	    printf ("%cdsect\n",IDATA);
#else
	    printf ("\tdsect\n");
#endif
#else
	    printf("%cdsect\n",IDATA);
#endif
#else
	    printf("%c.data\n",IDATA);
#endif
	    break;

	case STRNG:
#ifdef UAS
#ifdef MPX
#ifdef TWOPASS
    	    printf ("%cdsect\n",IDATA);
#else
	    printf ("\tdsect\n");
#endif
#else
	    printf("%cfardsect	STRING\n",IDATA);
#endif
#else
	    printf("%c.fardata	2\n",IDATA);
#endif
	    break;

	case ISTRNG:
#ifdef UAS
#ifdef MPX
#ifdef TWOPASS
    	    printf ("%cdsect\n",IDATA);
#else
	    printf ("\tdsect\n");
#endif
#else
	    printf("%cfardsect	ISTRING\n",IDATA);
#endif
#else
	    printf("%c.fardata	2\n",IDATA);
#endif
	    break;

	case STAB:
	    printf("	.stab\n");
	    break;

	default:
	    cerror("illegal location counter");
    }

    return(temp);
}

#ifdef MPX
/*
**  output line of text from the source
*/
void
defloi(s)
char *s;
{
#ifdef MPX
#ifndef NOCAID
    if (gdebug) {
    	/* only print if same program */
#ifdef mpx
    	if (stricmp(currprog, ftitle) == 0) {
#else
    	if (strcmp(currprog, ftitle) == 0) {
#endif
    	    slineno = lineno;	/* save our line number */
    	    if(fdefflag)	/* if in function do E.?? */
    		printf(" .xeq s.%d %s", lineno, s);
    	    else		/* else do S.?? */
    		printf(" .src s.%d %s", lineno, s);
    	} else {
    	    printf(" .com s.%d %s", slineno, s);
    	}
    } else {
    	if (lflag && gdebug == 0)
    	    printf("* %s", s);
    }
#else
    if (lflag) {
    	printf("* %s", s);
    }
#endif
#endif
}

/* get a line of input.  called from scan.c   */

int
getloi ( s, lim )                    /*  right from the book.  */

char s [];
int lim;

{
 int c, i;

 for(i = 0; --lim > 0 && (c =getchar()) != EOF && (s[i++] = c) != '\n';);
 if ((s[i-1] == '\n') && (i > 1)) {
  while ((s[i-2] == ' ') && (i > 1)) --i;
  s[i-1] = '\n';
 }
 s [ i ] = '\0';
 return ( i );
}
#endif /* MPX */

deflab(n)
{
 /* output something to define the current position as label n */

#ifdef ONEPASS
#ifdef UAS
    printf("L%d 	equ 	$\n", n);
#else
    printf("L%d:\n", n);
#endif
#else
    if( lastloc == PROG )
	printf("%c%d\t\n", ILABEL, n);
    else
#ifdef UAS
    	printf("L%d\tequ\t$\n", n);
#else
    	printf("L%d:\n", n);
#endif
#endif
}

int         crslab = 10;

getlab()
{
 /* return a number usable for a label */
    return(++crslab);
}

#ifdef TWOPASS
int         crs2lab = 99999;

get2lab()
{
 /* return a number usable for a label */
    return(crs2lab--);
}
#endif

int         reg_use = 7;
extern      calloff, autooff;

efcode()
{
 /* code for the end of a function */

    register struct symtab *p;
    register TWORD	t;
    int	i;
    int	tsz=0;	/* Used to detect func(s) that return > 2 words */
    char	*nm;	/* external name of symbol */

#ifndef BUG2
    if(edebug) {
	printf("efcode(): strftn = %d, curftn:\n", strftn);
	prstab(curftn);
    }
#endif

    if (strftn) {	/* copy output (in R2(NP) or R0(PN)) to caller */
	register NODE  *l, *r;
	register int    j;
#ifdef MPX
        int	sz;
#endif

	p = &stab[curftn];
	t = p -> stype;
	t = DECREF(t);

#ifndef ONEPASS
	printf("%c\n",FEND);
#endif	/* ONEPASS */

	tsz = tsize(t, p->dimoff, p->sizoff); /* Rev G */

	i = getlab();		/* label for return area */
#ifdef MPX
	sz = tsize(t, p -> dimoff, p -> sizoff) / SZCHAR;
	if (sz % sizeof(int))
	    sz += sizeof(int) - (sz % sizeof(int));
	locctr (DATA);
	defalign (ALDOUBLE);
	deflab (i);
	zecode (sz / (SZINT/SZCHAR));
	locctr (PROG);
#else
#ifndef LCOMM
	printf("	.data\n");
	printf("	.align	2\n");
	printf("L%d:	.space	%d\n", i,
		tsize(t, p -> dimoff, p -> sizoff) / SZCHAR);
	printf(".text\n");

#else	/* not LCOMM */

	{
	    int         sz = tsize(t, p -> dimoff, p -> sizoff) / SZCHAR;
	    if (sz % sizeof(int))
		sz += sizeof(int) - (sz % sizeof(int));
	    printf("	.farlcomm	L%d,%d\n", i, sz);
	}
#endif	/* LCOMM */
#endif  /* MPX */

	deflab(retlab);

	psline();
#ifdef MPX
	printf("	la	r1,L%d\n", i);
#else
	printf("	movw	#L%d,r1\n", i);
#endif

	reached = 1;
	l = block(REG, NIL, NIL, PTR | t, p -> dimoff, p -> sizoff);
	l -> tn.rval = 1;	/* R1 */
	l -> tn.lval = 0;	/* id cookie */

	l = buildtree(UNARY MUL, l, NIL);

	r = block(REG, NIL, NIL, PTR | t, p -> dimoff, p -> sizoff);
	r -> tn.rval = 0;	/* R0 */
	r -> tn.lval = 0;
	r = buildtree(UNARY MUL, r, NIL);

	l = buildtree(ASSIGN, l, r);
	l -> in.op = FREE;

#ifndef BUG2
	if(edebug) {
		printf("efcode(): before ecomp()\n");
		fwalk(l->in.left, eprint, 0);
	}
#endif

	ecomp(l -> in.left);
#ifdef MPX
	printf("	la	r0,L%d\n", i);
#else
	printf("	movw	#L%d,r0\n", i);
#endif

 	/* turn off strftn flag, so return sequence will be generated */
	strftn = 0;
    }
    else {

#ifndef ONEPASS
	printf("%c\n",FEND);
#endif	/* ONEPASS */
#ifndef MPX
	branch(retlab);
#endif
	deflab(retlab);
    }
    p = &stab[curftn];
    t = p -> stype;
    t = DECREF(t);

    i = t == DOUBLE ? 2 : (t == UNDEF ? 0 : 1);
    if( (t == STRTY || t == UNIONTY) && tsz <= 2*SZINT) {
	if(tsz <= SZINT)
		i = 1;
	else
		i = 2;
    }

    if ((retstat & (RETVAL | NRETVAL)) == (RETVAL | NRETVAL)) {
	werror("function contains both return and return(expr)");
    }
    if (!(retstat & RETVAL)) {
	if (t != INT && t != UNDEF) {
	    werror("function has a declared type but never returns a value");
	}
	i = 0;
    }

#ifdef UAS
#ifdef MPX
    nm = exname (p->sname, p);
#ifdef XXXX
    printf("*Y.%d	.end %s\n", ftnno, nm);
    printf("Y.%d equ $\n", ftnno);
#endif
    printf ("\tlf\tr2,2w,sp\n");
    printf ("\ttrsw\tr2\n");
#else
    printf ("	exit	%d,LA%d\n", i, ftnno);
#endif /* MPX */
#else
    printf("	retn\n");
#endif

    {
    int ii;
    ii = (reg_use >= (MINRVAR - 1)) ? reg_use : MINRVAR;
    reg_use = 7;

#ifdef MPX
    dumpstr();
#endif

#ifndef ONEPASS
    printf("%c%d\t\n",BEND,ii);
#else	/* not ONEPASS */
    p2bend(ii);
#endif	/* ONEPASS */
    }

#ifdef UAS
#ifdef MPX
    printf("*	.ef #%d %s\n", ftnno, nm);
#else
    printf ("*	.ef	%d\n", i);
#endif /* MPX */
#else
    printf ("	.ef	%d\n", i);
#endif
    fdefflag = 0;
#ifndef BUG2
    if(ddebug) {
	printf("efcode() complete\n");
    }
#endif
}

int         ftlab1, ftlab2;

bfcode(a, n) int    a[];
{
 /*
  * code for the beginning of a function;
  * a is an array of indices in stab for the arguments;
  * n is the number
  */
    register    i;
    register    temp;
    register struct symtab *p;
    struct symtab *r;
    int         off;
    char       *toreg();
    char        regarg[20];
    char	*nm;	/* external name of symbol */
    int		basemask;

    p = &stab[curftn];
#ifndef BUG2
    if(ddebug) {
	printf("bfcode(): ftnno = %d\n", ftnno);
	prstab(curftn);
	for(i=0; i < n; ++i) {
		printf("arg %d:\n", i);
		prstab(a[i]);
	}
    }
#endif
#ifndef NOCAID
#ifdef XXXX_CAID
    for(i=0; i < n; ++i) {
    	r = &stab[a[i]];
    	printf("*ARG%d.%d .arg %s ", ftnno, i, r->sname);
    	tprint(r->stype);
    	printf(" LA%d+%db\n", ftnno, r->offset/SZCHAR);
    }

#endif
#endif
#ifdef MAY2792
    nm = exname (p->sname, p->sflags);
#else
    nm = exname (p->sname, p);
#endif

#ifdef UAS
    locctr(PROG);
#ifdef NOCAID
    printf("*	.bf #%d %s\n", ftnno, nm);
#endif
    printf ("\tbound\t1w\n");
#ifndef NOCAID
    if (p->sclass == EXTDEF) {
    	printf("*	.ebf #%d %s\n", ftnno, nm);
    } else {
    	printf("*	.sbf #%d %s\n", ftnno, nm);
    }
#endif
#ifdef MPX
    defnam(p);
#endif
#else
    locctr(PROG);
    printf("	.bf\n	.align	2\n");
    defnam(p);
#endif

#ifdef UAS
#else
    printf("	.using	b1,%s\n", exname(p -> sname, p -> sflags));
#endif
    temp = p -> stype;
    temp = DECREF(temp);
    strftn = (temp == STRTY) || (temp == UNIONTY);

    retlab = getlab();

 /* routine prolog */

#ifndef NOCAID
#ifdef DO_LINE_STABS
#ifdef NOT_4_NOCAID
    printf("*.stabd 0x%x,0,%d\n", N_SLINE, lineno);
#endif
#endif
#else
    if (gdebug)
    	printf("	.stabd	0x%x,0,%d\n", N_SLINE, lineno);
#endif

#ifdef UAS
        printf("\ttrr\tsp,r1\n");
	printf("\tsumw\tsp,SLA%d\n", ftnno);
	printf("\tstd\tr0,2w,sp\n");
	printf("\tstf\tr4,4w,sp\n");
#ifdef XXXX
    	printf("*X.%d	.beg %s\n", ftnno, nm);
    	printf("X.%d equ $\n", ftnno);
#endif
#else
   	printf("\tenter LA%d, LRM%d\n", ftnno, ftnno);   /* v2cc change */
#endif

    off = ARGINIT;
    i = 0;

    if (proflg) {		/* profile code */
	temp = getlab();

	basemask = 0; /* Initially clear the "basemask" value */

#ifdef UAS
	printf("\
	la	r1,L%d\n\
	call	mcount,x'%x',0\n\
L%d	farlcommon	L%d(1)\n",
		temp,
		basemask,
		temp, temp);
#else
	printf("\
	movw	#L%d,r1\n\
	func 	#0x0,mcount\n\
	.farlcomm	L%d,4\n", temp, temp);
#endif
	psline();

    }
    else {
	if (n > 0) {
	    p = &stab[a[0]];

	    if (p->stype == STRTY || p->stype == UNIONTY) {
		if (SAflag)
		    werror ("First arg of funct is struct");
	    }
	}
    }

#ifndef ONEPASS
    p = &stab[curftn];		/* (MEY) NP1 code above clobbers p */
    printf("%c%s\n",FBEGIN,p->sname);
    printf("%c%d\t\n", PFHERE, ftnno); /* Optimizer to put param fetches here */

    if (n>0) {
        p = &stab[a[0]];  	/* (MEY) (22-Jan-87) Fixed for PCO */
        StabInfoPrint(p);
    }
#endif /* ONEPASS */


    for (; i < n; ++i) {
	p = &stab[a[i]];
#ifndef ONEPASS
	StabInfoPrint(p);
#endif
	if (p -> sclass == REGISTER) {
	    temp = p -> offset;		/* save register number */
	    p -> sclass = PARAM;	/* forget that it is a register */
	    p -> offset = NOOFFSET;
	    oalloc(p, &off);
#ifdef ONEPASS
   	    ParamFetch(temp, p->offset/SZCHAR, p->stype, ftnno);
#else
	    printf("%c%d\t%d\t%d\t\n", PFETCH, temp,
		p->offset/SZCHAR, p->stype);
#endif
	    p -> offset = temp;		/* remember register number */
	    p -> sclass = REGISTER;	/* remember that it is a register */
	}
	else {
	    if (p -> stype == STRTY || p -> stype == UNIONTY) {
		p -> offset = NOOFFSET;
		if (oalloc(p, &off))
		    uerror("bad argument");
		SETOFF(off, ALSTACK);
	    }
	    else {
		if (oalloc(p, &off))
		    uerror("bad argument");
	    }
	}

    }

/*
 *	Add farscan hook here when "func:variable" implemented.
 *	If p->sflags & SGERRYREF then rescan farlist file,
 *	and make SGERRYMANDER entries for all variables that
 *	are qualified with this function's name.
 *	Make the entries at blevel 2 so they will be ripped
 *	out automatically at the end of the function.
 *	Modify farscan1() to create the SGERRYREF entries.
 */

#ifndef ONEPASS
    printf("%c%d\t\n", PSAVE, 42/*filler*/);
#endif
    fdefflag = 1;
}

bccode()
{	/* called just before the first executable statment */
 /* by now, the automatics and register variables are allocated */
#ifdef MPXTEMP
    SETOFF(autooff, SZDOUBLE);
#else
    SETOFF(autooff, SZINT);
#endif
 /* set aside store area offset */

    locctr(PROG);

#ifndef ONEPASS
    printf("%c%d\t%d\t%d\t\n",BBEG,ftnno,autooff,regvar);
#else
    p2bbeg(autooff, regvar);
#endif

    reg_use = (reg_use > regvar ? regvar : reg_use);
}

int extflg;
char *extfun[EXTFUNS] = {
    "_cvtld",		/* C_LD */
    "_cvtdl",		/* C_FL */
    "_cvtuld",		/* C_ULD */
    "_cvtdul",		/* C_DUL */
    "_cvtif",		/* C_IF */
    "_cvtfi",		/* C_FI */
    "_cvtuif",		/* C_UIF */
    "_cvtfui",		/* C_FUI */
    "_f.call",		/* C_FC */
    "_f.calld",		/* C_FCD */
};

ejobcode(flag)
{
    /* called just before final exit */
    /* flag is 1 if errors, 0 if none */
#ifdef MPX
    int i;
    register isfunct;
    register char *name;
    register struct symtab *p;

#ifdef MPX
    dumpstr();
#endif

#ifdef TWOPASS
#ifdef MPX
    printf("%c\n",EOJFLG);
#endif
#endif

    /* print 'EXT' declarations for undefined external functions */

    for (i = 0; i < SYMTSZ; i++){
    	if( stab[i].stype == TNULL) continue;
    	p = &stab[i];
#ifdef MAY2792
    	name = exname (p->sname, p->sflags);
#else
    	name = exname (p->sname, p);
#endif
    	isfunct = ISFTN( stab[i].stype );
    	switch( stab[i].sclass ){
    	    case EXTERN:
    	    case FORTRAN:
    	    case UFORTRAN:
    		if ( isfunct ) {
#ifndef TEST_SEP6
    		    if( stab[i].suse > 0 )
    			break;  /* declared but not used */
#endif
    		    printf("	ext	%s\n", name);
    		} else {
    		    if( stab[i].suse > 0 )
    			break;  /* declared but not used */
    		    printf("	ext	%s\n", name);
    		/*  commdec( i ); */
    		}
    		break;
#ifndef NEW_DEF
    	    case EXTDEF:	/* external definition */
    		/* output all def's, referenced or not */
    		printf("	def	%s\n", name);
    		break;
#endif
    	}
    }
    /* now print out external functions called */
    if (extflg) {
    	for( i = 0; i < EXTFUNS; i++)
    	    if (extflg & (1 << i))
    		printf("	ext	%s\n", extfun[i]);
    }
#endif /* MPX */

#ifdef UAS
#ifdef MPX
  if(handopt)
    printf ("	dsect\n	end\n");
  else
    printf ("	csect\n	end\n");
#else
    printf ("	csect\n	end\n");
#endif
#endif
}

aobeg()
{
 /* called before removing automatics from stab */
}

aocode(p) struct symtab    *p;
{
 /* called when automatic p removed from stab */
}

aoend()
{
 /* called after removing all automatics from stab */
}

defnam(p) register struct symtab   *p;
{
 /* define the current location as the name p->sname */
    register char *nm;

    if (p->sclass == STATIC && p->slevel > 1)
	deflab(p->offset);
    else
    {
#ifdef MAY2792
	nm = exname(p->sname, p->sflags);
#else
	nm = exname(p->sname, p);
#endif
#ifdef NEW_DEF
/* look at endojob for defs */
	if (p->sclass == EXTDEF) {
#ifdef UAS
#ifdef MPX
	    printf("	def	%s\n", nm);
#endif
#else
	    printf("	.globl	%s\n", nm);
#endif
	}
#endif /* NEW_DEF */
#ifdef UAS
	printf("%s equ  $\n", nm);
#else
	printf("%s:\n", nm);
#endif
    }
}

#ifdef MPX

struct	tstrngs *begstrng = NULL; 	/* beginning list of init strings */
struct	tstrngs *currstng = NULL; 	/* current entry of init string */

static int putting = 0;

void
putstring(s,i,ct)
char *s;
int  i, ct;
{
	char    *ss = s+ct;
	int	ii;

	i--;		/* so we dont put out the terminating null byte */
	if(ct == 0)
	{			/* unbounded -- normal -- string */
		putting = 0;
		printf("\tdatab\tc'");
		for(ii = 0; ii < i; ii++)
			putabyte( *s++);
		printf("\"@'\n");
		inoff += SZCHAR;	/* MON */
	}
	else
	{       		/* a constrained string */
		if(i > 0)	/* not a null string	*/
		{
			int lim = i < ct ? i : ct;
			putting = 0;
			printf("\tdatab\tc'");
			for(ii = 0; ii < lim; ii++)
				putabyte( *s++);
			printf("'\n");
		}
	}
}

putabyte(v)
char    v;
{
	inoff += SZCHAR;
	if(++putting >= 32)
	{       /* break string onto several lines */
		putting = 1;
		printf("'\n\tdatab\tc'");
	}

	if (v < ' ') {
		putchar('"');
		putchar(v+64);
		putting++;	/* for extra char */
		return;
	}

	if (v > '~') {
		printf("',x'%x',c'",v);
		putting += 12;	/* for extra chars */
		return;
	}

	/* undo funny characters */
	switch(v)
	{
	case '%':
	case '"':
	case '\'':
	case ';':
		putchar('"');
		putting++;	/* for extra char */
	default:
		putchar(v);
	}
}

dumpstr()
{
	char *strptr;
    	int xz = 0;

    	if (begstrng) {
	    locctr(DATA);
    	    xz = 1;
    	}
	while (begstrng)
	{
		char *p;
		int  lim, i;

	    if (begstrng->slabel >= 0) {
		deflab(begstrng->slabel);
		putting = 0;
		printf("\tdatab\tc'");
		p = begstrng->strng;
		lim = begstrng->length - 1;
		/* -1 so we dont put out the null byte */
		for(i = 0; i < lim; i++,p++)
			putabyte( *p);
		printf("\"@'\n");
	    } else {
		printf("L%d\tdata%s\n",-begstrng->slabel, begstrng->strng);
	    }
		free(begstrng->strng);  /* string area is removed */
		currstng = begstrng;    /* so free will work      */
		begstrng = begstrng->next;
		free(currstng);         /* string struct is gone  */
	}
    	if(xz)
	    SETOFF(inoff,SZINT);	/* MON */
	currstng = NULL;
	begstrng = NULL;
    	if(xz)
	    locctr(PROG);
}

#else /* MPX */
bycode(t, i)
{
#ifdef ASSTRINGS
    static int  lastoctal = 0;
#endif

 /* put byte i+1 in a string */

#ifdef ASSTRINGS

    if(sizeofflag) return;
    i &= 0x3f;
#ifdef UAS
    if (t < 0) {
	if (i != 0)
	    printf("'\n");
    }
    else {
	if (i == 0)
	    printf("\tdatab\tc'");
	if (t == '\'')
	    printf ("''");
	else
	    if (t <= 31)
		printf ("\"%c", t+'@');
	    else
		printf ("%c", t);
	if (i == 0x3f)
	    printf("'\n");
    }
#else
    if (t < 0) {
	if (i != 0)
	    printf("\"\n");
    }
    else {
	if (i == 0)
	    printf("\t.ascii\t\"");
	if (t == '\\' || t == '"') {
	    lastoctal = 0;
	    printf("\\%c", t);
	}
 /*
  *	We escape the colon in strings so that
  *	c2 will, in its infinite wisdom, interpret
  *	the characters preceding the colon as a label.
  *	If we didn't escape the colon, c2 would
  *	throw away any trailing blanks or tabs after
  *	the colon, but reconstruct a assembly
  *	language semantically correct program.
  *	C2 hasn't been taught about strings.
  */
	else
	    if (t == ':' || t < 0x20 || t >= 0x7f) {
		lastoctal++;
		printf("\\%o", t);
	    }
	    else
		if (lastoctal && '0' <= t && t <= '9') {
		    lastoctal = 0;
		    printf("\"\n\t.ascii\t\"%c", t);
		}
		else {
		    lastoctal = 0;
		    putchar(t);
		}
	if (i == 0x3f)
	    printf("\"\n");
    }
#endif
#else

    i &= 7;
    if (t < 0) {		/* end of the string */
	if (i != 0)
	    printf("\n");
    }

    else {			/* stash byte t into string */
	if (i == 0)
#ifdef UAS
	    printf("	datab	");
#else
	    printf("	.byte	");
#endif
	else
	    printf(",");
#ifdef UAS
	printf("x'%x'", t);
#else
	printf("0x%x", t);
#endif

	if (i == 7)
	    printf("\n");
    }
#endif
}
#endif /* MPX */

zecode(n)
{
 /* n integer words of zeros */
    OFFSZ       temp;
    if (n <= 0)
	return;
#ifdef UAS
    printf("\trez\t%d\n", (SZINT / SZCHAR) *n);
#else
    printf("	.space	%d\n", (SZINT / SZCHAR) *n);
#endif
    temp = n;
    inoff += temp * SZINT;
}

fldal(t) unsigned   t;
{		/* return the alignment of field of type t */
    uerror("illegal field type");
    return(ALINT);
}

fldty(p) struct symtab *p;
{		/* fix up type of field p */
    ;
}

where(c)
{		/* print location of error  */
 /* c is either 'u', 'c', or 'w' */
 /* GCOS version */
    fprintf(stderr, "%s, line %d: ", ftitle, lineno);
}

swepilog( p, n )
	register struct sw *p;
	register int n;
{
	/* p points to an array of structures, each consisting
	 * of a constant value and a label.
	 * The first is >=0 if there is a default label;
	 * its value is the label number
	 * The entries p[1] to p[n] are the nontrivial cases
	 */

#ifdef ONEPASS
	genswitch( p, n, 0 );	/* someday this 0 will be a register number */

#else /* TWOPASS */

	register int i;

#ifdef OPTIMIZER
	/* front end opt cannot have switch fall through */
	if(p[0].slab < 0 )
		p[0].slab = brklab;
#endif

	printf("%c%d\t%d\t%d\t\n", ESWITCH, n, 0, p[0].slab); /* this 0 too */
	for( i = 1; i <= n; i++ )
	{
		printf(CONFMT, p[i].sval );
		printf("\t%d\t\n", p[i].slab );
	}
#endif
}

main(argc, argv) char  *argv[];
{
#ifdef BUFSTDERR
    char        errbuf[BUFSIZ];
    setbuf(stderr, errbuf);
#endif
    setbuf(stdout, NULL);
    return(mainp1(argc, argv));
}

#ifdef MPX
p1init()
{
    char *cp1, *cp2;
    int pcnt = 0;

    strcpy(currprog, ftitle);
    for(cp1=cp2=ftitle; *cp2; cp2++)
    	if(*cp2 == '/') cp1 = cp2+1;
    printf("	program	");
    for (cp2 = cp1; *cp2; cp2++) {
    	if (*cp2 == '\"') continue;
    	if (*cp2 == '.') break;
    	printf("%c", *cp2);
    	progname[pcnt++] = *cp2;
    }
    progname[pcnt] = '\0';
    printf("\n");
    printf("	list	mac,nong,nodata\n");
    printf("*\n");
    printf("r0	equ	0\n");
    printf("r1	equ	1\n");
    printf("r2	equ	2\n");
    printf("r3	equ	3\n");
    printf("r4	equ	4\n");
    printf("r5	equ	5\n");
    printf("r6	equ	6\n");
    printf("r7	equ	7\n");
/*    printf("*\n"); */
    printf("sp	equ	3\n");
    printf("*\n");
    if (handopt)
    	locctr(DATA);
/*  printf("\tdsect\n"); */
    else
    	locctr(PROG);
/*  printf("\tcsect\n"); */
/* locctr(PROG); */
    if (!handopt)
    	printf("	dataw	x'2243223a'\n");  /* magic number */
}
#endif /* MPX */

/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */
