/* Definitions for floating point emulation.  The current version
** only works on an Amdahl host.  This stuff appears in macdefs.h
** in QCC/RCC compilers, so make this version conditional on CG.
*/

#if defined(CG) && defined(uts) && defined(FP_EMULATE)

#define	FP_FLOAT long			/* prevent unfortunate conversions */
#define FP_CMPD(d1,d2)	flcmp(d1,d2)
#define FP_DTOFP(d)	dtofp(d)
#define	FP_DTOF(d)	dtof(d)
#define FP_DTOL(d)	dtol(d)
#define FP_DTOUL(d)	dtoul(d)
#define FP_LTOD(d)	ltod(d)
#define FP_ULTOD(d)	ultod(d)
#define FP_PLUS(d1,d2)	fladd(d1,d2)
#define FP_MINUS(d1,d2) fladd(d1,-d2)
#define FP_TIMES(d1,d2) flmul(d1,d2)
#define FP_DIVIDE(d1,d2) fldiv(d1,d2)
#define	FP_ISZERO(d)	fp_iszero(d)

extern double ltod(), ultod(), fladd(), flmul(), fldiv(), dtofp();
extern FP_FLOAT dtof();
extern long dtol();
extern int fp_iszero();

#define FP_ATOF(s)	atof2(s)
extern double atof2();
#endif /* uts && FP_EMULATE */

/* Default definitions in the absence of emulation. */

extern int errno;
#ifndef	FP_DOUBLE
#define	FP_DOUBLE	double	/* type containing doubles */
#endif
#ifndef	FP_FLOAT
#define	FP_FLOAT	float	/* type containing floats */
#endif
#ifndef	FP_DTOF
#define	FP_DTOF(d) ((float) d)	/* convert double to float */
#endif
#ifndef	FP_DTOFP		/* truncate double to float precision */
#define	FP_DTOFP(d) ((double) FP_DTOF(d))
#endif
#ifndef	FP_DTOL			/* convert double to long */
#define	FP_DTOL(d) ((long) (d))
#endif
#ifndef FP_DTOUL		/* convert double to unsigned long */
#define FP_DTOUL(d) ((unsigned long) (d))
#endif
#ifndef	FP_LTOD			/* convert long to double */
#define	FP_LTOD(l) ((double) (l))
#endif
#ifndef	FP_ULTOD		/* convert unsigned long to double */
#define	FP_ULTOD(ul) ((double) (ul))
#endif
#ifndef	FP_NEG			/* negate double */
#define	FP_NEG(d) (-(d))
#endif
#ifndef	FP_PLUS			/* add double */
#define	FP_PLUS(d1,d2) ((d1)+(d2))
#endif
#ifndef	FP_MINUS		/* subtract double */
#define	FP_MINUS(d1,d2) ((d1)-(d2))
#endif
#ifndef	FP_TIMES		/* multiply double */
#define	FP_TIMES(d1,d2) ((d1)*(d2))
#endif
#ifndef	FP_DIVIDE		/* divide double */
#define	FP_DIVIDE(d1,d2) ((d1)/(d2))
#endif
#ifndef	FP_ISZERO		/* is double value zero? */
#define	FP_ISZERO(d) (!(d))
#endif
#ifndef	FP_CMPD			/* compare two doubles */
#define	FP_CMPD(x,y) ((x)==(y)?0:((x)>(y)?1:-1))
#endif
#ifndef	FP_ATOF				/* convert string to FP_DOUBLE */
#ifndef	FLOATCVT			/* backward compatibility */
#define	FP_ATOF(s) atof(s)		/* use UNIX atof() */
			/*Note: for CG, we also need a C++ declaration
			  of atof(); */
#  ifdef c_plusplus
extern double atof(const char *);
#  else
extern double atof();
#  endif
#else
#define	FP_ATOF(s) FLOATCVT(s)
#endif
#endif

