************************************************************************
*MI03                      MANAGEMENT INFORMATION                      *
*    DEVICE ID: HH-65A                 HID:       XX.XX-01             *
*    FILENAME:  FS_.A61                LANGUAGE:  ASSEMBLY             *
*    LOAD MODUL:                       SYSTEM:    SM                   *
*    COMPILER:                         ASSEMBLER: ASM V2.1A            *
*    TRNR CPU:                         CPU TYPE:  SEL 32/77            *
*    ITRTN RATE:                       MODE:                           *
*    LINK EDITR:                                                       *
*                                                                      *
************************************************************************
*PU02                             PURPOSE                              *
*                                                                      *
************************************************************************
*TI02                      TECHNICAL INFORMATION                       *
*    *KEYWORD* ENTP FS.                                                *
*    *KEYWORD* ENTP FS.IR                                              *
*    *KEYWORD* ENTP FS.NRML                                            *
*                                                                      *
************************************************************************
*PA02                        PROGRAM ATTRIBUTES                        *
*    LOGICAL RECORDS:            245   GENERAL COMMENTS:            50 *
*    FORTRAN LINES:                0   NON-FORTRAN LINES:          245 *
*    EXECUTABLE FTN STMTS:         0   NON-EXEC FORTRAN STMTS:       0 *
*                                                                      *
************************************************************************
*CH02                          CHANGE HISTORY                          *
*    REV   DATE        SOFTWARE ANALYST               EMPLOYER         *
*                               DESCRIPTION OF CHANGE                  *
*    01  18JUL95   JOHN RUCKSTUHL             NAWCTSD CODE 493         *
*              INITIAL HEADER INSTALLATION                             *
*                                                                      *
************************************************************************
         TITLE     FCNT  SYSTEM I/O HANDLER
         PROGRAM   FS.
************************************************************************
*
* REV01 05/05/85 LTA DR N/A   FIX ONLINE/OFFLINE INTERMITTENTS
*
************************************************************************
*
*
*  EXTERNAL DEFINITIONS -
*
         DEF       FS.             FCNT  I/O HANDLER INITIALIZATION
         DEF       FS.NRML         FCNT  I/O HANDLER NORMAL PROC.
         DEF       FS.IR           ERROR INTERRUPT HANDLER
*
*
*  EXTERNAL REFERENCES -
*
DATAPOOL COMMON    IFCBUF          FCNT  SYSTEM BUFFER ADDRESS
*                                  49 WORDS RESERVED
DATAPOOL COMMON    FVIOFF          FCNT  INOPERATIVE
DATAPOOL COMMON    FSCEXEC         SC ERROR OUTPUT FLAG
DATAPOOL COMMON    FCINIT         FCNT  INITALIZATION FLAG
*
*
************************************************************************
         PAGE
************************************************************************
*
*
         M.REQS                    REGISTER EQUATES
*
*
VSPL     EQU       X'1B'           FCNT  I/O PRIORITY LEVEL
VSTCW    EQU       X'11C'          FCNT  I/O TCW (OR TAW)
VSSI     EQU       X'15C'          INTERRUPT VECTOR ADDRESS
VSDA     EQU       X'30'           FCNT  I/O DEVICE ADDRESS
*
STARTIO  EQU       X'8000'         HSD OPERATION CODE, START I/O
HALTIO   EQU       X'1000'         HSD OPERATION CODE, HALT I/O
TD8000   EQU       X'8000'         8000 LVL DEVICE TEST
TD2000   EQU       X'2000'         HSD DEVICE STATUS TEST
*
NRMBIT   EQU       1               NORMAL PROCESS FLAG
TRMBIT   EQU       2               TERMINATION FLAG
*
************************************************************************
         PAGE
************************************************************************
*
*  SUBROUTINE VS.INIT - FCNT  I/O HANDLER INITIALIZATION
*
*  INPUTS:
*    R0 - RETURN ADDRESS
*
*  OUTPUTS:
*    I/O TERMINATION OCCURS. (TO CLEAR HSD)
*
*    (R7 DESTROYED)
*
*  ITERATION RATE:
*    1 TIME ONLY
*
*  DATAPOOL VARIABLES AFFECTED ON EXIT:
*    (FSCEXEC)
*
*  LATEST UPDATE     : 9/14/83 CONVERT ERROR ON TD  IN VS.INIT TO SC
*                              CONTROL IE. SET BIT 5 IN FSCEXEC ON ERROR
*
************************************************************************
*
FS.      EQU       $               SUBROUTINE ENTRY
*
*
********  SELECT INITIALIZATION OR NORMAL *******
*
         LB        R4,FCINIT      FCNT  INIT FLAG
         BZ        VS.X            RETURN IF FCNT  NOT INITALIZED
*
         TC$PATH   FS.NRML,VS.X,VSMODE
*
         LEAR      R4,FS.IR        INTERRUPT TO SET CPIX
         STW       R4,VSSI         SERVICE INTERRUPT VECTOR LOCATION
*
*        ZMB       FVIOFF          FCNT  IS OPERATIVE
         LEAR      R4,IOCB         SET R4 = REAL ADDRESS OF IOCB
         STW       R4,VSTCW        . STORE IN TCW (OR "TAW")
*
         LEAR      R7,IFCBUF       SET R7 = REAL ADDRESS OF FCNT  TBL
         STW       R7,IOCB+1W      . STORE AS MEMORY ADDRESS
*
         DI        VSPL            DISABLE INTERRUPTS (I/O RUNS DISABLED
*
         CD        VSDA,HALTIO     ** TERMINATE FCNT  HSD ACTIVITY **
*
         TD        VSDA,TD8000     TEST HSD CONTROLLER STATUS
         BFT       $+2W            BRANCH IF O.K.
         SBM       5,FSCEXEC       SET FOR SC ERROR OUTPUT
*
**********  SAVE INIT. INTERRUPT ADDRESS IN VECTOR  ************
*
         EI        VSPL
         RI        VSPL            REQUEST INIT. INTERRUPT
         NOP
         NOP
*
*
         TRSW      R0              RETURN TO CALLER
         NOP
*
*
************************************************************************
         PAGE
*
*  THIS PAGE INTENTIONALLY LEFT BLANK -
*
         PAGE
************************************************************************
*
*  SUBROUTINE FS.NRML - FCNT  I/O HANDLER, NORMAL PROCESSING
*
*  INPUTS:
*    R0 - RETURN ADDRESS
*    AVSCP - ADDRESS OF CURRENT PROCESSING
*    IFCBUF - FCNT  OUTPUT TABLE
*    STATUS WORD OF IOCB (PREVIOUS TRANSFER STATUS)
*
*  OUTPUTS:
*    "HALT I/O" ISSUED TO THE FCNT , FOLLOWED BY FCNT  DATA OUTPUT
*
*    (R4 DESTROYED)
*
*  ITERATION RATE:
*    30 HERTZ
*
************************************************************************
*
FS.NRML  EQU       $               SUBROUTINE ENTRY
         DI        VSPL            DISABLE HSD INTERRUPT (TO CLEAR)
*
*  START FCNT  I/O -
*
*        LEAR      R4,IOCB         SET R4 = REAL ADDRESS OF IOCB
*        STW       R4,VSTCW        . STORE IN TCW (OR "TAW")
*        CD        VSDA,HALTIO     ** TERMINATE HSD ACTIVITY **
*
*        ZMB       FVIOFF          FCNT  IS OPERATIVE
         LEAR      R4,IOCB         SET R4 = REAL ADDRESS OF IOCB
         STW       R4,VSTCW        . STORE IN TCW (OR "TAW")
         AI        VSPL
         CD        VSDA,STARTIO    ** INITIATE HSD I/O TRANSFER **
         DAI       VSPL
*
*        LEAR      R4,IOCB         SET R4 = REAL ADDRESS OF IOCB
*        STW       R4,VSTCW        . STORE IN TCW (OR "TAW")
*        CD        VSDA,HALTIO     ** TERMINATE HSD ACTIVITY **
*
VS.X     TRSW      R0              RETURN TO CALLER
*
************************************************************
         PAGE
************************************************************
******** SERVICE INTERRUPT SECTION        ********
******** INTERRUPT REQUESTED BY THIS      ********
******** ROUTINE IS BECAUSE OF AN ERROR   ********
******** THE INTERRUPT CONTROL IS ONLY    ********
******** SO THE COMPUTER WON'T HALT       ********
*
         BOUND     1W
FS.IR    EQU       $               INTERRUPT ICB BLOCK
         REZ       2W              SAVE OLD PSD HERE
         GEN       12/X'808',20/W(VS.IP)   EXECUTE POINT
         DATAW     X'C0010000'     BIT 47 RETAIN OLD MAP
         REZ       2W
*
********  SELECT INITIALIZATION OR NORMAL *******
*
VS.IP    TC$PATH   VS.INRML,VS.IX,VSIMODE
*
*        INITIALIZE INTERRUPT HANDLING
*
         LW        R4,FS.IR+1W     OBTAIN OWN TASK 2ND. PSD WORD
         ZBR       R4,15           CLEAR OLD RETAIN BIT
*        ZBR       R4,16
         SBR       R4,17           SET AUTOMATIC BLOCKED INTERRUPTS
         STW       R4,FS.IR+3W     SAVE CPIX ETC. FOR NEW PSD
*
VS.INRML EQU       $               NORMAL INTERRUPT PROCESSING
         ZMW       IOCB+3W         CLEAR IOCB ERROR STATUS
*
         DAI       VSPL
VS.IX    LPSDCM    FS.IR           RELEASE   "SET UP" INTERRUPT
*
*
************************************************************************
         PAGE
************************************************************************
*
*
*  IOCB FOR HSD TRANSFER -
*
         BOUND     1W
IOCB     GEN       8/0,8/0,16/11   . OPCODE/DEVCODE/TRANSFER COUNT
         DATAW     0               . MEMORY BUFFER ADDRESS
         DATAW     0               . UNUSED
         DATAW     0               . ERROR STATUS
VSMODE   DATAW     0               STATUS FOR INT PROCESSING
VSIMODE  DATAW     0               STATUS FOR INT PROCESSING
ERRCODE  DATAW     C'VH01'         FCNT  I/O ERROR CODE
*
************************************************************************
         END
