/*~!errstrtok.c*/
/* Name:  errstrok.c Part No.: _______-____r
 *
 * Copyright 1992 - J B Systems, Morrison, CO
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of J B Systems.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */

#ident	"@(#)nbclib:errstrok.c	1.1"

/*	This is exactly strtok(3C).
	It is here, with a different name, because using strtok() within
	the scope of errverb() can cause the loss of a currently remembered
	string (savept).
*/

/*
 * uses strpbrk and strspn to break string into tokens on
 * sequentially subsequent calls.  returns NULL when no
 * non-separator characters remain.
 * `subsequent' calls are calls with first argument NULL.
 */

#ifndef NULL
#define	NULL	(char*)0
#endif

extern int strspn();
extern char *strpbrk();

char *
errstrtok(string, sepset)
char	*string, *sepset;
{
    register char	*p, *q, *r;
    static char	*savept;

    /*first or subsequent call*/
    p = (string == NULL)? savept: string;

    if(p == 0)			/* return if no tokens remaining */
      return(NULL);

    q = p + strspn(p, sepset);	/* skip leading separators */

    if(*q == '\0')		/* return if no tokens remaining */
      return(NULL);

    if((r = strpbrk(q, sepset)) == NULL)	/* move past token */
      savept = 0;		/* indicate this is last token */
    else {
      *r = '\0';
      savept = ++r;
    }
    return(q);
}
