/* Seq2.c  */
#include <sys/types.h>
#include <sys/timeb.h>
#include <time.h>
#include <stdio.h>  

#define LINELEN 81
#define NEWLINE '\n'
#define FORMFEED '\014'  /*  used to skip to top of page  */
#define NEWFILE '\002' /* used to restart sequencing from 1 (STX char) */
#define EOM -1
#define BACKSPACE '\010'
#define ESC '\033'
#define FF  '\014'

char form1[] = {
"\033E\033&l1O\033(s17H\033&l5.14C\033&l71F\033&l6E\033(s-3B\033&a0R\033&a85M\033&a5L\r\000"};
char form2[] = { "\014\033E\000" };
char form3[] = { "\033&a0R\033&a90M\033&a88L\r\n\r\n\000" };
char form4[] = { "|\r\n\000" };
char form5[] = { "\033&a0R\033&a171M\033&a91L\r\000" };
char form6[] = { "\014\033&a0R\033&a85M\033&a5L\r\000" };

char	chr;			/* character holder */
char	line[2*LINELEN+8];	/* line buffer and pointer */
char	*lineptr;
char	linelen = LINELEN+6;	/* default without seq numbers */
int 	tabs = 0;	/* global access to -t argument - initialized off */
int 	tablen = 8;
int	pageno = 1;
int	linecnt = 0;
int	newpage = 0;
int	seq;		/* sequence numbers */
char *	title;
int	skipseq = 0;

main(argc,argv)
char   **argv;

{
    register FILE *fi;
    int	i,j,count;	/* character counters */
    int	forcend;	/* line length & paging control variables */
    int	savchar;	/* temporary character holder */
    int	noline = 0;

    seq = forcend = 0;	/* initialize flags & indicators */

    while (--argc > 0) {
    	for ( ; (*++argv)[0]=='-'; argc-- ) {
    	    i = 1;
    	    while ((*argv)[i] != 0) {	/* pass through all flags */
    		switch ((*argv)[i++]) {
    		    case 's':		/* sequencing ('-s') option */
    			seq = 1;
    			linelen = LINELEN;
    			break;		/* set up for sequence numbering */
    		    case 't':           /* tabbing ('-t') option */
    			tabs=1;
    			tablen = 4;
    			break;		/* set up for tab expansion */
    		}
    	    }
    	}

    	if (argc < 1) {
    	    fi = stdin;
    	    *argv = "reading input from stdin";
    	} else {
    	    if ((fi = fopen(*argv, "r")) == NULL) {
    		fprintf(stderr, "seq: can't open %s\n", *argv);
    		continue;
    	    }
    	}

    	title = *argv;
    	/* now process the input */
    	if (seq)seq = 1;
    	prolog();
    	linecnt = 0;
    	newpage = 0;

    	line[5] = ' ';		/* clear padding column */
    	i = 6;			/* initialize line buffer pointer */
    	while ((savchar = getc(fi)) != EOF) {	/* read til EOF or ERROR */
    	    chr = savchar;	/* convert getc(return) to character */
    	    if (noline && chr == '\n') {
    		noline = 0;
    		continue;
    	    }
    	    noline = 0;
    	    if (chr == FF) {
    		noline = 1;
    		line[i++] = '\n';	/* stuff character in line */
    		line[i++] = '\r';
    		if (seq) {		/* sequencing in effect? */
    		    setln();
    		    lineptr = line;	/* write out entire line buffer */
    		    count = i;
    		} else {		/* no sequencing */
    		    lineptr = &line[6];	/* write text part of the line */
    		    count = i - 6;
    		}
    		newpage++;
    		if (i=6)continue;
    		lineprt(lineptr, count);
    		i = 6;			/* initialize line pointer */
    		continue;
    	    }
    	    if (chr == BACKSPACE) {
    		i--;			/* backup char count */
    		continue;		/* and do next char */
    	    }
    	    /* Now the "regular" character input can be handled */
    	    /* do we have to 'split' this line */
    	    if (forcend && chr != '\n')  {	
    		line[i++] = '\n';	/* move newline into buffer */
    		line[i++] = '\r';
    		if (seq) {		/* sequencing in effect? */
    		    setln();
    		    lineptr = line;	/* write out entire line buffer */
    		    count = i;
    		} else {		/* no sequencing */
    		    lineptr = &line[6];	/* write text part of the line */
    		    count = i - 6;
    		}
    		lineprt(lineptr, count);
    		skipseq = 1;
    		/* reset line pointer to 15 and insert leading blanks */
    		for (i=0; i < 6+tablen; i++)
    		    line[i] = ' ';
    		chr = savchar;		/* retrieve original character read */
    	    }
    	    forcend = 0;		/* reset line 'split' control */
    	    if (chr == '\t')		/* is this a tab character? */
    		i = dotab(i);		/* if so, handle it */
    	    if (chr == '\n') {		/* is character a newline? */
    		line[i++] = chr;	/* move newline into buffer */
    		line[i++] = '\r';
    		if (seq) {		/* sequencing in effect? */
    		    if(!skipseq)setln();
    			lineptr = line;	/* write out entire line buffer */
    			count = i;
    		} else {		/* no sequencing */
    		    lineptr = &line[6];	/* write text part of the line */
    		    count = i - 6;
    		}
    		lineprt(lineptr, count);
    		skipseq = 0;
    		i = 6;			/* initialize line pointer */
    	    } else {			/* character not new line */
    		line[i++] = chr;	/* stuff character in line */
    		if (i >= linelen)	/* too many characters before new line? */
    		    forcend = 1;	/* indicate line may have to be 'split' */
    	    }
    	}
    	if (fi != stdin) fclose(fi);
    }
    epilog();
    if (i != 6)			/* END or ERROR at the wrong place? */
    	exit(2);		/* yes, abort */
    else 
    	exit(0);		/* exit gracefully */
}

setln ()
{
    int	n;
    lineptr = &line[4];		/* point to last character in sequence */
    n = seq++;			/* put sequence number in temporary */
    do {
    	/* put last digit in line buffer */
    	*(lineptr--) = n % 10 + '0';
    } while ((n /= 10) > 0);	/* take last digit off number */
    while (lineptr >= line)
    	*(lineptr--) = ' ';	/* pad on left with blanks */
}

lineprt(buf,len)
char * buf;
int    len;
{
    int tlen;

    if (len <= 0)return;
    if (len > 2) {
    	/* trim trailing blanks */
    	tlen = len - 2;
    	while (tlen > 0 && buf[tlen-1] == ' ')tlen--;
    	if (tlen < len-2) {
    	    buf[tlen] = buf[len-2];
    	    buf[tlen+1] = buf[len-1];
    	    len = tlen + 2;
    	}
    }
    if (skipseq && len == 2) {
    	for (tlen=0; tlen < len; tlen++)buf[tlen] = ' ';
    	return;
    }
    bumpline();
    if (newpage) pagebrk();
    output(buf, len);
    for (tlen=0; tlen < len; tlen++)buf[tlen] = ' ';
}

dotab(i)	/* subroutine to handle tabs */
int i;		/* argument is current line pointer */

{
#ifdef MAR9
    if (!tabs)	/* if tab handling not requested, forget it */
    	return(i);
#endif
    chr = ' ';	/* force tab character to be a space */
#ifdef XXX
    if ((i - 6 + 1)%tablen == 0)return(i);
/*    if ((i - 5)%tablen == 0)return(i);
    do {
    	line[i++] = chr;
    }
/*23456789012345678901234567890*/
    while ((i - 7)%tablen != 0);	/* insert spaces to next tab stop */
/*    while ((i - 5)%tablen != 0);	/* insert spaces to next tab stop */
/*    while ((i - 6)%tablen != 0);	/* insert spaces to next tab stop */
#endif
/*    column = i - 6 + 1; */
/*    if ((i - 5)%tablen == 0)return(i); */
    while ((i - 6)%tablen != 0)
    	line[i++] = chr;		/* insert spaces to next tab stop */
/*    line[i++] = chr;			/* replace tab char */
    return(i);				/* exit now */
}

bumpline()
{ 
/*  if(linecnt++ >= 66)newpage++; */
    if(linecnt++ >= 65)newpage++;
}

prolog()
{
    output(form1, strlen(form1));
    pageno = 1;
    linecnt = 1;
    mktitle();
}

epilog()
{
    output(form2, strlen(form2));
}

output(buf, len)
char * buf;
int	len;
{
    while (len--)putc(*buf++,stdout);
}

mktitle()
{
    struct timeb tbuf;
    char *ctbuf;
    char titl [130];

    ftime(&tbuf);
    ctbuf = ctime(&(tbuf.time));
    ctbuf[24] = '\0';
    sprintf(titl, "\033&dD%-43s%-25s - page %-4d \n\n\033&d@\r\000",
    	title, ctbuf, pageno);
    output(titl, strlen(titl));
}

pagebrk()
{
    int i;

    if (pageno & 1) {
    	output(form3, strlen(form3));
/*  	for (i = 0; i < 66; i++) */
    	for (i = 0; i < 65; i++)
    	    output(form4, strlen(form4));
    	output(form5, strlen(form5));
    } else {
    	output(form6, strlen(form6));
    }
    linecnt = 1;
    newpage = 0;
    pageno++;
    mktitle();
}
