/*~!DRIVER.C*/
/* Name:  DRIVER.C Part No.: _______-____r
 *			
 *			SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 */
# include   <stdio.h>
# include	<ctype.h>
# include	<signal.h>

# include	"drivedefs.h"

# define	FILEP		FILE *
# define	strequal(a,b)	strcmp(a,b) == 0
# define	NO		0
# define	YES		1
# define 	EXTRA 1

typedef 	int	flag;
typedef 	char	*ptr;

FILEP diagfile	= {stderr} ;

int pid;
int sigivalue	= 0;
int sigqvalue	= 0;
int sighvalue	= 0;
int sigtvalue	= 0;
int sigkvalue	= 0;
int ncomps	= 0;
int nfiles	= 0;

char *modulename = MODULENAME ;

char *passpname	= PASSPNAME ;
char *pass1name	= PASS1NAME ;
char *goptname	= GOPTNAME ;
char *codegname	= CODEGNAME ;
char *listgname = LISTGNAME ;
char *asmname	= ASMNAME ;
char *ldname	= LDNAME ;

char *footname	= FOOTNAME;
char *proffoot	= PROFFOOT;

char *aoutname	= "a.out" ;

char *basname	= BASNAME ;
char *f77name	= F77NAME ;
char *shellname = SHELLNAME ;
char *infname	= "<command line>";
char *inclpath	= INCLPATH;

char *passpbug	= " " ;
char *pass1bug	= " " ;
char *goptbug	= " " ;
char *codegbug	= " " ;
char *ooptbug	= " " ;
char *asmbug	= " " ;
char *listgbug  = " " ;
char *ldbug     = "" ;
char *f77bug	= " " ;
char *basbug	= " " ;

char goptlevel	= '0';

char sysb[200];
char currpass[200];

char modul[20];

char textfname[25];
char datafname[25];
char asmfname[25];
char prepfname[25];
char objfname[25];
char optzfname[25];
char symfname[25];

char asmopts[125] = "";
char cpflags[512] = "";
char c1flags[100] = "";
char c3flags[100] = "";
char fflags[20]	= "-c";
char bflags[20]	= "-c";
char lflag[50]	= "-x";
char *cpflagp   = cpflags;
char *c1flagp	= c1flags;
char *c3flagp	= c3flags;
char *fflagp	= fflags+1;
char *bflagp	= bflags+2;
char *chpathp	= "";
char *chpassp  	=  BKUPPASSES;
char *savedotoname;
char **loadargs;
char **loadp;
char **fileargs;	/* pointer to arguments not preceeded with a '-' */
char **files;
char **libargs;		/* library arguments, specified with '-l' */
char **libp;

flag erred	= NO;
flag listflag	= NO;
flag gflag	= NO;
flag loadflag	= YES;
flag noasm	= NO;
flag saveasmflag	= NO;
flag saveobjflag	= NO;
flag profileflag	= NO;
flag optimflag	= NO;
flag debugflag	= NO;
flag printflag  = NO;
flag driverdebug = NO;
flag runflag	= NO;
flag cprunonly = NO;
flag cpoutput  = NO;
flag verbose	= NO;
flag nofloating	= NO;
flag macroflag	= NO;

char *strcat();
char *setdoto(), *lastchar(), *lastfield(), *copys(), *strcpy();
char *catstr(), *strip();

main(argc, argv)
int argc;
char **argv;
{
	register int i, c;
	register char *s;
	register char *t;

	ptr ckalloc();
	int intrupt();

	sigivalue = (int) signal(SIGINT, SIG_IGN) & 01;
	sigqvalue = (int) signal(SIGQUIT,SIG_IGN) & 01;
	sighvalue = (int) signal(SIGHUP, SIG_IGN) & 01;
	sigtvalue = (int) signal(SIGTERM,SIG_IGN) & 01;
	enbint(intrupt);


	fileargs = (char **) ckalloc( argc * sizeof(*fileargs) );
	files = fileargs;
	libargs = (char **) ckalloc( argc * sizeof(*libargs) );
	libp = libargs;
	loadargs = (char **) ckalloc( (argc+20) * sizeof(*loadargs) );
	loadargs[1] = "-X";
	loadp = loadargs + 2;


	for (	--argc,++argv ; argc > 0 ; --argc,++argv )
	{
		if(argv[0][0] != '-')
		{
			if(dotchar(*argv) == 'a')
				*libp++ = *argv;
			else
			{
				*files++ = *argv;
				nfiles++;
			}
		}
		else if(argv[0][1] != '\0')
			for (s = argv[0]+1 ; *s ; ++s)
			    switch(*s)
			    {
			  	case 'B':	/* use special paths */
					if (*(s+1))
						chpathp = s+1;
					else
						chpathp = BKUPPATH;
					goto endfor;

			  	case 't':	/* change paths	*/
					if (*(s+1))
						chpassp = s+1;
					else
						fprintf(diagfile, "Bad option '-t' must be followed by path identifiers, -tp1O2 assumed.\n");
					goto endfor;

			  	case 'T':  /* use special passes */
				     switch(*++s)
				     {
				  	case 'p':
						passpname = s+1;
						goto endfor;

				  	case '1':
						pass1name = s+1;
						goto endfor;
	
				  	case 'O':
						goptname = s+1;
						goto endfor;
	
				  	case '2':
						codegname = s+1;
						goto endfor;

				  	case 'a':
						asmname = s+1;
						goto endfor;

				  	case 'l':
						ldname = s+1;
						goto endfor;

				  	case 'b':
						basname = s+1;
						goto endfor;

				  	case 'f':
						f77name = s+1;
						goto endfor;

				  	case 'F':
						footname = s+1;
						goto endfor;

				  	default:
						erri("Bad option '-T%c'.", *s);
				     }
				     break;

			  	case ':':  /* pass special debug flags */
				     switch(*++s)
			   	     {
				  	case 'p':
						passpbug = s+1;
						goto endfor;

				  	case '1':
						pass1bug = s+1;
						goto endfor;

				  	case 'O':
						goptbug = s+1;
						goto endfor;

				  	case '2':
						codegbug = s+1;
						goto endfor;

				  	case 'o':
						ooptbug = s+1;
						goto endfor;

				  	case 'a':
						asmbug = s+1;
						goto endfor;

				  	case 'l':
						ldbug = s+1;
						goto endfor;

				  	case 'f':
						f77bug = s+1;
						goto endfor;

				  	case 'b':
						basbug = s+1;
						goto endfor;

				  	default:
						erri("Bad option '-:%c'.", *s);
				     }

			  	case 'N':
					if (*(s+1) == 't')
					{
						if( *(s+2) >= '1' && *(s+2) <= '9')
						{
							s += 2;
							*c1flagp++ = *c3flagp++ = '-';
							*c1flagp++ = *c3flagp++ = 't';
							while(*s)
								*c1flagp++ = *c3flagp++ = *s++;
							*c1flagp++ = *c3flagp++ = ' ';
						}
						else
							erri("Bad option '-N%c' must be followed by digit.", *(s+1));
					}
					else
						erri("Bad option '-N%c'.", *(s+1));
					goto endfor;

			  	case 'O':
					if (s[1] == '\0')
					{
						optimflag = YES;
						goto endfor;
					}
					if (isdigit(s[1]) || s[1] == 'l' || s[1] == 'r')
					{
						optimflag = YES;
# ifdef BOZO
						*c1flagp++ = '-';
						*c1flagp++ = 'O';
						*c1flagp++ = ' ';
# endif BOZO
						s++;
						if (isdigit(*s))
							goptlevel = *s;
						else if (*s == 'l')
							goptlevel = '4';
						else if (*s == 'r')
							goptlevel = '5';
					}
					if (s[1] == 'p')
						optimflag = YES;
					goto endfor;

			  	case 'S':
					saveasmflag = YES;
					noasm       = YES;
# ifdef OLDSTUFF
					if (s[1] == 'l')
					{
						listflag = YES;
						s++;
					}
# endif OLDSTUFF
					break;
	
			  	case 'P':
					cprunonly = YES;
					loadflag = NO;
					*cpflagp++ = '-';
					*cpflagp++ = 'P';
					*cpflagp++ = ' ';
					break;
	
			  	case 'E':
					cprunonly = YES;
					loadflag = NO;
					cpoutput = YES;
					*cpflagp++ = '-';
					*cpflagp++ = 'E';
					*cpflagp++ = ' ';
					break;

			  	case 'C':		/* preprocessor flag */
					*cpflagp++ = '-';
					*cpflagp++ = 'C';
					*cpflagp++ = ' ';
					break;
	
			  	case 'D':		/* preprocessor flag */
			  	case 'I':		/* preprocessor flag */
			  	case 'U':		/* preprocessor flag */
					*cpflagp++ = '-';
					*cpflagp++ = *s;
					while (*++s)
						*cpflagp++ = *s;
					*cpflagp++ = ' ';
					goto endfor;

			  	case 'c':
					loadflag = NO;
					saveobjflag = YES;
					break;

			  	case 'v':
					verbose = YES;
					break;

# ifdef DEBUG
			  	case 'd':
					debugflag = YES;
					printflag = YES;
					break;
# endif DEBUG

				case 'm':
				case 'i':
					if(argv[1] && isdigit(argv[1][0]) &&  *(s+1) == '\0')
					{
						lflag[1] = *s;
						*loadp++ = copys(lflag);
						*loadp++ = *++argv;
						--argc;
						goto endfor;
					}
					lflag[1] = *s;
					*loadp++ = copys(lflag);
					break;
			  	case 'z':
					if(argv[1] && isdigit(argv[1][0]) && *(s+1) == '\0')
					{
						lflag[1] = *s;
						*loadp++ = copys(lflag);
						*loadp++ = *++argv;
						--argc;
						goto endfor;
					}
					printflag = YES;
					break;

			  	case 'p':
					if(argv[1] && isdigit(argv[1][0]) && *(s+1) == '\0')
					{
						lflag[1] = *s;
						*loadp++ = copys(lflag);
						*loadp++ = *++argv;
						--argc;
						goto endfor;
					}
					profileflag = YES;
					*c1flagp++ = '-';
					*c1flagp++ = 'p';
					*c1flagp++ = ' ';
					*fflagp++ = 'p';
					break;

			  	case 'o':
					aoutname = *++argv;
					--argc;
					break;

			  	case 'l':	/* letter ell--library */
					s[-1] = '-';
					*libp++ = s-1;
					goto endfor;

			  	case 'r':
					runflag = YES;
					break;
	
			  	case 'g':
					gflag = YES;
					break;

# ifdef DEBUG
			  	case 'n':
					driverdebug = YES;
					break;
# endif DEBUG

			  	default:
					lflag[1] = *s;
					*loadp++ = copys(lflag);
					break;
			    }
endfor:
		;
	}

	pid = getpid();
	crfnames();

	strcat(cpflagp,inclpath);  /* Add default include path to options */
/*	*cpflagp = '\0';	*/
	*c1flagp = '\0';
	*c3flagp = '\0';

	if (*chpathp)
	{
		while (*chpassp)
		{
			switch (*chpassp++)
			{
		  	case 'p':
				passpname=catstr(chpathp,lastfield(passpname));
				break;
	
		  	case '1':
				pass1name=catstr(chpathp,lastfield(pass1name));
				break;

		  	case 'O':
				goptname=catstr(chpathp,lastfield(goptname));
				break;

		  	case '2':
				codegname=catstr(chpathp,lastfield(codegname));
				break;

		  	case 'a':
				asmname=catstr(chpathp,lastfield(asmname));
				break;

		  	case 'l':
				ldname=catstr(chpathp,lastfield(ldname));
				break;

		  	case 'b':
				basname=catstr(chpathp,lastfield(basname));
				break;

		  	case 'f':
				f77name=catstr(chpathp,lastfield(f77name));
				break;

		  	case 'F':
				footname=catstr(chpathp,lastfield(footname));
				break;

		  	default:
				erri("Bad option '-a%c'.", *(chpassp-1));
			}
		}
	}
	loadargs[0] = ldname;

	*loadp++ = (profileflag ? proffoot : footname);


	for (i = 0 ; i < nfiles ; ++i)
		switch (c =  dotchar(infname = fileargs[i]) )
		{
		  case 'c':
		  case 'f':
		  case 'b':
		  case 's':
		  case 'p':
			ncomps++;
			break;
		}
	if (ncomps > 1)
		saveobjflag = YES;
	for (i = 0 ; i < nfiles ; ++i)
		switch (c =  dotchar(infname = fileargs[i]) )
		{
			case 'c':	/* C file */
				if (ncomps > 1)
					fprintf(diagfile, "%s:\n", fileargs[i]);
				else if (ncomps == 1)
					savedotoname = setdoto(copys(fileargs[i]));
				if ( unreadable(fileargs[i]) )
					erred = YES;
				else if ( docc(fileargs[i]) )
					erred = YES;
				else
				{
					if (saveobjflag)
					{
						if(nodup(t = setdoto(copys(fileargs[i]))))
							*loadp++ = t;
					}
					else
						*loadp++ = objfname;
				}
				break;

			case 'f':	/* Fortran file */
				if ( unreadable(fileargs[i]) )
				{
					erred = YES;
					break;
				}
				if (ncomps > 1)
					fprintf(diagfile, "%s:\n", fileargs[i]);
				else if (ncomps == 1)
					savedotoname = setdoto(copys(fileargs[i]));
				starting("F77.");
				sprintf(sysb, "%s %s %s %s",
					f77name,fflags,f77bug,fileargs[i]);
				if (sys(sysb))
					erred = YES;
				else
				{
					if (saveobjflag)
					{
						if(nodup(t=setdoto(copys(fileargs[i]))))
							*loadp++ = t;
					}
					else
						*loadp++ = objfname;
				}
				break;


			case 'b':	/* BASIC file */
/*
				if ( unreadable(fileargs[i]) )
				{
					erred = YES;
					break;
				}
				if (ncomps > 1)
					fprintf(diagfile, "%s:\n", fileargs[i]);
				else if (ncomps == 1)
					savedotoname = setdoto(copys(fileargs[i]));
				starting("CC.");
				sprintf(sysb,"%s %s %s %s",
					basname,basflags,basbug,fileargs[i]);
				if (sys(sysb))
					erred = YES;
				else
				{
					if (saveobjflag)
					{
						if(nodup(t=setdoto(copys(fileargs[i]))))
							*loadp++ = t;
					}
					else
						*loadp++ = objfname;
				}
 */
				break;

			case 's':	/* Assembler file */
				if (saveasmflag)
					break;
				if ( unreadable(fileargs[i]) )
				{
					erred = YES;
					break;
				}
				if (saveobjflag)
				{
					strcpy(objfname,lastfield(fileargs[i]));
					setdoto(objfname);
				}
				if (ncomps > 1)
					fprintf(diagfile, "%s:\n", fileargs[i]);
				starting("ASM.");
				sprintf(sysb, "%s %s -e -o %s %s",
					asmname,asmbug,objfname,fileargs[i]);
				if (sys(sysb))
					erred = YES;
				else
				{
					if (ncomps == 1 && !saveobjflag)
						savedotoname = setdoto(copys(fileargs[i]));
					if (saveobjflag)
					{
						if(nodup(t = setdoto(copys(fileargs[i]))))
							*loadp++ = t;
					}
					else
						*loadp++ = objfname;
				}
				break;


			case 'p':	/* Pascal file */
				break;

			case 'o':	/* Object file */
				if ( nodup(fileargs[i]) )
					*loadp++ = fileargs[i];
				break;

			default:
				if ( strequal(fileargs[i], "-o") )
					aoutname = fileargs[++i];
				else
					*loadp++ = fileargs[i];
				break;
		}

	for(libp = libargs; *libp; loadp++, libp++)
		*loadp = *libp;

	if (loadflag && !erred && !saveasmflag)
		doload(loadargs, loadp);
	done(erred);
}

docc(s)
char *s;
{
	int retcode;
	register int i;

	infname = s;
	if (saveobjflag || saveasmflag)
	{
		strcpy(objfname,lastfield(infname));
		*lastchar(objfname) = 'o';
	}

	modulename = lastfield(infname);
	for (i=0 ; *modulename != '.' ; i++)
		modul[i] = *(modulename++);
	modul[i++] = NULL;
	modulename = modul;

	if (cpoutput)
		prepfname[0] = '\0';
	else if (cprunonly)
	{
		strcpy(prepfname, lastfield(infname));
		*lastchar(prepfname) = 'i';
	}
	starting("CPP.");
/*	fprintf(diagfile, "%s %s %s  %s %s",
		passpname, passpbug, cpflags, infname, prepfname); */
	sprintf(sysb, "%s -DREGARGS %s %s  %s %s",
		passpname, passpbug, cpflags, infname, prepfname);
	if (sys(sysb))
		goto error;

	if (cprunonly)
	{
		retcode = 0;
		goto ret;
	}

	starting("CPARSE.");
	sprintf(sysb,"%s %s %s -E %s <%s",pass1name,
		c1flags,pass1bug,strip(textfname),prepfname);
	switch (sys(sysb))
	{
		case 1:
			goto error;
		case 0:
			break;
		default:
			goto comperror;

	}
	if ( docodeg() )
		goto comperror;

	doasm();

	retcode = 0;

ret:
	return(retcode);

error:
	err("Error.  No assembly.");
	retcode = 1;
	goto ret;

comperror:
	fatal("Compiler error.");
	retcode = 2;
	goto ret;
}

docodeg()
{
	static int	firsttime = 1;

	if (goptlevel != '0')
	{
		starting("GOPT.");
		sprintf(sysb,"%s -%c -E %s >%s", goptname,
			goptlevel, strip(textfname), optzfname);
		if (access(goptname,0))
			fprintf(diagfile, "Global optimizer not on system- no optimization performed\n");
		else if (sys(sysb))
			fprintf(diagfile, "Global optimizer error - no optimization performed\n");
		else
		{
			starting("MOVE.");
			sprintf(sysb, "/bin/mv %s %s", optzfname, textfname);
			if (sys(sysb))
				fatal(" Cannot move files");
		}
	}

	/*
	** NOTE that at this point, the -g option has a different
	** meaning to the C compiler and the FORTRAN compiler.
	** In both cases, it means to turn on the debugger option,
	** but to the C compiler, it means the iocp debugger, db,
	** and to the FORTRAN compiler, it means the user debugger,
	** debug. The FORTRAN driver passes the -g option to the code
	** generator, which means to turn off delayed stores and etc.
	** When tne -g option is specified to the C compiler,
	** it passes the -l option to the code generator, which just
	** puts out line numbers.
	*/
	if(gflag)
		codegbug = catstr(codegbug," -l");

	if (firsttime && profileflag)
		codegbug = catstr(codegbug," -p");

	if (firsttime && (goptlevel == '3' || goptlevel == '5'))
		codegbug = catstr(codegbug," -R");
		
	firsttime = 0;
	starting("CODGEN.");
	sprintf(sysb, "%s %s %s -E %s <%s >%s",codegname,
		c3flags, codegbug,strip(datafname), textfname,asmfname);
	return (sys(sysb));
}

doasm()
{
	char nameasmf[25];

	if (saveasmflag)
	{
		*lastchar(objfname) = 's';

		starting("MOVE.");

		sprintf(sysb, "/bin/cp %s %s",
			asmfname, objfname);
		if (sys(sysb))
			fatal(" Cannot copy files");
		*lastchar(objfname) = 'o';
		
		if (listflag)
		{
			starting("LIST.");

			sprintf(sysb,"%s %s",listgname,infname);
			if (sys(sysb))
				fatal(" Cannot list file");
		}

	}
# ifndef HEP
	strcpy(nameasmf, lastfield(infname));
	strcpy(lastchar(nameasmf), "has");
	if (!saveasmflag)
	{
		starting("CP.");
		sprintf(sysb, "/bin/cp %s %s", asmfname, nameasmf);
		if(sys(sysb))
			fatal("cannot copy assembler file");
	}
# endif

	if(noasm)
		return;
	
	starting("ASM.");
	strcpy(asmopts,"-e");
	if(debugflag) strcat(asmopts," -v");
	if (listflag) strcat(asmopts," -l -s");
	if (gflag) {
# ifdef OLDSTUFF
		strcpy(nameasmf,lastfield(infname));
		strcpy(lastchar(nameasmf),"sym");
		sprintf(sysb,"/bin/cp %s %s",symfname,nameasmf); /* copy syms */
		if (sys(sysb))
			fatal("cannot copy symbol file");
		strcat(asmopts,"*");	/* dummy char for lastchar call */
		strcpy(lastchar(asmopts)," -g *");
# else
		strcat(asmopts," -g");
# endif

# ifdef OLDSTUFF
		strcpy(lastchar(asmopts), lastfield(infname));
		strcpy(lastchar(asmopts), "sym *");
		strcpy(lastchar(asmopts), lastfield(infname));
		strcpy(lastchar(asmopts), "ast ");
# endif
	}
	strcat(asmopts," -o");
	strcpy(nameasmf,asmfname);
/*	printf("%s %s %s %s %s\n",
			asmname,asmbug,asmopts,objfname,nameasmf);
*/
	sprintf(sysb, "%s %s %s %s %s",
			asmname,asmbug,asmopts,objfname,nameasmf);

	if( sys(sysb) )
	{
		fatal("assembler error");
	}
}

doload(v0, v)
register char *v0[], *v[];
{
	register char **p;
	int waitpid;

	for (p = liblist ; *p ; *v++ = *p++)
		;

	*v++ = "-o";
	*v++ = aoutname;
	*v = NULL;

	starting("LOAD.");
	if (printflag)
	{
		for (p = v0 ; p<v ; ++p)
			fprintf(diagfile, "%s ", *p);
		fprintf(diagfile, "\n");
	}

	if (driverdebug)
		return;

	if ( (waitpid = fork()) == 0)
	{
		enbint(SIG_DFL);
		execv(ldname, v0);
		fatalstr("couldn't load %s", ldname);
	}
	if (await(waitpid))
	{
		erred = YES;

		if (ncomps == 1 && !saveobjflag)
		{
			starting("MOVE.");
			sprintf(sysb, "/bin/mv %s %s",objfname, savedotoname);
			if (sys(sysb))
				fatal(" Cannot move files");
		}
	}

}

/* Process control and Shell-simulating routines */

sys(str)
char *str;
{
	register char *s, *t;
	char *argv[100];
	register char *inname, *outname;
	int append;
	int waitpid;
	register int argc;


	if (printflag)
		fprintf(diagfile, "%s\n", str);

	inname  = NULL;
	outname = NULL;
	argv[0] = shellname;
	argc = 1;

	t = str;
	while ( isspace(*t) )
		++t;
	while (*t)
	{
		if (*t == '<')
			inname = t+1;
		else if (*t == '>')
		{
			if (t[1] == '>')
			{
				append = YES;
				outname = t+2;
			}
			else	
			{
				append = NO;
				outname = t+1;
			}
		}
		else
			argv[argc++] = t;
		while ( !isspace(*t) && *t!='\0' )
			++t;
		if (*t)
		{
			*t++ = '\0';
			while ( isspace(*t) )
				++t;
		}
	}

	if (argc == 1)   /* no command */
		return(-1);
	argv[argc] = 0;

	if (driverdebug)
		return 0;

	strcpy(currpass,argv[1]);	/* save current state name */

	if ((waitpid = fork()) == 0)
	{
		if (inname)
			freopen(inname, "r", stdin);
		if (outname)
			freopen(outname, (append ? "a" : "w"), stdout);
		enbint(SIG_DFL);

		texec(argv[1], argv);  /* command */

		fatalstr("cannot load %s",argv[1]);
	}

	return( await(waitpid) );
}


#include "errno.h"

/* modified version from the Shell */
texec(f, av)
char *f;
char **av;
{
	extern int errno;

	execv(f, av+1);

	if (errno==ENOEXEC)
	{
		av[1] = f;
		execv(shellname, av);
		fatal("No shell!");
	}
	if (errno==ENOMEM)
		fatalstr("%s: too large", f);
}

starting(s)
char *s;
{
	if (verbose)
		fprintf(diagfile,"\r %s		\r",s);
}

done(k)
int k;
{
	static int recurs	= NO;

	if (recurs == NO)
	{
		recurs = YES;
		rmfiles();
	}
	starting("		");
	if (runflag && !k)
		execl (aoutname, aoutname, NULL);
	exit(k);
}

enbint(k)
int (*k)();
{
	if (sigivalue == 0)
		signal(SIGINT,k);
	if (sigqvalue == 0)
		signal(SIGQUIT,k);
	if (sighvalue == 0)
		signal(SIGHUP,k);
	if (sigtvalue == 0)
		signal(SIGTERM,k);
}

intrupt()
{

	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGHUP, SIG_IGN);
	signal(SIGTERM,SIG_IGN);

	done(2);
}

await(waitpid)
int waitpid;
{
	int w, status;

/*	enbint(SIG_IGN);*/
	while ( (w = wait(&status)) != waitpid)
		if (w == -1)
			fatal("Bad wait code.");
	enbint(intrupt);
	if (status & 0377)
	{
		if (status == 0213)
			fatalstr("Segmentation violation in %s",currpass);
		else if (status != SIGINT)
			fatlsti("Termination code : %o in %s",
							status, currpass);
		done(3);
	}
	return(status>>8);
}

/*
 *	File Name and File Manipulation Routines
 */

unreadable(s)
register char *s;
{
	register FILE *fp;

	if (fp = fopen(s, "r"))
	{
		fclose(fp);
		return(NO);
	}
	errstr("Cannot read file '%s'", s);
	return(YES);
}

clf(p)
FILEP *p;
{
	if (p!=NULL && *p!=NULL && *p!=stdout)
	{
		if (ferror(*p))
			fatal("writing error");
		fclose(*p);
	}
	*p = NULL;
}

rmfiles()
{
	rmf(textfname);
	rmf(datafname);
	rmf(asmfname);
	if (!cprunonly)
		rmf(prepfname);
	rmf(optzfname);
	rmf(symfname);
	if (!saveobjflag && !saveasmflag)
		rmf(objfname);
}

/*
 *   return -1 if file does not exist, 0 if it is of zero length
 *   and 1 if of positive length
 */

content(filename)
char *filename;
{
# include <sys/types.h>
# include <sys/stat.h>
	struct stat buf;

	if (stat(filename,&buf) < 0)
		return(-1);

	return( buf.st_size > 0 );
}

crfnames()
{
	fname(textfname, "I");
	fname(datafname, "D");
	fname(asmfname, "s");
	fname(objfname, "o");
	fname(prepfname, "p");
	fname(optzfname, "z");
	fname(symfname, "S");
}

rmf(fn)
register char *fn;
{
	if (!debugflag && fn!=NULL && *fn!='\0')
		unlink(fn);
}

fname(name, suff)
char *name, *suff;
{
	if (!debugflag)
		sprintf(name, "/tmp/cc.%d.%s", pid, suff);
	else
		sprintf(name, "cc.%d.%s", pid, suff);
}

dotchar(s)
register char *s;
{
	for ( ; *s ; ++s)
	{
		if ( s[0] == '.' && (s[1] == 'h' && s[2] == 'a'
		     && s[3] == 's' && s[4] == '\0') )
			return('s');
		if (s[0]=='.' && s[1]!='\0' && s[2]=='\0')
			return( s[1] );
	}
	return(NO);
}

char *
lastfield(s)
register char *s;
{
	register char *t;
	for (t = s; *s ; ++s)
		if (*s == '/')
			t = s+1;
	return(t);
}

char *
lastchar(s)
register char *s;
{
	while (*s)
		++s;
	return(s-1);
}

char *
setdoto(s)
register char *s;
{
	char *t;
	t = lastchar(s);
	while(*(t-1) != '.')
		--t;
	*t = 'o'; *(t+1) = '\0';
	return( lastfield(s) );
}

badfile(s)
char *s;
{
	fatalstr("cannot open intermediate file %s", s);
}

ptr ckalloc(n)
int n;
{
	register ptr p;
	ptr calloc();

	if ( p = calloc(1, (unsigned) n) )
		return(p);

	fatal("out of memory");
}

char *
copys(s)
char *s;
{
	return(strcpy(ckalloc(strlen(s)+EXTRA),s));
}

char *
strip(s)
char *s;
{
	register char	*ns;
	register char 	*t, *dot;

	ns = strcpy(ckalloc(strlen(s)+1),s);
	for (t = ns; *t ; ++t)
		if (*t == '.')
			dot = t;
	*dot = '\0';
	return ns;
}

char *
catstr(s1, s2)
char *s1, *s2;
{
	char *string;

	string = strcpy(ckalloc(strlen(s1)+strlen(s2)+1),s1);
	return(strcat(string, s2));
}

oneof(c,s)
register c;
register char *s;
{
	while ( *s )
		if (*s++ == c)
			return(YES);
	return(NO);
}

nodup(s)
char *s;
{
	register char **p;

	for (p = loadargs ; p < loadp ; ++p)
		if ( strequal(*p, s) )
			return(NO);

	return(YES);
}

err(t)
char *t;
{
	fprintf(diagfile, "Error in file %s: %s\n", infname, t);
	done(1);
/*
	if (debugflag)
		abort();
*/
	exit(1);
}

erri(t,d)
char *t;
int d;
{
	char ebuff[100];
	sprintf(ebuff, t, d);
	err(ebuff);
}

errstr(t, s)
char *t, *s;
{
	char ebuff[100];
	sprintf(ebuff, t, s);
	err(ebuff);
}

fatal(t)
char *t;
{
	fprintf(diagfile, "Compiler error in file %s: %s\n", infname, t);
	done(1);
/*
	if (debugflag)
		abort();
*/
	exit(1);
}

fatali(t,d)
char *t;
int d;
{
	char ebuff[100];
	sprintf(ebuff, t, d);
	fatal(ebuff);
}

fatalstr(t, s)
char *t, *s;
{
	char ebuff[100];
	sprintf(ebuff, t, s);
	fatal(ebuff);
}

fatlsti(t, i, s)
char *t, *s;
int i;
{
	char ebuff[100];
	sprintf(ebuff, t, i, s);
	fatal(ebuff);
}
