
# Name:  CC.MK	Part No.: _______-____r
#			
#		   DENELCOR, INC. SOFTWARE ENGINEERING
#
# The recipient of this product specifically agrees not to distribute,
# disclose, or disseminate in any way, to any one, nor use for its own
# benefit, or the benefit of others, any information contained  herein
# without the expressed written consent of Denelcor, Inc.
#
#                      RESTRICTED RIGHTS LEGEND
#
# Use, duplication, or disclosure by the Government is  subject  to
# restriction  as  set forth in paragraph (b) (3) (B) of the Rights
# in Technical Data and Computer Software  Clause  in  DAR  7-104.9
# (a).
# Denelcor, Inc.
# 17000 E. Ohio Place
# Aurora, CO  80017
#
# @(#)CC.MK	1.15

# makefile to compile the cc compiler on the IOCP to run on the PEM

ROOT = /usr/hepstuff/
TARGET = bin
LIB = lib
SOURCE = /usr/src/cmd/pem/zcc
INCLUDE = /usr/hinclude
PREFIX = z

CC = /bin/$(PREFIX)cc
CFLAGS = -DHEP
OPTIONS = -Ta/bin/nfzas
LIBC = /lib/lib$(PREFIX)c.a

GET = /usr/bin/get
GFLAGS =

FRC =

PASS1 = \
	cgram1.hao \
	code1.hao \
	comm1.hao \
	local1.hao \
	optim1.hao \
	pftn1.hao \
	scan1.hao \
	sym1.hao \
	trees1.hao \
	vinit1.hao \
	xdefs1.hao

PASS3 = \
	allo3.hao \
	comm3.hao \
	lcl3.hao \
	local3.hao \
	match3.hao \
	optim3.hao \
	order3.hao \
	rdr3.hao \
	reader3.hao \
	regallo3.hao \
	regs3.hao \
	stats3.hao \
	table3.hao \
	tr3.hao \
	wrt3.hao

ASSEM = \
	cgram1.has \
	code1.has \
	comm1.has \
	local1.has \
	optim1.has \
	pftn1.has \
	scan1.has \
	sym1.has \
	trees1.has \
	vinit1.has \
	xdefs1.has \
	allo3.has \
	comm3.has \
	lcl3.has \
	local3.has \
	match3.has \
	optim3.has \
	order3.has \
	rdr3.has \
	reader3.has \
	regallo3.has \
	regs3.has \
	table3.has \
	tr3.has \
	wrt3.has \
	cpp.has \
	cpy.h́
	zcc.has

all: echoinfo cc cpp pass1 pass3

echoinfo:
	@/bin/echo "\t***** cc CC.MK:  Version 1.15"

clean:
	-/bin/rm -f mfile1 mfile3 mfile1.h mfile3.h mopt.h \
		manifest.h macdefs.h macdefs3.h macdefs1.h \
		motabdefs3.h yaccdefs.h \
		$(ASSEM) \
		$(PASS1) \
		$(PASS3) \
		zcc.hao \
		cpp.hao \
		cpy.hao

clobber: clean
	-/bin/rm -f cc
	-if test "$(ROOT)$(TARGET)" = "`pwd`" ; then \
		/bin/rm -f $(ROOT)$(LIB)/pass1 ; \
		/bin/rm -f $(ROOT)$(LIB)/pass3 ; \
		/bin/rm -f $(ROOT)$(LIB)/cpp ; \
	else \
		/bin/rm -f pass1 pass3 cpp ; \
	fi

cc:\
	zcc.hao \
	$(LIBC) \
	$(FRC)
	$(CC) $(CFLAGS) $(OPTIONS) zcc.hao -o cc
	/bin/chmod 755 cc
	/bin/chgrp bin cc
	/bin/chown bin cc

zcc.hao:\
	$(INCLUDE)/stdio.h \
	$(INCLUDE)/ctype.h \
	$(INCLUDE)/signal.h \
	$(INCLUDE)/errno.h \
	$(INCLUDE)/sys/types.h \
	$(INCLUDE)/sys/stat.h \
	$(SOURCE)/s.driver.c \
	$(SOURCE)/s.drivedefs.h \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/s.driver.c -p >zcc.c
	$(GET) $(GFLAGS) $(SOURCE)/s.drivedefs.h
	$(CC) $(CFLAGS) $(OPTIONS) -c zcc.c
	-/bin/rm -f zcc.c drivedefs.h

cpp:\
	cpp.hao \
	cpy.hao \
	$(LIBC) \
	$(FRC)
	$(CC) $(CFLAGS) $(OPTIONS) cpp.hao cpy.hao -o cpp
	/bin/chmod 755 cpp
	/bin/chgrp bin cpp
	/bin/chown bin cpp
	-if test "$(ROOT)$(TARGET)" = "`pwd`" ; then \
		/bin/mv cpp $(ROOT)$(LIB)/cpp ; \
	fi

cpp.hao:\
	$(INCLUDE)/stdio.h \
	$(SOURCE)/cp/s.cpp.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/cp/s.cpp.c
	$(CC) $(CFLAGS) $(OPTIONS) -c cpp.c
	-/bin/rm -f cpp.c

cpy.hao:\
	$(SOURCE)/cp/s.cpy.y \
	$(SOURCE)/cp/s.yylex.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/cp/s.cpy.y
	$(YACC) cpy.y
	-/bin/mv y.tab.c cpy.c
	-/bin/rm -f cpy.y
	$(GET) $(GFLAGS) $(SOURCE)/cp/s.yylex.c
	$(CC) $(CFLAGS) $(OPTIONS) -c cpy.c
	-/bin/rm -f yylex.c cpy.c

pass1:\
	$(PASS1) \
	$(LIBC) \
	$(FRC)
	$(CC) $(CFLAGS) $(OPTIONS) $(PASS1) -o pass1
	/bin/chmod 755 pass1
	/bin/chgrp bin pass1
	/bin/chown bin pass1
	-if test "$(ROOT)$(TARGET)" = "`pwd`" ; then \
		/bin/mv pass1 $(ROOT)$(LIB)/pass1 ; \
	fi

cgram1.hao:\
	mfile1 \
	$(SOURCE)/p1/s.cgram1.y \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.cgram1.y
	$(YACC) cgram1.y
	-/bin/mv y.tab.c cgram1.c
	-/bin/rm -f cgram1.y
	$(CC) -c $(CFLAGS) $(OPTIONS) cgram1.c
	-/bin/rm -f cgram1.c

code1.hao:\
	mfile1 \
	$(INCLUDE)/ctype.h \
	$(INCLUDE)/signal.h \
	$(SOURCE)/p1/s.code1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.code1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c code1.c
	-/bin/rm -f code1.c

comm1.hao:\
	mfile1 \
	$(SOURCE)/s.common \
	$(SOURCE)/p1/s.comm1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/s.common
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.comm1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c comm1.c
	-/bin/rm -f comm1.c common

local1.hao:\
	mfile1 \
	$(SOURCE)/p1/s.local1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.local1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c local1.c
	-/bin/rm -f local1.c

optim1.hao:\
	mfile1 \
	$(SOURCE)/s.optim \
	$(SOURCE)/p1/s.optim1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/s.optim
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.optim1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c optim1.c
	-/bin/rm -f optim1.c optim

pftn1.hao:\
	mfile1 \
	$(SOURCE)/p1/s.pftn1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.pftn1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c pftn1.c
	-/bin/rm -f pftn1.c

scan1.hao:\
	mfile1 \
	$(SOURCE)/p1/s.scan1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.scan1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c scan1.c
	-/bin/rm -f scan1.c

sym1.hao:\
	mfile1 \
	$(SOURCE)/p1/s.sym1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.sym1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c sym1.c
	-/bin/rm -f sym1.c

trees1.hao:\
	mfile1 \
	$(SOURCE)/p1/s.trees1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.trees1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c trees1.c
	-/bin/rm -f trees1.c

vinit1.hao:\
	mfile1 \
	$(SOURCE)/p1/s.vinit1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.vinit1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c vinit1.c
	-/bin/rm -f vinit1.c

xdefs1.hao:\
	mfile1 \
	$(SOURCE)/p1/s.xdefs1.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.xdefs1.c
	$(CC) $(CFLAGS) $(OPTIONS) -c xdefs1.c
	-/bin/rm -f xdefs1.c

mfile1:\
	manifest.h \
	$(SOURCE)/p1/s.mfile1.h \
	$(SOURCE)/s.macdefs.h \
	$(SOURCE)/s.mopt.h \
	$(SOURCE)//p1/s.yaccdefs.h \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.mfile1.h
	$(GET) $(GFLAGS) $(SOURCE)/s.macdefs.h
	$(GET) $(GFLAGS) $(SOURCE)/s.mopt.h
	$(GET) $(GFLAGS) $(SOURCE)/p1/s.yaccdefs.h
	touch mfile1


pass3:\
	$(PASS3) \
	$(LIBC) \
	$(FRC)
	$(CC) $(CFLAGS) $(OPTIONS) $(PASS3) -o pass3
	/bin/chmod 755 pass3
	/bin/chgrp bin pass3
	/bin/chown bin pass3
	-if test "$(ROOT)$(TARGET)" = "`pwd`" ; then \
		/bin/mv pass3 $(ROOT)$(LIB)/pass3 ; \
	fi

allo3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.allo3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.allo3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c allo3.c
	-/bin/rm -f allo3.c

comm3.hao:\
	mfile3 \
	$(SOURCE)/s.common \
	$(SOURCE)/p3/s.comm3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/s.common
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.comm3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c comm3.c
	-/bin/rm -f comm3.c common

lcl3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.lcl3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.lcl3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c lcl3.c
	-/bin/rm -f lcl3.c

match3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.match3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.match3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c match3.c
	-/bin/rm -f match3.c

local3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.local3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.local3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c local3.c
	-/bin/rm -f local3.c

optim3.hao:\
	mfile3 \
	$(SOURCE)/s.optim \
	$(SOURCE)/p3/s.optim3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/s.optim
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.optim3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c optim3.c
	-/bin/rm -f optim3.c optim

order3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.order3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.order3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c order3.c
	-/bin/rm -f order3.c

rdr3.hao:\
	mfile3 \
	$(SOURCE)/s.rdr \
	$(SOURCE)/p3/s.rdr3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/s.rdr
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.rdr3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c rdr3.c
	-/bin/rm -f rdr3.c rdr

reader3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.reader3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.reader3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c reader3.c
	-/bin/rm -f reader3.c

regallo3.hao:\
	mfile3 \
	$(SO//s.regallo3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.regallo3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c regallo3.c
	-/bin/rm -f regallo3.c

regs3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.regs3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.regs3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c regs3.c
	-/bin/rm -f regs3.c

stats3.hao:\
	$(SOURCE)/p3/s.stats3.has \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.stats3.has
	$(CC) $(CFLAGS) $(OPTIONS) -c stats3.has
	-/bin/rm -f stats3.has

table3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.table3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.table3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c table3.c
	-/bin/rm -f table3.c

tr3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.tr3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.tr3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c tr3.c
	-/bin/rm -f tr3.c

wrt3.hao:\
	mfile3 \
	$(SOURCE)/p3/s.wrt3.c \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.wrt3.c
	$(CC) $(CFLAGS) $(OPTIONS) -c wrt3.c
	-/bin/rm -f wrt3.c

mfile3:\
	manifest.h \
	$(SOURCE)/p3/s.mfile3.h \
	$(SOURCE)/s.macdefs.h \
	$(SOURCE)/s.mopt.h \
	$(SOURCE)/p3/s.motabdefs3.h \
	$(SOURCE)/p3/s.macdefs3.h \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.mfile3.h
	$(GET) $(GFLAGS) $(SOURCE)/s.macdefs.h
	$(GET) $(GFLAGS) $(SOURCE)/s.mopt.h
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.motabdefs3.h
	$(GET) $(GFLAGS) $(SOURCE)/p3/s.macdefs3.h
	touch mfile3

manifest.h:\
	$(INCLUDE)/stdio.h \
	$(SOURCE)/s.manifest.h \
	$(FRC)
	$(GET) $(GFLAGS) $(SOURCE)/s.manifest.h

FRC:

TSM>