  @  #include "defines.pet"  #define MAP_SIZE 2048*4   C_PARTITION(name,size,mem_class)   char *name;  int size,mem_class;  I/*=====================================================================*/ I I/*                                                                     */ I I/* MODULE NAME : C_PARTITION                                           */ I I/*                                                                     */ I I/* FILE NAME   : PARTITION.PET.C                                       */ I I/*                                                                     */ I I/* AUTHOR NAME : A CRANNY.    DATE : 2SEP83      BADGE NUMBER : 6701   */ I I/*                                                                     */ I                     @  I/* FUNCTION    : to  create and include a dynamic memory partition at  */ I I/*               nex availble map block in the tasks address space.    */ I I/*               The logical address of the mapblock is returned.      */ I I/*                                                                     */ I I/* INPUTS     :  name: the name of the partition                       */ I I/*               size : the number of map blocks in the partition      */ I I/*               mem_class : 0: any; 1 : Eclass; 2: H class; 3: S class*/ I I/*                                                                     */ I I/* OUTPUTS     : returns the logical address of the partition or       */ I                                                                       @  I/*               -1 if cant create -or- -2 if cant include.            */ I I/*                                                                     */ I I/*                           EDIT HISTORY                              */ I I/*                                                                     */ I I/* EDIT DATE |              LINE NO'S AND DESCRIPTION                  */ I I/* --------------------------------------------------------------------*/ I I/*                                                                     */ I I/*=====================================================================*/ I {  static struct  {        int ownr[2];        int user[2];        int owri;        int ugri;        int otri;        int sflg;    @        int res1;        int res2;        int res3;        int osiz;        int addr;        int fast;        int opts;        int res4;  }rcb = {  /      0,0,0,0,0XF8400000,0XF8400000,0Xf8400000, / "      0,0,0,0,8,0,0,0X00000000,0}; " int reg[8];  int i,*partition;  static struct {        int timo;        int abret;        short int cp_opts;        short int stat;        int cres1;        int cres2;        int fcba;  }cnp = {0,0,0x8000,0,0,0,0};     A      /* interrogate my memory map to find two free map blocks */ A    9      mpxsvc(0x1065,reg,reg);    /* GET ADDRESS LIMITS */ 9 F      partition = reg[5] + 4;    /* REMEMBER THE LOGICAL ADDRESS of */ F                                                           @  B                                 /* the next available mapblock */ B    4      /* check for room in the MAP for new blocks */ 4    4      if (reg[6] - (int)partition < size * MAP_SIZE) 4           return(-3);  K      rcb.addr = (int)partition/0x800; /* CALCULATE THE LOGICAL PAGE NUMBER K    *      /* delete potential old partition */ *          D_PARTITION(name);            /* create the partition */      9      rcb.osiz = size*4;         /* 4 pages to a block */ 9       rcb.opts += mem_class;  0      reg[1] = (int)(name) + (strlen(name)<<24); 0       reg[2] = &rcb;        reg[7] = 0;        mpxsvc(0x2022,reg,reg);  '      if (reg[7] != 0 && reg[7] != 8) { ' #ifdef DEBUG                                                         @  =            printf("C_PARTITION: Ceate returns %d\n",reg[7]); = #endif  >            return(-1);     /* couldnt create the partition */ >       }     !      /* include the partition */ !    0      reg[1] = (int)(name) + (strlen(name)<<24); 0       reg[4] = 0;        reg[5] = 0;        reg[7] = &cnp;        mpxsvc(0x2040,reg,reg);        if (cnp.stat != 0) {  #ifdef DEBUG  A            printf("C_PARTITION: Include returns %d\n",cnp.stat); A #endif  @            return(-2);      /* couldnt include the partition */ @       }     *      /* and return the logical address */ *          return(partition);  }  D_PARTITION(name)  char *name;  I/*=====================================================================*/ I        @  I/*                                                                     */ I I/* MODULE NAME : D_PARTITION                                           */ I I/*                                                                     */ I I/* FILE NAME   : PARTITION.PET.C                                       */ I I/*                                                                     */ I I/* AUTHOR NAME : A CRANNY.    DATE :11nov83      BADGE NUMBER : 6701   */ I I/*                                                                     */ I I/* FUNCTION    : to  delete  a dynamic memory partition                */ I I/*                                                                     */ I                                                                       @  I/* INPUTS     :  name: the name of the partition                       */ I I/*                                                                     */ I I/* OUTPUTS     : none                                                  */ I I/*                                                                     */ I I/*                                                                     */ I I/*                           EDIT HISTORY                              */ I I/*                                                                     */ I I/* EDIT DATE |              LINE NO'S AND DESCRIPTION                  */ I I/* --------------------------------------------------------------------*/ I                                                                       z@  I/*                                                                     */ I I/*=====================================================================*/ I {  int reg[8];     3      /* delete the partition from the directory */ 3    +      reg[1] = name + (strlen(name) << 24); +       reg[7] = 0;        mpxsvc(0X2024,reg,reg);           return(0);  }                                                                                                                                                                                                                                                                                                                                                                                                       