/*~!PASS2.C*/
/* Name: PASS2.C Part No.: _______-___r
 *
 *				SOFTWARE ENGINEERING
 *
 *  The recipient of this product specifically agrees not to distribute,
 *  disclose, or disseminate in any way, to any one, nor use for its own
 *  benefit, or the benefit of others,  any information contained herein
 *  without the expressed written consent of Software Engineering.
 */
/*
 *			 I S C   A s s e m b l e r
 *
 *			       P A S S 2 . C
 *
 *				Revision History
 *				----------------
 *
*/
#include	"has.h"

extern	int	label;
extern	struct pscdata pseudocodes[];
extern	struct sdata easycodes[];
extern	struct sdata hardcodes[];
extern	short	listing;
extern  int32	*addrp;
/*
 *	P A S S 2 ( )
 *
 *	Pass2() is responsible for figuring out what function
 *	should be called to handle outputing a line.  It uses
 *	two tables, one based on exact matchs and another based
 *	on finding a prefix.  Handling of the line is essentially
 *	based on what the first "token" on that line is.  Normally
 *	this would be an op-code, but it could be an assembler
 *	directive or a label too.
 */
pass2 (fieldp)
register char	**fieldp;
{
	register struct	sdata	*cp;
	register struct pscdata *pp;
	char *n;
	int k;
	int err;

	if (label)++fieldp;
	if (*fieldp == 0) {
		prtbloc();
		return (0);		/* line with only a label */
	}
	n = *fieldp;
	/* test for pseudo op */
	for (pp = pseudocodes; pp->token[1] < *(n+1); pp++)
		;
	while ((k = strcmp(pp->token, n)) < 0)
		pp++;
	if (k == SAME) {
		if (pp->pass2 != NULL)
			return ((*pp->pass2) (pp->token, fieldp));
			/*  call appropriate routine in do2pseudo  */
		else{
			prtbloc();
			return (0);
		}
	}
	for (cp = easycodes; cp->token[0] < *n; cp++)
		;
	while ((k = strcmp(cp->token, n)) < 0)
		cp++;
	if (k == SAME) {
		if (err = ((*cp->function) (cp->token, fieldp))) {
			dumpqword((short)2);
			return(err);
		} else
			return (0);
	}
	for (cp = hardcodes; cp->token[0] < *n; cp++)
		;
	for ( ; (cp->token != (char *)'\177') && (cp->token[0] == *n); cp++)
		if (prefix(cp->token, n) == SAME) {
			if (*addrp % 4) {
				dumpqword((short)2);
				if (listing)
					printf("\n");
			}
			if (err = ((*cp->function) (cp->token, fieldp))) {
				dump2qw((short)2, (short)2);
				return(err);
			} else
				return (0);
		}
	error ("unrecognized input");
	return (-1);
}
