/*~!HAS.OUT.H*/
/* Name:  HAS.OUT.H Part No.: _______-____r
 *			
 *		     	SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *			H A S . O U T . H
 *
 *	Header file for use in interpreting HEP binaries.
 *
 *	Used by:
 *		has	HEP UNIX Assembler
 *		hld	HEP UNIX Linker
 *
 *			Revision History
 *			----------------
 */

struct exec {
	/* Note: All sizes and locations in bytes */
	WORD	a_magic;	/* HEP magic number */
	WORD	a_text;		/* Size of text segment */
	WORD	a_data;		/* Size of initialized data area */
	WORD	a_bss;		/* Size of uninitialized data area */
	WORD	a_maxpsws;	/* Maximum number of PSW's   */
	WORD	a_constant;	/* Size of constant segment (unused) */
	WORD	a_trsize;	/* Size of text relocation info */
	WORD	a_drsize;	/* Size of data relocation info */
	WORD	a_syms;		/* Size of symbol table */
	WORD	a_entry;	/* Program entry point */
	WORD	a_maxstack;	/* Total size of stack space in bytes  */
	WORD	a_symstrsiz;	/* Size of symbol string table */
		/* Note: If a_symstrsiz is zero, the object is of the old format
			 (or if a_syms == 0, is a stripped executable) */
	WORD	a_areg;		/* Number of registers to allocate at   */
				/* process creation time by EXEC.       */
	WORD	a_ipsw;		/* The number of PSW's for each HEP/UPX  */
				/* process sharing data memory or the    */
				/* initial number of PSW's to allocate.  */
	WORD	a_spare[2];					     /*  */
};

#define	HEPMAGIC	17476	/* 0x4444L 042104 denotes HEP executable  */

#define STACKSIZE	0x10000L	/* 32kb is current default */
					/* should be smaller with new compiler */
#define	SYMSIZ		32

/* The following structure should be used when a program generates objects
   with flexible or fixed length names 	    */
struct nlist {
	char	n_name[SYMSIZ];	/* symbol name */
	WORD	n_value;	/* symbol value or sdb offset */
	short	n_type;		/* type and sdb bits (see below, also stab.h) */
	short	n_symnum;	/* used internally by the assembler */
	short	n_align;	/* alignment code (see below) */
	short	n_spare;
};


/* Definitions for n_flags */
#define	N_TYPE		0037	/* Mask for symbol type bits */
#define	N_UNDEF		0000	/* Symbol is undefined */
#define	N_TEXT		0001	/* Text symbol */
#define	N_DATA		0002	/* Data symbol */
#define	N_BSS			0003	/* BSS symbol */
#define	N_REG			0004	/* Register symbol (unimplemented) */
#define	N_CONST		0005	/* Constant symbol (unimplemented) */
#define	N_FILE		0006	/* Filename symbol (set only by linker) */
#define	N_ABS			0007	/* Absolute value */
#define	N_VAR			0010	/* Automatic variable symbol  */
#define	N_CONSTA		0013	/* non-indexed constant symbol */  /* D001 */
#define	N_REGI      0014    /* Indexed register symbol */
#define	N_COMM		0020	/* Common symbol (used by linker) */

#define N_EXTERN		0040	/* This is an external reference */

/* Definitions for n_align */
#define	N_AMASK		0003	/* Alignment mask (for common data) */
#define	N_ABYTE		0001	/* On a byte boundary */
#define	N_AQWORD		0002	/* On a quarter word boundary */
#define	N_AHWORD		0004	/* On a half word boundary */
#define	N_AFWORD		0010	/* On a full word boundary */
#define	N_AFILE		0040	/* On a file boundary */

struct relocation {
	WORD	r_address;	/* byte address which is to be relocated */
	short	r_type;		/* uses N_TYPE values, base space */
	short	r_symnum;	/* identifier of symbol in this file */
	short	r_length;	/* length or instruction type */
	short	r_pad;		/* --Spare-- */
};

/* Defines for r_flags */
#define	R_NTYPE		N_TYPE	/* mask for relocation base */
#define	R_BSYM		N_EXTERN /* relocate relative to r_symnum */

/* Define for r_length */
#define	R_VSIZE		00007	/* Mask for size/type of relocated value */
#define	R_HWORD		00001	/* 32 bits */
#define	R_FWORD		00002	/* 64 bits */
#define	R_ILOD		00003	/* A LOD instruction */
#define	R_ILODA		00004	/* A LODA instruction */
#define	R_ISTO		00005	/* A STO instruction */
#define	R_IBR		00006	/* A B(ranch) instruction */
