/*~!DECODERS.C*/
/* Name:  DECODERS.C Part No.: _______-____r
 *			
 *		            SOFTWARE ENGINEERING
 *
 * The recipient of this product specifically agrees not to distribute,
 * disclose, or disseminate in any way, to any one, nor use for its own
 * benefit, or the benefit of others, any information contained  herein
 * without the expressed written consent of Software Engineering.
 *
 *                     RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure by the Government is  subject  to
 * restriction  as  set forth in paragraph (b) (3) (B) of the Rights
 * in Technical Data and Computer Software  Clause  in  DAR  7-104.9
 * (a).
 */
/*
 *			 I S C   A s s e m b l e r
 *
 *			    D E C O D E R S . C
 *
 *                         Revision History
 *                         ----------------
 *
*/

#include	<ctype.h>
#include	"has.h"

#define	MAXREG   	7			/* Largest allowed register displacement */
#define A_ABS      -1           /* Absolute address mode flag */
#define A_UNK       0           /* Unknown address mode flag */
#define A_IND       1           /* Index address mode flag */

#define NNULL  (struct nlist *) NULL

extern struct nlist *get();
extern int32 atol();
extern char *strchr();
extern char *strcpy();
extern FILE *constfd;

/*
 *	S R E G I S T E R ( )
 *
 *	Decodes a source register specification and fills in
 *	the given address with the result.  Returns -1 on error,
 *	and 0 upon success.
 */
sregister (strp, wordp)
register char	*strp;
short	*wordp;
{
	short	reg;

	DEBUG (10, "sregister (%s);\n", strp);		
	if (evalqword (strp, &reg)) {
		error("'%s' not register/constant symbol", strp);
		return(-1);
	}
	/*
	 *  Verify that the register value is less than MAXREG
	 */
	if (reg < 0 || reg > MAXREG) {
		error ("bad register number (%d)", reg);
	}

	*wordp = reg;
	return (0);
}

/*
 *	D R E G I S T E R ( )
 *
 *	Decodes a destination register specification and fills in
 *	the given address with the result.  Returns -1 on error,
 *	and 0 upon success.
 */
dregister (strp, wordp)
register char	*strp;
short	*wordp;
{
	short	reg;

	DEBUG (10, "sregister (%s);\n", strp);		
	if (evalqword (strp, &reg)) {
		error("'%s' not register/constant symbol", strp);
		return(-1);
	}
	/*
	 *  Verify that the register value is less than MAXREG
	 */
	if (reg < 0 || reg > MAXREG) {
		error ("bad register number (%d)", reg);
	}

	*wordp = reg;
	return (0);
}

#define bct 8
#define bcf 16
#define reg 32

struct condcodes {
	char	*suffix;
	short	code;
} condcodes[] = {
	"any",		7 | bct,
	"az",		7 | bcf,
	"ct",		0 | bct,
	"cf",		0 | bcf,
	"eq",		4 | bct,
	"ft",		0,
	"ge",		5 | bct,
	"gt",		2 | bct,
	"ib",		0 | reg,
	"ih",		0 | reg,
	"iw",		0 | reg,
	"id",		0 | reg,
	"l",		1,
	"le",		6 | bct,
	"lt",		3 | bct,
	"n",		3 | bct,
	"ne",		4 | bcf,
	"nn",		3 | bcf,
	"nov",		1 | bcf,
	"np",		2 | bcf,
	"ns",		1 | bcf,
	"nz",		4 | bcf,
	"ov",		1 | bct,
	"p",		2 | bct,
	"s",		1 | bct,
	"u",		0,
	"z",		4 | bct,
	"\177",		0
};

condition (prefix, strp)
char	*prefix;
char	*strp;
{
	register char *cp;
	register struct condcodes *condp;
	int k;

	cp = strp;
	cp += strlen (prefix);

	for (condp = condcodes; condp->suffix[0] < *cp; condp++)
		;
	while ((k = strcmp(condp->suffix, cp)) < 0)
		condp++;
	if (k == SAME) {
		return (condp->code);
	}

	error ("bad condition suffix '%s'", cp);
	return (-1);
}

struct tcondcodes {
	char	*suffix;
	short	code;
} tcondcodes[] = {
	"",		7,
	"eq",		2,
	"ge",		3,
	"gt",		1,
	"le",		6,
	"lt",		4,
	"ne",		5,
	"never",	0,
	"\177",		0
};

tstcondition (prefix, strp)
char	*prefix;
char	*strp;
{
	register char *cp;
	register struct tcondcodes *condp;
	int k;

	cp = strp;
	cp += strlen (prefix);

	for (condp = tcondcodes; condp->suffix[0] < *cp; condp++)
		;
	while ((k = strcmp(condp->suffix, cp)) < 0)
		condp++;
	if (k == SAME) {
		return (condp->code);
	}

	error ("bad test condition suffix '%s'", cp);
	return (-1);
}

aligndecode (str)
register char	*str;
{
	int32	num;

	if (getnum(str, &num) < NULL) {
		error ("Unknown alignment code (%s)", str);
		return (-1);
	}
	else return ((int)num);
}

char *index(strp, val)
register char *strp;
register char val;
/*  return pointer to leftmost occurance of val in strp
    return 0 if no occurance found
    \0 terminates strp */
{
	while(*strp && *strp != val) strp++;
	if (*strp == val)
		return(strp);
	else
		return(0);
}

char *rindex(strp,val)
register char *strp;
register char val;
/*  return pointer to rightmost occurance of val in strp
    if no occurance, return 0
    \0 terminates string
*/
{
	register char *ptr;

	ptr = 0;
	while(*strp)
	{
		if (*strp == val) ptr = strp;
		strp++;
	}
	return(ptr);
}
