


     STDIPC(3C)                UNIX System V                STDIPC(3C)



     NAME
          ftok - standard interprocess communication package

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>

          key_t ftok(path, id)
          char *path;
          char id;

     DESCRIPTION
          All interprocess communication facilities require the user
          to supply a key to be used by the msgget(2), semget(2), and
          shmget(2) system calls to obtain interprocess communication
          identifiers.  One suggested method for forming a key is to
          use the ftok subroutine described below.  Another way to
          compose keys is to include the project ID in the most
          significant byte and to use the remaining portion as a
          sequence number.  There are many other ways to form keys,
          but it is necessary for each system to define standards for
          forming them.  If some standard is not adhered to, it will
          be possible for unrelated processes to unintentionally
          interfere with each other's operation.  Therefore, it is
          strongly suggested that the most significant byte of a key
          in some sense refer to a project so that keys do not
          conflict across a given system.

          Ftok returns a key based on path and id that is usable in
          subsequent msgget, semget, and shmget system calls.  Path
          must be the path name of an existing file that is accessible
          to the process.  Id is a character which uniquely identifies
          a project.  Note that ftok will return the same key for
          linked files when called with the same id and that it will
          return different keys when called with the same file name
          but different ids.

     SEE ALSO
          intro(2), msgget(2), semget(2), shmget(2).

     DIAGNOSTICS
          Ftok returns (key_t) -1 if path does not exist or if it is
          not accessible to the process.

     WARNING
          If the file whose path is passed to ftok is removed when
          keys still refer to the file, future calls to ftok with the
          same path and id will return an error.  If the same file is
          recreated, then ftok is likely to return a different key
          than it did the original time it was called.





     Page 1                                         (printed 11/19/90)



