


     SHMCTL(2)                 UNIX System V                 SHMCTL(2)



     NAME
          shmctl - shared memory control operations

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>
          #include <sys/shm.h>

          int shmctl (shmid, cmd, buf)
          int shmid, cmd;
          struct shmid_ds *buf;

     DESCRIPTION
          Shmctl provides a variety of shared memory control
          operations as specified by cmd.  The following cmds are
          available:

               IPC_STAT   Place the current value of each member of
                          the data structure associated with shmid
                          into the structure pointed to by buf.  The
                          contents of this structure are defined in
                          [EINVAL] (refer to intro(2)).  {READ}

               IPC_SET    Set the value of the following members of
                          the data structure associated with shmid to
                          the corresponding value found in the
                          structure pointed to by buf:
                          shm_perm.uid
                          shm_perm.gid
                          shm_perm.mode /* only low 9 bits */

                          This cmd can only be executed by a process
                          that has an effective user ID equal to
                          either that of super user or to the value of
                          shm_perm.uid in the data structure
                          associated with shmid.

               IPC_RMID   Remove the shared memory identifier
                          specified by shmid from the system and
                          destroy the shared memory segment and data
                          structure associated with it.  This cmd can
                          only be executed by a process that has an
                          effective user ID equal to either that of
                          super user or to the value of shm_perm.uid
                          in the data structure associated with shmid.

               SHM_LOCK   Lock the shared memory segment specified by
                          shmid in memory.  This cmd can only be
                          executed by a process that has an effective
                          usr ID equal to super user.

               SHM_UNLOCK Unlock the shared memory segment specified



     Page 1                                         (printed 11/18/90)






     SHMCTL(2)                 UNIX System V                 SHMCTL(2)



                          by shmid.  This cmd can only be executed by
                          a process that has an effective usr ID equal
                          to super user.

               Shmctl will fail if one or more of the following are
               true:

                    Shmid is not a valid shared memory identifier.
                    [EINVAL]

                    Cmd is not a valid command.  [EINVAL]

                    Cmd is equal to IPC_STAT and {READ} operation
                    permission is denied to the calling process (see
                    intro(2)).  [EACCES]

                    Cmd is equal to IPC_RMID or IPC_SET and the
                    effective user ID of the calling process is not
                    equal to that of super user and it is not equal to
                    the value of shm_perm.uid in the data structure
                    associated with shmid.  [EPERM]

                    Cmd is equal to SHM_LOCK or SHM_UNLOCK and the
                    effective user ID of the calling process is not
                    equal to that of super user.  [EPERM]

                    Cmd is equal to SHM_UNLOCK and the shared-memory
                    segment specified by shmid is not locked in
                    memory.  [EINVAL] Buf points to an illegal
                    address.  [EFAULT]

     RETURN VALUE
          Upon successful completion, a value of 0 is returned.
          Otherwise, a value of -1 is returned and errno is set to
          indicate the error.

     SEE ALSO
          shmget(2), shmop(2).

















     Page 2                                         (printed 11/18/90)



