


     SEMOP(2)                  UNIX System V                  SEMOP(2)



     NAME
          semop - semaphore operations

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>
          #include <sys/sem.h>

          int semop (semid, sops, nsops)
          int semid;
          struct sembuf **sops;
          int nsops;

     DESCRIPTION
          Semop is used to automatically perform an array of semaphore
          operations on the set of semaphores associated with the
          semaphore identifier specified by semid.  Sops is a pointer
          to the array of semaphore-operation structures.  Nsops is
          the number of such structures in the array.  The contents of
          each structure includes the following members:

               short   sem_num;    /* semaphore number */
               short   sem_op;     /* semaphore operation */
               short   sem_flg;    /* operation flags */

          Each semaphore operation specified by sem__p is performed on
          the corresponding semaphore specified by semid and sem__um.

          Sem__p specifies one of three semaphore operations as
          follows:

                  If sem__p is a negative integer, one of the
                  following will occur: {ALTER}

                       If semval (see intro(2)) is greater than or
                       equal to the absolute value of sem__p, the
                       absolute value of sem__p is subtracted from
                       semval.  Also, if (sem__lg & SEM_UNDO) is
                       ``true'', the absolute value of sem__p is added
                       to the calling process's semadj value (see
                       exit(2)) for the specified semaphore.

                       If semval is less than the absolute value of
                       sem__p and (sem__lg & IPC_NOWAIT) is ``true'',
                       semop will return immediately.

                       If semval is less than the absolute value of
                       sem__p and (sem__lg & IPC_NOWAIT) is ``false'',
                       semop will increment the semncnt associated
                       with the specified semaphore and suspend
                       execution of the calling process until one of
                       the following conditions occur.



     Page 1                                         (printed 11/18/90)






     SEMOP(2)                  UNIX System V                  SEMOP(2)



                          Semval becomes greater than or equal to the
                          absolute value of sem__p.  When this occurs,
                          the value of semncnt associated with the
                          specified semaphore is decremented, the
                          absolute value of sem__p is subtracted from
                          semval and, if (sem__lg & SEM_UNDO) is
                          ``true'', the absolute value of sem__p is
                          added to the calling process's semadj value
                          for the specified semaphore.

                          The semid for which the calling process is
                          awaiting action is removed from the system
                          (see semctl(2)).  When this occurs, errno is
                          set equal to EIDRM, and a value of -1 is
                          returned.








































     Page 2                                         (printed 11/18/90)






     SEMOP(2)                  UNIX System V                  SEMOP(2)



                          The calling process receives a signal that
                          is to be caught.  When this occurs, the
                          value of semncnt associated with the
                          specified semaphore is decremented, and the
                          calling process resumes execution in the
                          manner prescribed in signal(2).

                  If sem__p is a positive integer, the value of sem__p
                  is added to semval and, if (sem__lg & SEM_UNDO) is
                  ``true'', the value of sem__p is subtracted from the
                  calling process's semadj value for the specified
                  semaphore.  {ALTER}

                  If sem__p is zero, one of the following will occur:
                  {READ}

                       If semval is zero, semop will return
                       immediately.

                       If semval is not equal to zero and (sem__lg &
                       IPC_NOWAIT) is ``true'', semop will return
                       immediately.

                       If semval is not equal to zero and (sem__lg &
                       IPC_NOWAIT) is ``false'', semop will increment
                       the semzcnt associated with the specified
                       semaphore and suspend execution of the calling
                       process until one of the following occurs:

                          Semval becomes zero, at which time the value
                          of semzcnt associated with the specified
                          semaphore is decremented.

                          The semid for which the calling process is
                          awaiting action is removed from the system.
                          When this occurs, errno is set equal to
                          EIDRM, and a value of -1 is returned.

                          The calling process receives a signal that
                          is to be caught.  When this occurs, the
                          value of semzcnt associated with the
                          specified semaphore is decremented, and the
                          calling process resumes execution in the
                          manner prescribed in signal(2).

          Semop will fail if one or more of the following are true for
          any of the semaphore operations specified by sops:

          [EINVAL]       Semid is not a valid semaphore identifier.

          [EFBIG]        Sem__um is less than zero or greater than or
                         equal to the number of semaphores in the set



     Page 3                                         (printed 11/18/90)






     SEMOP(2)                  UNIX System V                  SEMOP(2)



                         associated with semid.

          [E2BIG]        Nsops is greater than the system-imposed
                         maximum.

          [EACCES]       Operation permission is denied to the calling
                         process (see intro(2)).

          [EAGAIN]       The operation would result in suspension of
                         the calling process but (sem__lg &
                         IPC_NOWAIT) is ``true''.

          [ENOSPC]       The limit on the number of individual
                         processes requesting a SEM_UNDO would be
                         exceeded.

          [EINVAL]       The number of individual semaphores for which
                         the calling process requests a SEM_UNDO would
                         exceed the limit.

          [ERANGE]       An operation would cause a semval to overflow
                         the system-imposed limit.

          [ERANGE]       An operation would cause a semadj value to
                         overflow the system-imposed limit.

          [EFAULT]       Sops points to an illegal address.

          Upon successful completion, the value of sempid for each
          semaphore specified in the array pointed to by sops is set
          equal to the process ID of the calling process.

     RETURN VALUE
          If semop returns due to the receipt of a signal, a value of
          -1 is returned to the calling process and errno is set to
          EINTR.  If it returns due to the removal of a semid from the
          system, a value of -1 is returned and errno is set to EIDRM.

          Upon successful completion, the value of semval at the time
          of the call for the last operation in the array pointed to
          by sops is returned.  Otherwise, a value of -1 is returned
          and errno is set to indicate the error.

     SEE ALSO
          exec(2), exit(2), fork(2), intro(2), semctl(2), semget(2).










     Page 4                                         (printed 11/18/90)



