


     SEMGET(2)                 UNIX System V                 SEMGET(2)



     NAME
          semget - get set of semaphores

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>
          #include <sys/sem.h>

          int semget (key, nsems, semflg)
          key_t key;
          int nsems, semflg;

     DESCRIPTION
          Semget returns the semaphore identifier associated with key.

          A semaphore identifier and associated data structure and set
          containing nsems semaphores (see intro(2)) are created for
          key if one of the following are true:

               Key is equal to IPC_PRIVATE.

               Key does not already have a semaphore identifier
               associated with it, and (semflg & IPC_CREAT) is
               ``true''.

          Upon creation, the data structure associated with the new
          semaphore identifier is initialized as follows:

               Sem_perm.cuid, sem_perm.uid, sem_perm.cgid, and
               sem_perm.gid are set equal to the effective user ID and
               effective group ID, respectively, of the calling
               process.

               The low-order 9 bits of sem_perm.mode are set equal to
               the low-order 9 bits of semflg.

               Sem_nsems is set equal to the value of nsems.

               Sem_otime is set equal to 0 and sem_ctime is set equal
               to the current time.

          Semget will fail if one or more of the following are true:

          [EINVAL]       Nsems is either less than or equal to zero or
                         greater than the system-imposed limit.

          [EACCES]       A semaphore identifier exists for key, but
                         operation permission (see intro(2)) as
                         specified by the low-order 9 bits of semflg
                         would not be granted.

          [EINVAL]       A semaphore identifier exists for key, but



     Page 1                                         (printed 11/18/90)






     SEMGET(2)                 UNIX System V                 SEMGET(2)



                         the number of semaphores in the set
                         associated with it is less than nsems and
                         nsems is not equal to zero.

          [ENOENT]       A semaphore identifier does not exist for key
                         and (semflg & IPC_CREAT) is ``false''.

          [ENOSPC]       A semaphore identifier is to be created but
                         the system-imposed limit on the maximum
                         number of allowed semaphore identifiers
                         system wide would be exceeded.

          [ENOSPC]       A semaphore identifier is to be created but
                         the system-imposed limit on the maximum
                         number of allowed semaphores system wide
                         would be exceeded.

          [EEXIST]       A semaphore identifier exists for key but (
                         (semflg & IPC_CREAT) and ( semflg & IPC_EXCL)
                         ) is ``true''.

     RETURN VALUE
          Upon successful completion, a non-negative integer, namely a
          semaphore identifier, is returned.  Otherwise, a value of -1
          is returned and errno is set to indicate the error.

     SEE ALSO
          intro(2), semctl(2), semop(2).



























     Page 2                                         (printed 11/18/90)



