


     SEMCTL(2)                 UNIX System V                 SEMCTL(2)



     NAME
          semctl - semaphore control operations

     SYNTAX
          #include <sys/types.h>
          #include <sys/ipc.h>
          #include <sys/sem.h>

          int semctl (semid, semnum, cmd, arg)
          int semid, cmd;
          int semnum;
          union semun {
               int val;
               struct semid_ds *buf;
               ushort *array;
          } arg;

     DESCRIPTION
          Semctl provides a variety of semaphore control operations as
          specified by cmd.

          The following cmds are executed with respect to the
          semaphore specified by semid and semnum for descriptions of
          the values returned, see Message Operations Permissions in
          intro(2).

               GETVAL     Return the value of semval.

               SETVAL     Set the value of semval to arg.val.  When
                          this cmd is successfully executed, the
                          semadj value corresponding to the specified
                          semaphore in all processes is cleared.

               GETPID     Return the value of sempid.

               GETNCNT    Return the value of semncnt.

               GETZCNT    Return the value of semzcnt.

          The following cmds return and set, respectively, every
          semval in the set of semaphores.

               GETALL     Place semvals into array pointed to by
                          arg.array.

               SETALL     Set semvals according to the array pointed
                          to by arg.array.  When this cmd is
                          successfully executed the semadj values
                          corresponding to each specified semaphore in
                          all processes are cleared.

          The following cmds are also available:



     Page 1                                         (printed 11/18/90)






     SEMCTL(2)                 UNIX System V                 SEMCTL(2)



               IPC_STAT   Place the current value of each member of
                          the data structure associated with semid
                          into the structure pointed to by arg.buf.
                          The contents of this structure are defined
                          in intro(2).

               IPC_SET    Set the value of the following members of
                          the data structure associated with semid to
                          the corresponding value found in the
                          structure pointed to by arg.buf:
                          sem_perm.uid
                          sem_perm.gid
                          sem_perm.mode /* only low 9 bits */

                          This cmd can only be executed by a process
                          that has an effective user ID equal to
                          either that of super-user or to the value of
                          sem_perm.uid in the data structure
                          associated with semid.

               IPC_RMID   Remove the semaphore identifier specified by
                          semid from the system and destroy the set of
                          semaphores and data structure associated
                          with it.  This cmd can only be executed by a
                          process that has an effective user ID equal
                          to either that of super-user or to the value
                          of sem_perm.uid in the data structure
                          associated with semid.

               Semctl will fail if one or more of the following are
               true:

               [EINVAL]       Semid is not a valid semaphore
                              identifier.

               [EINVAL]       Semnum is less than zero or greater than
                              sem_nsems.

               [EINVAL]       Cmd is not a valid command.

               [EACCES]       Operation permission is denied to the
                              calling process (see intro(2)).

               [ERANGE]       Cmd is SETVAL or SETALL and the value to
                              which semval is to be set is greater
                              than the system imposed maximum.

               [EPERM]        Cmd is equal to IPC_RMID or IPC_SET and
                              the effective user ID of the calling
                              process is not equal to that of super-
                              user and it is not equal to the value of
                              sem_perm.uid in the data structure



     Page 2                                         (printed 11/18/90)






     SEMCTL(2)                 UNIX System V                 SEMCTL(2)



                              associated with semid.

               [EFAULT]       Arg.buf points to an illegal address.

     RETURN VALUE
          Upon successful completion, the value returned depends on
          cmd as follows:
               GETVAL         The value of semval.
               GETPID         The value of sempid.
               GETNCNT        The value of semncnt.
               GETZCNT        The value of semzcnt.
               All others     A value of 0.
          Otherwise, a value of -1 is returned and errno is set to
          indicate the error.

     SEE ALSO
          intro(2), semget(2), semop(2).






































     Page 3                                         (printed 11/18/90)



