
     NAME
          intro - introduction to system calls and error identifiers

     SYNTAX
          #include <errno.h>

     DESCRIPTION
          This section describes all of the system calls.  Most of
          these calls have one or more error returns.  An error
          condition is indicated by an otherwise impossible returned
          value.  This is almost always -1; the individual
          descriptions specify the details.  An error identifier is
          also made available in the external variable errno.  Errno
          is not cleared on successful calls, so it should be tested
          only after an error has been indicated.

          Each system call description attempts to list all possible
          error identifiers.  The following is a complete list of
          error identifiers as defined in <errno.h>.

          1 EPERM "Not owner"
               Typically this error indicates an attempt to modify a
               file in some way forbidden except to its owner or
               superuser.  It is also returned for attempts by
               ordinary users to do things allowed only to the
               superuser.

          2 ENOENT "No such file or directory"
               This error occurs when a file name is specified and the
               file should exist but doesn't, or when one of the
               directories in a path name does not exist.

          3 ESRCH "No such process"
               No process can be found corresponding to that specified
               by pid in kill or ptrace.

          4 EINTR "Interrupted system call"
               An asynchronous signal (such as interrupt or quit),
               which the user has elected to catch, occurred during a
               system call.  If execution is resumed after processing
               the signal, it will appear as if the interrupted system
               call returned this error condition.

          5 EIO "I/O error"
               Some physical I/O error has occurred.  This error may
               in some cases occur on a call following the one to
               which it actually applies.

          6 ENXIO "No such device or address"
               I/O on a special file refers to a subdevice which does
               not exist, or beyond the limits of the device.  It may
               also occur when, for example, a tape drive is not on-
               line or no disk pack is loaded on a drive.

          7 E2BIG "Arg list too long"
               An argument list longer than 20480 bytes is presented
               to a member of the exec family.

          8 ENOEXEC "Exec format error"
               A request is made to execute a file which, although it
               has the appropriate permissions, does not start with a
               valid magic number (refer to a.out(4)).

          9 EBADF "Bad file number"
               Either a file descriptor refers to no open file, or a
               read (respectively, write) request is made to a file
               which is open only for writing (respectively, reading).

          10 ECHILD "No child processes"
               A wait was executed by a process that had no existing
               or unwaited-for child processes.

          11 EAGAIN "No more processes"
               A fork failed because the system's process table is
               full or the user is not allowed to create any more
               processes.

          12 ENOMEM "Not enough space"
               During an exec, brk, or sbrk, a program asks for more
               space than the system is able to supply.  This is not a
               temporary condition; the maximum space size is a system
               parameter.  The error may also occur if the arrangement
               of text, data, and stack segments requires too many
               segmentation registers, or if there is not enough swap
               space during a fork.

          13 EACCES "Permission denied"
               An attempt was made to access a file in a way forbidden
               by the protection system.

          14 EFAULT "Bad address"
               The system encountered a hardware fault in attempting
               to use an argument of a system call.

          15 ENOTBLK "Block device required"
               A non-block file was mentioned where a block device was
               required, e.g., in mount.

          16 EBUSY "Device or resource busy"
               An attempt was made to mount a device that was already
               mounted or an attempt was made to dismount a device on
               which there is an active file (open file, current
               directory, mounted-on file, active text segment).  It
               will also occur if an attempt is made to enable
               accounting when it is already enabled.  The device or
               resource is currently unavailable.

          17 EEXIST "File exists"
               An existing file was mentioned in an inappropriate
               context, e.g., link.

          18 EXDEV "Cross-device link"
               A link to a file on another device was attempted.

          19 ENODEV "No such device"
               An attempt was made to apply an inappropriate system
               call to a device; e.g., read a write-only device.

          20 ENOTDIR "Not a directory"
               A non-directory was specified where a directory is
               required, for example in a path prefix or as an
               argument to chdir(2).

          21 EISDIR "Is a directory"
               An attempt was made to write on a directory.

          22 EINVAL "Invalid argument"
               Some invalid argument (e.g., dismounting a non-mounted
               device; mentioning an undefined signal in signal, or
               kill; reading or writing a file for which lseek has
               generated a negative pointer).  Also set by the math
               functions described in the (3M) entries of this manual.

          23 ENFILE "File table overflow"
               The system file table is full, and temporarily no more
               opens can be accepted.

          24 EMFILE "Too many open files"
               No process may have more than OPEN_MAX file descriptors
               open at a time.  When a record lock is being created
               with fcntl, there are too many files with record locks
               on them.

          25 ENOTTY "Not a character device"
               An attempt was made to ioctl(2) a file that is not a
               special character device.

          26 ETXTBSY "Text file busy"
               An attempt was made to execute a pure-procedure program
               that is currently open for writing.  Also an attempt to
               open for writing a pure-procedure program that is being
               executed.

          27 EFBIG "File too large"
               The size of a file exceeded the maximum file size or
               ULIMIT (refer to ulimit(2)).

          28 ENOSPC "No space left on device"
               During a write to an ordinary file, there is no free
               space left on the device.  In fcntl, the setting or
               removing of record locks on a file cannot be
               accomplished because there are no more record entries
               left on the system.

          29 ESPIPE "Illegal seek"
               An lseek was issued to a pipe.

          30 EROFS "Read-only file system"
               An attempt to modify a file or directory was made on a
               device mounted read-only.

          31 EMLINK "Too many links"
               An attempt to make more than the maximum number of
               links (1000) to a file.

          32 EPIPE "Broken pipe"
               A write on a pipe for which there is no process to read
               the data.  This condition normally generates a signal;
               the error is returned if the signal is ignored.

          33 EDOM "Math argument"
               The argument of a function in the math package (3M) is
               out of the domain of the function.

          34 ERANGE "Result too large"
               The value of a function in the math package (3M) is not
               representable within machine precision.

          70 EDEADLOCK "Deadlock"
               A deadlock situation was detected and avoided.

          100 ENOMSG "No message of desired type"
               An attempt was made to receive a message of a type that
               does not exist on the specified message queue (refer to
               msgop(2)).

          101 EIDRM "Identifier Removed"
               This error is returned to processes that resume
               execution due to the removal of an identifier from the
               file system's name space (see msgctl(2), semctl(2), and
               shmctl(2)).

          102 ECHRNG "Channel number out of range"

          103 EL2NSYNC "Level 2 not synchronized"

          104 EL3HLT "Level 3 halted"

          105 EL3RST "Level 3 reset"

          106 ELNRNG "Link number out of range"

          107 EUNATCH "Protocol driver not attached"

          108 ENOCSI "No CSI structure available"

          109 EL2HLT "Level 2 halted"

     DEFINITIONS
        Process ID
          Each active process in the system is uniquely identified by
          a positive integer called a process ID.  On MPX this is the
          task number.  

        Parent Process ID
          A new process is created by a currently active process. The
          parent process ID (MPX task number) of a process is the
          process ID of the task creator.
          
        File Descriptor
          A file descriptor is a small integer used to do I/O on a
          file.  The value of a file descriptor is from 0 to
          _NFILE-1.  A process may have no more than OPEN_MAX file
          descriptors open simultaneously.  A file descriptor is
          returned by system calls such as open() or creat().  The
          file descriptor is used as an argument by calls such as
          read(), write(), and close().

        File Name
          Names consisting of 1 to PATH_MAX characters may be used to
          name an ordinary file or directory.

          These characters may be selected from the set of all
          character values excluding \0 (null) and the ASCII code for
          / (slash).

          Note that it is generally unwise to use *, ?, [, or ] as
          part of file names because of the special meaning attached
          to these characters by UNIX.

        Path Name and Path Prefix
          A path name is a null-terminated character string starting
          with an optional slash (/), followed by zero or more
          directory names separated by slashes, optionally followed by
          a file name.  The path name can also be an MPX file name of
          the form @volume(directory)file and it's variations.

          More precisely, a path name is a null-terminated character
          string constructed as follows:

               <path-name>::=<file-name>|<path-prefix><file-name>|/
               <path-prefix>::=<rtprefix>|/<rtprefix>
               <rtprefix>::=<dirname>/|<rtprefix><dirname>/

          where <file-name> is a string of 1 to PATH_MAX characters
          other than the ASCII slash and null, and <dirname> is a
          string of 1 to PATH_MAX characters (other than the ASCII
          slash and null) that names a directory.

          If a path name begins with a slash, the path search begins
          at the root directory.  Otherwise, the search begins from
          the current working directory.

          A slash by itself names the root directory.  On MPX this is
          @system(sytem) or /system/system.

          Unless specifically stated otherwise, the null path name is
          treated as if it named a non-existent file.

        Directory
          Directory entries are called links.  By convention, a
          directory contains at least two links, . and .., referred to
          as dot and dot-dot respectively.  Dot refers to the
          directory itself and dot-dot refers to its parent directory.

        Root Directory and Current Working Directory
          Each process has associated with it a concept of a root
          directory and a current working directory for the purpose of
          resolving path name searches.  The root directory of a
          process need not be the root directory of the root file
          system.

        File Access Permissions
          Read, write, and execute/search permissions on a file are
          granted to a process if one or more of the following are
          true:

               The effective user ID of the process is superuser and
               the process is reading writing, or searching the file.

               The effective user ID of the process is superuser and
               the process is executing the file, and the appropriate
               access bit of either ``owner'', ``group'', or ``other''
               portion of the file's mode is set to executable (0100,
               010, or 01).

               The effective user ID of the process matches the user
               ID of the owner of the file and the appropriate access
               bit of the ``owner'' portion (0700) of the file mode is
               set.

               The effective user ID of the process does not match the
               user ID of the owner of the file, and the effective
               group ID of the process matches the group of the file
               and the appropriate access bit of the ``group'' portion
               (070) of the file mode is set.

               The effective user ID of the process does not match the
               user ID of the owner of the file, and the effective
               group ID of the process does not match the group ID of



     Page 7                                         (printed 11/18/90)






     INTRO(2)                  UNIX System V                  INTRO(2)



               the file, and the appropriate access bit of the
               ``other'' portion (07) of the file mode is set.

          Otherwise, the corresponding permissions are denied.

        Message Queue Identifier
          A message queue identifier (msqid) is a unique positive
          integer created by a msgget(2) system call.  Each msqid has
          a message queue and a data structure associated with it.
          The data structure is referred to as msqid__s and contains
          the following members:

               struct ipc_perm      msg_perm;/* operation permission struct */
               struct msg     *msg_first;    /* ptr to first message on q */
               struct msg     *msg_last;     /* ptr to last message on q */
               ushort         msg_cbytes;    /* current # bytes on q */
               ushort         msg_qnum;      /* # of messages on q */
               ushort         msg_qbytes;    /* max # of bytes on q */
               ushort         msg_lspid;     /* pid of last msgsnd */
               ushort         msg_lrpid;     /* pid of last msgrcv */
               time_t         msg_stime;     /* last msgsnd time */
               time_t         msg_rtime;     /* last msgrcv time */
               time_t         msg_ctime;     /* last change time */

          Msg_perm is an ipc_perm structure that specifies the message
          operation permission.  This structure includes the following
          members:

               ushort      uid;    /* owner's user ID */
               ushort      gid;    /* owner's group ID */
               ushort      cuid;   /* creator's user ID */
               ushort      cgid;   /* creator's group ID */
               ushort      mode;   /* access modes */
               ushort      seq;    /* slot usage sequence number */
               key_t       key;    /* key */

          Msg *msg_first is a pointer to the first message on the
          queue; Msg *msg_last is a pointer to the last message on the
          queue.  Msg_qnum is the number of messages currently on the
          queue.  Msg_qbytes is the maximum number of bytes allowed on
          the queue.  Msg_lspid is the process ID of the last process
          that performed a msgsnd operation.  Msg_lrpid is the process
          ID of the last process that performed a msgrcv operation.
          Msg_stime is the time of the last msgsnd operation,
          msg_rtime is the time of the last msgrcv operation, and
          msg_ctime is the time of the last msgctl(2) operation that
          changed a member of the above structure.

        Message Operation Permissions
          In the msgop(2) and msgctl(2) system call descriptions, the
          permission required for an operation is given as "{token}",
          where "token" is the type of permission needed interpreted



     Page 8                                         (printed 11/18/90)






     INTRO(2)                  UNIX System V                  INTRO(2)



          as follows:

                 00400          Read by user
                 00200          Write by user
                 00060          Read, write by group
                 00006          Read, write by others

          Read and write permissions on a msqid are granted to a
          process if one or more of the following are true:

               The effective user ID of the process is superuser.

               The effective user ID of the process matches
               msg_perm.[c]uid in the data structure associated with
               msqid and the appropriate bit of the ``user'' portion
               (0600) of msg_perm.mode is set.

               The effective user ID of the process does not match
               msg_perm.[c]uid and the effective group ID of the
               process matches msg_perm.[c]gid and the appropriate bit
               of the ``group'' portion (060) of msg_perm.mode is set.

               The effective user ID of the process does not match
               msg_perm.[c]uid and the effective group ID of the
               process does not match msg_perm.[c]gid and the
               appropriate bit of the ``other'' portion (06) of
               msg_perm.mode is set.

          Otherwise, the corresponding permissions are denied.

        Semaphore Identifier
          A semaphore identifier (semid) is a unique positive integer
          created by a semget(2) system call.  Each semid has a set of
          semaphores and a data structure associated with it.  The
          data structure is referred to as semid__s and contains the
          following members:

               struct ipc_perm      sem_perm;/* operation permission struct */
               struct sem     *sem_base;     /* ptr to first semaphore in set */
               ushort         sem_nsems;     /* # of semaphores in set */
               time_t         sem_otime;     /* last semop time */
               time_t         sem_ctime;     /* last change time */

          Sem_perm is an ipc_perm structure that specifies the
          semaphore operation permission.  This structure includes the
          following members:

               ushort      uid;    /* owner's user ID */
               ushort      gid;    /* owner's group ID */
               ushort      cuid;   /* creator's user ID */
               ushort      cgid;   /* creator's group ID */
               ushort      mode;   /* access modes */



     Page 9                                         (printed 11/18/90)






     INTRO(2)                  UNIX System V                  INTRO(2)



               ushort      seq;    /* slot usage sequence number */
               key_t       key;    /* key */

          The value of sem_nsems is equal to the number of semaphores
          in the set.  Each semaphore in the set is referenced by a
          positive integer referred to as a sem__um.  Sem_num values
          run sequentially from 0 to the value of sem_nsems minus 1.
          Sem_otime is the time of the last semop(2) operation, and
          sem_ctime is the time of the last semctl(2) operation that
          changed a member of the above structure.

          A semaphore is a data structure that contains the following
          members:

               ushort      semval; /* semaphore value */
               short       sempid; /* pid of last operation  */
               ushort      semncnt;/* # awaiting semval > cval */
               ushort      semzcnt;/* # awaiting semval = 0 */

          Semval is a non-negative integer.  Sempid is equal to the
          process ID of the last process that performed a semaphore
          operation on this semaphore.  Semncnt is a count of the
          number of processes that are currently suspended awaiting
          this semaphore's semval to become greater than its current
          value.  Semzcnt is a count of the number of processes that
          are currently suspended awaiting this semaphore's semval to
          become zero.

        Semaphore Operation Permissions
          In the semop(2) and semctl(2) system call descriptions, the
          permission required for an operation is given as "{token}",
          where "token" is the type of permission needed interpreted
          as follows:

                 00400          Read by user
                 00200          Alter by user
                 00060          Read, alter by group
                 00006          Read, alter by others

          Read and alter permissions on a semid are granted to a
          process if one or more of the following are true:

               The effective user ID of the process is superuser.

               The effective user ID of the process matches
               sem_perm.[c]uid in the data structure associated with
               semid and the appropriate bit of the ``user'' portion
               (0600) of sem_perm.mode is set.

               The effective user ID of the process does not match
               sem_perm.[c]uid and the effective group ID of the
               process matches sem_perm.[c]gid and the appropriate bit



     Page 10                                        (printed 11/18/90)






     INTRO(2)                  UNIX System V                  INTRO(2)



               of the ``group'' portion (060) of sem_perm.mode is set.

               The effective user ID of the process does not match
               sem_perm.[c]uid and the effective group ID of the
               process does not match sem_perm.[c]gid and the
               appropriate bit of the ``other'' portion (06) of
               sem_perm.mode is set.

          Otherwise, the corresponding permissions are denied.

        Shared Memory Identifier
          A shared memory identifier (shmid) is a unique positive
          integer created by a shmget(2) system call.  Each shmid has
          a segment of memory (referred to as a shared memory segment)
          and a data structure associated with it.  The data structure
          is referred to as shmid__s and contains the following
          members:

               struct      ipc_perm shm_perm;     /* operation permission struct */
               struct      pte *shm_segbase;      /* ptes that describe segment */
               int         shm_segsz;             /* size of segment in bytes */
               ushort      shm_lpid;              /* pid of last shmop */
               ushort      shm_cpid;              /* pid of creator */
               ushort      shm_nattch;            /* current # attached */
               ushort      shm_cnattch;           /* in memory # attached */
               time_t      shm_atime;             /* last shmat time */
               time_t      shm_dtime;             /* last shmdt time */
               time_t      shm_ctime;             /* last change time */
               char        shm_regname[MAXREGNAME];/* name of region */
               int         shm_rattr;             /* attributes */
               int         shm_offset;            /* offset into memory extent */
               int         shm_flags;             /* flags */
               struct      mem_extent *shm_memext;/* pointer to extent */

          NOTE: The previous structure was changed to support memory
          classes.  To maintain compatibility, the following data
          structure is used to define what is returned by shmctl when
          status is requested via IPC_STAT.

               struct      ipc_perm shm_perm;     /* operation permission struct */
               struct      pte *shm_segbase;      /* ptes that describe segment */
               int         shm_segsz;             /* size of segment in bytes */
               ushort      shm_lpid;              /* pid of last shmop */
               ushort      shm_cpid;              /* pid of creator */
               ushort      shm_nattch;            /* current # attached */
               ushort      shm_cnattch;           /* in memory # attached */
               time_t      shm_atime;             /* last shmat time */
               time_t      shm_dtime;             /* last shmdt time */
               time_t      shm_ctime;             /* last change time */

          Shm_perm is an ipc_perm structure that specifies the shared
          memory operation permission.  This structure includes the



     Page 11                                        (printed 11/18/90)






     INTRO(2)                  UNIX System V                  INTRO(2)



          following members:

               ushort      uid;    /* owner's user ID */
               ushort      gid;    /* owner's group ID */
               ushort      cuid;   /* creator's user ID */
               ushort      cgid;   /* creator's group ID */
               ushort      mode;   /* access modes */
               ushort      seq;    /* slot usage sequence number */
               key_t       key;    /* key */

          Shm_segsz specifies the size of the shared memory segment.
          Shm_cpid is the process ID of the process that created the
          shared memory identifier.  Shm_lpid is the process ID of the
          last process that performed a shmop(2) operation.
          Shm_nattch is the number of processes that currently have
          this segment attached.  Shm_atime is the time of the last
          shmat operation, shm_dtime is the time of the last shmdt
          operation, and shm_ctime is the time of the last shmctl(2)
          operation that changed one of the members of the above
          structure.

        Shared Memory Operation Permissions
          In the shmop(2) and shmctl(2) system call descriptions, the
          permission required for an operation is given as "{token}",
          where "token" is the type of permission needed interpreted
          as follows:

                 00400          Read by user
                 00200          Write by user
                 00060          Read, write by group
                 00006          Read, write by others

          Read and write permissions on a shmid are granted to a
          process if one or more of the following are true:

               The effective user ID of the process is superuser.

               The effective user ID of the process matches
               shm_perm.[c]uid in the data structure associated with
               shmid and the appropriate bit of the ``user'' portion
               (0600) of shm_perm.mode is set.

               The effective user ID of the process does not match
               shm_perm.[c]uid and the effective group ID of the
               process matches shm_perm.[c]gid and the appropriate bit
               of the ``group'' portion (060) of shm_perm.mode is set.

               The effective user ID of the process does not match
               shm_perm.[c]uid and the effective group ID of the
               process does not match shm_perm.[c]gid and the
               appropriate bit of the ``other'' portion (06) of
               shm_perm.mode is set.



     Page 12                                        (printed 11/18/90)






     INTRO(2)                  UNIX System V                  INTRO(2)



          Otherwise, the corresponding permissions are denied.

     SEE ALSO
          close(2), ioctl(2), open(2), pipe(2), read(2), write(2),
          intro(3).


















































     Page 13                                        (printed 11/18/90)



