/* local.c */
/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 * 	(c) Copyright 1990 J B Systems
 *	This file contains non-based support modifications
 *	for operation under MPX.  Derived from Encores' base
 *	mode C compiler.
 */

#ifndef lint
static char *rcsid = "@(#) (Gould) $Header: local.c,v 5.5 89/05/12 12:43:30 pcc Rel-3_0 $";
#endif

/*
    C compiler for Gould processors, base register instruction set.

    Ported from the 4.1c Berkeley Standard
	Distribution source for a VAX portable C compiler.

*/
#include "mfile1.h"

/*	this file contains code which is dependent on the target machine */

NODE       *cast(p, t) register NODE   *p;
TWORD       t;
{
 /* cast node p to type t */

    p = buildtree(CAST, block(NAME, NIL, NIL, t, 0, (int) t), p);
    p -> in.left -> in.op = FREE;
    p -> in.op = FREE;
    return(p -> in.right);
}

NODE       *clocal(p) NODE *p;
{

 /* this is called to do local transformations on an expression tree
    preparitory to its being written out in intermediate code. */

 /* the major essential job is rewriting the automatic variables 
    and arguments in terms of REG and [LP]NAME nodes */
 /* conversion ops which are not necessary are also clobbered here */
 /* in addition, any special features (such as rewriting exclusive or)
    are easily handled here as well */

    register struct symtab *q;
    register NODE  *r;
    register    o;
    register    m, ml;
    register	NODE * newtree;		/* points to tree to be returned */
    extern int eprint();

#ifndef BUG2
    if(edebug) {
	printf("clocal(%x):\n", p);
	fwalk(p, eprint, 0);
    }
#endif

    switch (o = p -> in.op) {

	case NAME: 
	    if (p -> tn.rval < 0) {	/* already processed; ignore... */
		newtree = p;
#ifndef BUG2
	    if(tdebug) {
		printf("clocal(%x): case NAME, already processed\n", p);
		prstab(p->tn.rval);
	    }
#endif
		goto out;
	    }
#ifndef BUG2
	    if(tdebug) {
		printf("clocal(%x): case NAME\n", p);
		prstab(p->tn.rval);
	    }
#endif
	    q = &stab[p -> tn.rval];
	    switch (q -> sclass) {

		case AUTO:
		case PARAM:
#ifndef BUG2
			if(tdebug) {
			    printf("clocal(AUTO/PARAM)\n");
			    prstab(q - stab);
			}
#endif
			if( (q->optflags & (IsLNAME|IsPNAME)) != 0 )
			{
#ifndef BUG2
			if(edebug) {
			    printf("clocal(AUTO/PARAM) @ LNAME/PNAME\n");
			    prstab(q - stab);
			}
#endif
			/* atomic id - turn this onto an LNAME or a
			 * PNAME
			 */
			p->in.op = ((q->optflags &IsLNAME) != 0)
				 ? LNAME
				 : PNAME;
			r = offcon( q->offset, INCREF(q->stype),
					q->dimoff,q->sizoff);
			p->tn.lval = r->tn.lval;
			r->in.op = FREE;		/* YECH */
		} else {
			int	paramsz;
			r = bcon(0);
#ifndef BUG2
			if(tdebug) {
			    printf("clocal(AUTO/PARAM)op into OREG\n");
			    prstab(q - stab);
			}
#endif
#ifdef ONEPASS
			p -> in.op = OREG;
#else /* TWOPASS */
			p -> in.op = REG;
#endif /* ONEPASS */
			p -> tn.lval = 0;
			if(q->sclass == PARAM)
				p -> tn.rval = ARGREG;
			else
				p -> tn.rval = STKREG;
#ifdef TWOPASS
			p -> tn.lval = p -> tn.rval;  /* (MEY) 27-Jan-87  Make id cookie for PCO */
#endif /* TWOPASS */
#ifdef ONEPASS
			    p = buildtree(UNARY AND, p, 0);
#else /* TWOPASS */
			    p -> in.type = INCREF(p -> in.type);
#endif /* ONEPASS */
			p = buildtree(PLUS, p, r);
			r -> tn.lval = q -> offset / SZCHAR;
			newtree = buildtree(UNARY MUL, p, 0);
			paramsz = tsize(q->stype, q->dimoff, q->sizoff);
#ifndef BUG2
			if(edebug) {
			    printf("clocal(): paramsz=%d\n", paramsz);
			    prstab(q - stab);
			}
#endif
			if(paramsz > MAXARGSIZE && q->sclass == PARAM) {
			    /* one more level of indirection */
			    p->in.type = INCREF(p->in.type);
			    p->in.left->in.type = p->in.type;
			    newtree->in.type = INCREF(newtree->in.type);
			    newtree = 
				buildtree(UNARY MUL, newtree, 0);
			}
			goto out;
		}
		break;

		case ULABEL: 
		case LABEL: 
		case STATIC: 
		    if (q -> slevel == 0)
			break;
		    p -> tn.lval = 0;
		    p -> tn.rval = -q -> offset;
		    break;

		case REGISTER: 
			{
#ifndef BUG2
				if(tdebug) {
				    printf("clocal(REGISTER)op into REG\n");
				    prstab(q - stab);
				}
#endif
				/* provide id cookie for optimizer */
				p->tn.lval = IsRegVar(q->offset) ? q->uniqid
								: q->offset;
				p->in.op = REG;
				p->tn.rval = q->offset;
			}
			break;

	    }
	    break;

	case OREG: 
#ifdef TWOPASS
	    cerror("OREG not expected in pass 1");
	    break;
#endif /* TWOPASS */
#ifdef ONEPASS
#ifdef MPX
	    if (p -> tn.lval < 0 || p -> tn.lval > 0x80000) {
#else
	    if (p -> tn.lval < 0 || p -> tn.lval > 60000) {
#endif
		int     off;
#ifndef BUG2
		if(tdebug) {
		    printf("clocal(OREG)op into UNARY MUL\n");
		    prstab(q - stab);
		}
#endif

		off = p -> tn.lval;
		p -> tn.lval = 0;
		r = bcon (0);
		p = buildtree (UNARY AND, p, 0);
		p = buildtree (PLUS, p, r);
		r -> tn.lval = off;
		newtree = buildtree (UNARY MUL, p, 0);
		goto out;
	    }
	    break;
#endif /* ONEPASS */

	case PCONV: 
    /* do pointer conversions for char and longs */
	    ml = p -> in.left -> in.type;
	    if ((ml == CHAR || ml == UCHAR || ml == SHORT || ml == USHORT) && p -> in.left -> in.op != ICON) {
		uerror("I strongly object to casting char/shorts into pointers");
		break;
	    }
    /* pointers all have the same representation; the type is inherited */

    inherit: 
	    p -> in.left -> in.type = p -> in.type;
	    p -> in.left -> fn.cdim = p -> fn.cdim;
	    p -> in.left -> fn.csiz = p -> fn.csiz;
	    p -> in.op = FREE;
	    newtree = p -> in.left;
	    goto out;

	case SCONV: 
	    m = (p -> in.type == FLOAT || p -> in.type == DOUBLE);
	    ml = (p ->in.left->in.type == FLOAT || p->in.left->in.type == DOUBLE);
	    if (p -> in.type == FLOAT && p -> in.left -> in.op == FCON) {
		p -> in.op = FREE;
		p = p -> in.left;
		p -> in.type = FLOAT;
		p -> fpn.dval = (float)(p -> fpn.dval);
		newtree = p;
		goto out;
	    }
	    /* new block of code to address "SCONV FCON" to double in
	       clocal() before the match fails because used in init */
	    if (p -> in.type == DOUBLE && p -> in.left -> in.op == FCON) {
		p -> in.op = FREE;
		p = p -> in.left;
		p -> in.type = DOUBLE;
		p -> fpn.dval = (double)(p -> fpn.dval);
		newtree = p;
		goto out;
	    }
	    if (m || ml)
		break;

    /* now, look for conversions downwards */

	    m = p -> in.type;
	    ml = p -> in.left -> in.type;
#ifdef MPX
	    if (p->in.left->in.op == NAME &&
		m == INT && ml == UNSIGNED)
		goto inherit;
#endif
	    /* simulate the conversion here */
	    if (p -> in.left -> in.op == ICON 
		) {
		int       val;
		val = p -> in.left -> tn.lval;
		switch (m) {
		    case CHAR: 
			if( !onlyuchar){
			    val &= 0xff;
			    if( val&0x80 ){
				val |= ~0xff;
			    }
			    p -> in.left -> tn.lval = val;
			    break;
			}
		    case UCHAR: 
			p -> in.left -> tn.lval = val & 0XFF;
			break;
		    case USHORT: 
			p -> in.left -> tn.lval = val & 0XFFFFL;
			break;
		    case SHORT: 
			val &= 0xffff;
			if( val&0x8000 ){
			    val |= ~0xffff;
			}
			p -> in.left -> tn.lval = val;
			break;
		    case UNSIGNED: 
		    case INT: 
			break;
		    case LONG:
			if(ml != UNSIGNED) break;
#ifndef DEC06_TEST
			if((unsigned)p->in.left->tn.lval & 
			  (unsigned)(1<<(SZINT-1)) ) {
				newtree = p;
				goto out;
			}
#endif
			break;
		}
		p -> in.left -> in.type = m;
	    }
	    else {
	/* meaningful ones are conversion of int to char, int to short,
	   and short to char, and unsigned version of them */
		if (m == CHAR || m == UCHAR) {
		    if (ml != CHAR && ml != UCHAR)
			break;
		}
		else
		    if (m == SHORT || m == USHORT) {
			if (ml != CHAR && ml != UCHAR && ml != SHORT && ml != USHORT)
			    break;
		    }
		    else
			if (m == LONG || m == INT) {
			    break;
			}
	    }

    /* clobber conversion */
	    if (tlen(p) == tlen(p -> in.left))
		goto inherit;
	    p -> in.op = FREE;
	    newtree = p -> in.left;	/* conversion gets clobbered */
	    goto out;

	case PVCONV: 
	case PMCONV: 
	    if (p -> in.right -> in.op != ICON)
		cerror("bad conversion", 0);
	    p -> in.op = FREE;
	    newtree = buildtree(o == PMCONV ? MUL : DIV, p -> in.left, p -> in.right);
	    goto out;


	case FLD: 
    /* make sure that the second pass does not make the descendant
       of a FLD operator into a doubly indexed OREG */

	    if (p -> in.left -> in.op == UNARY MUL
		    && (r = p -> in.left -> in.left) -> in.op == PCONV)
		if (r -> in.left -> in.op == PLUS || r -> in.left -> in.op == MINUS)
		    if (ISPTR(r -> in.type)) {
			if (ISUNSIGNED(p -> in.left -> in.type))
			    p -> in.left -> in.type = UCHAR;
			else
			    p -> in.left -> in.type = CHAR;
		    }
	    break;
    }

    newtree = p;

  out:
#ifndef BUG2
	if(edebug) {
		printf("clocal(%x) returning newtree %x\n", p, newtree);
		fwalk(newtree, eprint, 0);
	}
#endif

        return(newtree);
}

andable(p) NODE    *p;
{
    return(p -> in.op == NAME);		/* make all oregs use movea instr */
}

cendarg()
{	/* at the end of the arguments of a ftn, set the automatic offset */
    autooff = AUTOINIT;
}

cisreg(t) TWORD     t;
{	/* is an automatic variable of type t OK for a register variable */

/* #ifdef TRUST_REG_CHAR_AND_REG_SHORT */
#ifndef MPX_OCT02
    if (t == INT || t == UNSIGNED || t == LONG || t == ULONG
 /* tbl */
	    || t == CHAR || t == UCHAR || t == SHORT    /* tbl */
	    || t == FLOAT				/* MPX JCB */
	    || t == USHORT || ISPTR(t))
	return(1);					/* tbl */
#else
    if (t == INT || t == UNSIGNED || t == LONG || t == ULONG
	    || t == FLOAT				/* DJK */
 /* wnj */
	    || ISPTR(t))
	return(1);					/* wnj */
#endif
    return(0);
}

CanBeLNAME(t)
	TWORD t;
{		/* is an automatic variable of type t OK for LNAME or PNAME */

	return( ISPTR(t) || t == CHAR || t == SHORT || t == INT ||
            t == ENUMTY ||
	    t == LONG || t == FLOAT || t == DOUBLE || ISUNSIGNED(t) );
}

NODE       *offcon(off, t, d, s) OFFSZ  off;
TWORD       t;
{

 /* return a node, for structure references, which is suitable for
    being added to a pointer of type t, in order to be
    off bits offset into a structure */

    register NODE  *p;
 /* t, d, and s are the type, dimension offset, and sizeoffset */
 /* in general they  are necessary for offcon, but not on H'well */

#ifndef BUG2
    if(tdebug) {
	printf("offcon(off = 0x%x):\n", off);
    }
#endif

    p = bcon(0);
    p -> tn.lval = off / SZCHAR;
    return(p);

}

#ifndef MPX  /* OCT03 */
/*
** Generate initialization code for assigning a constant c to a field
** of width sz.  We assume that the proper alignment has been obtained.
** inoff is updated to have the proper final value.
**
** The reason for such backflips is that this routine
** is used to initialize bitfields, as well as 'normal'
** types. We collect the data
** in 'word', and when we are at the end of the
** initialization, or inoff is on a byte boundary, we
** dump the data. For normal initialization, we dump
** the data at each call, since inoff will be at least
** byte aligned. In that case, we only go through the
** loop one time. For fields, we may collect data over
** several calls, and then dump the data.
*/
static int inwd;  /* curr offset in word */
static int word;  /* word being built */

void
incode(p, sz)
NODE	*p;
int	sz;
{
    int		onecon, tw1, tw2;
    int		oinoff = inoff;
    long	tlw;

#ifndef BUG2
    if( idebug ) {
	printf("incode(%x, %d):\n", p, sz);
    }
#endif

    onecon = 1L;
    tw1 = p->tn.lval;

    if( (sz/SZCHAR) >= sizeof(word) || inwd == 0)
	word = tw1;
    else
	{
	/*
	 ** This is a direct conversion from the line:
	 ** word = (word << sz) | (p->tn.lval & ((1L<<sz)-1));
	 */
	word = (word << sz) | (p->tn.lval & ((1L<<sz)-1));
    }
    inwd += sz;
    inoff += sz;
    if((inoff % SZCHAR) == 0)        /* on at least a byte boundary */
	while(inwd >= SZCHAR)           /* and at least a byte to emit */
	    {
	    /* dump the word */
	    if (inwd >= SZINT && (oinoff % SZINT) == 0)
		{
		inwd -= SZINT;
		printf("	dataw	x'%x'\n", word >> inwd);
		word &= ((1L << inwd) - 1L);
		}
	    /* dump a halfword */
	    else if (inwd >= SZSHORT && (oinoff % SZSHORT) == 0)
		{
		inwd -= SZSHORT;
		printf("	datah	x'%x'\n", (word >> inwd) & 0xffff);
		word &= ((1L << inwd) - 1L);
		}
	    else
		{
		inwd -= SZCHAR;         /* remove a byte  */
		printf("	datab	x'%x'\n", (word >> inwd) & 0xff);
		word &= ((1L << inwd) - 1L);
		}
	}
}
#else /* MPX OCT03 */

static      inwd /* current bit offsed in word */ ;
static      word /* word being built from fields */ ;

incode(p, sz) register NODE    *p;
{

 /* generate initialization code for assigning a constant c 
    to a field of width sz */
 /* we assume that the proper alignment has been obtained */
 /* inoff is updated to have the proper final value */
 /* we also assume sz  < SZINT */

    if ((sz + inwd) > SZINT)
	cerror("incode: field > int");
#ifdef VAX
    word |= ((unsigned)(p -> tn.lval << (32 - sz))) >> (32 - sz - inwd);
#else
    word = (unsigned)word | ((unsigned)(p -> tn.lval << (32 - sz))) >> (inwd);
#endif
    inwd += sz;
    inoff += sz;
    if (inoff % SZINT == 0) {
#ifdef UAS
	printf("	dataw	x'%x'\n", word);
#else
	printf("	.word	0x%x\n", word);
#endif
	word = inwd = 0;
    }
}
#endif /* MPX OCT03 */

fincode(d, sz) double   d;
{
 /* output code to initialize space of size sz to the value d */
 /* the proper alignment has been obtained */
 /* inoff is updated to have the proper final value */
 /* on the target machine, write it out in octal! */


#ifdef UAS
    if (sz == SZDOUBLE) {
#if defined (MPXJUNK) && defined(i386)
	union {
	    double	dd;
	    int	i[2];
	} fpn;
	fpn.dd = d;
/*	printf("	datad	%sx'%08x%08x'\n", "", fpn.i[0], fpn.i[1]); */
	printf("	datad	%e\n", d);
#else
	printf("	datad	%sx'%08x%08x'\n", "", d);
#endif
    }
    else {
	printf("	dataw	%sx'%x'\n", "", d);
    }
#else
    if (sz == SZDOUBLE) {
	printf("	.word	%s0x%x,0x%x\n", "", d);
    }
    else {
	printf("	.word	%s0x%x\n", "", d);
    }
#endif
    inoff += sz;
}

cinit(p, sz) NODE  *p;
{
 /* arrange for the initialization of p into a space of size sz */
 /* the proper alignment has been opbtained */
 /* inoff is updated to have the proper final value */

        /*
         * Sun fix - see $w/sunfixes/t1.c
         * as a favor (?) to people who want to write
         *     int i = 9600/134.5;
         * we will, under the proper circumstances, do
         * a coersion here.
         */
        NODE *l;

        switch (p->in.type) {
        case INT:
        case UNSIGNED:
                l = p->in.left;
                if (l->in.op != SCONV || l->in.left->tn.op != FCON) break;
                l->in.op = FREE;
                l = l->in.left;
                l->tn.lval = (long)(l->fpn.dval);
                l->tn.rval = NONAME;
                l->tn.op = ICON;
                l->tn.type = INT;
                p->in.left = l;
                break;
        }

    ecode(p);
    inoff += sz;
}

#ifndef MPX /* OCT03 */
/*
 ** define "n" bits of zeros in a field.
 */
void
vfdzero (n)
int n;
{
    NODE	zeroinit;

    if (n <= 0)
	return;

    zeroinit.in.op = ICON;
    zeroinit.tn.lval = 0;
/* printf(" vfdzero calling incode(%x, %d):\n", &zeroinit, n); */
    incode (&zeroinit, n);	/* let initializer do it */
}
#else /* MPX OCT03 */
vfdzero(n)
{		/* define n bits of zeros in a vfd */

    if (n <= 0)
	return;

    inwd += n;
    inoff += n;
    if (inoff % ALINT == 0) {
#ifdef UAS
	printf("	dataw	x'%x'\n", word);
#else
	printf("	.word	0x%x\n", word);
#endif
	word = inwd = 0;
    }
}
#endif /* MPX OCT03 */

extern	int      lastloc;	/* MPX */
char       *exname(p, sf) char *p;
{
 /* make a name look like an external name in the local machine */

    static char     text[BUFSIZ + 1];
    register char *tp = text;

 /* 
  * For PCO, STAB entries must also be rewritten since they must match
  * the way they are referenced.
  */

#ifdef UAS
    *tp++ = '_';
    while (*p) {
	*tp++ = *p++;
    }
#else /* UAS */
    if( ! (sf & SABSLABEL) )
	*tp++ = '_';
    while (*p) {
	*tp++ = *p++;
    }
#endif

    *tp = '\0';
    return(text);
}

ctype(type)
{	/* map types which are not defined on the local machine */
    extern      onlyuchar;
    switch (BTYPE(type)) {

	case CHAR: 
	    if (onlyuchar) {
		MODTYPE(type, UCHAR);
	    }
	    break;

/*
*  DJK: would let LONGS alone if gram treats
*	long long var as a real long. otherwise int.
*/
#ifndef MAR25_MPX
	case LONG: 
	    MODTYPE(type, INT);
	    break;

	case ULONG: 
	    MODTYPE(type, UNSIGNED);
#endif /* MPXTEMP */
    }
    return(type);
}

noinit()
{
/*
 * curid is a variable which is defined but is not initialized
 * (and not a function ); This routine returns the storage
 * class for an uninitialized declaration
 */
#ifdef MPX
    return(EXTDEF);
#else
    return(EXTERN);
#endif
}

#ifdef DEC05_JUNK
commdec(id)
{		/* make a common declaration for id, if reasonable */
    register struct symtab *q;
    OFFSZ       off, tsize();
    char *nm;

    q = &stab[id];
#ifdef UAS
    nm = exname (q->sname, q->sflags);
#ifdef MPX
#ifdef DEC05
    if (q->sclass == EXTDEF)
#else
    /* added q->slevel >= 1 */
    if (q->sclass == EXTDEF && q->slevel >= 1)
#endif
	printf("	def	%s\n", nm);
#else
    printf("%s	common	%s(", nm, nm);
    off = tsize(q -> stype, q -> dimoff, q -> sizoff) / SZINT;
    printf(CONFMT, off);
    printf(")\n");
#endif /* MPX */
#else
    printf("	.comm	%s,", exname(q -> sname, q -> sflags));
    off = tsize(q -> stype, q -> dimoff, q -> sizoff) / SZCHAR;
    printf(CONFMT, off);
    printf("\n");
#endif

}
#endif /* DEC05_JUNK */

isitlong(cb, ce)
{		/* is lastcon to be long or short */
 /* cb is the first character of the representation, ce the last */

    if (ce == 'l' || ce == 'L' ||
	    (unsigned)lastcon >= (unsigned)(1L << (SZINT - 1)))
	return(1);
    return(0);
}


isitfloat(s) char  *s;
{
    double atof();
/* printf("fp num is %s\n", s); */
    dcon = atof(s);
    return(FCON);
}

#ifdef ONEPASS
ecode(p) NODE  *p;
{

 /* walk the tree and write out the nodes.. */

    if (nerrors)
	return;
    p2tree(p);
    p2compile(p);
}
#else
ecode(p) NODE  *p;
{

 /* walk the tree and write out the nodes.. */

    if (nerrors)
	return;
    printf("%1c%d\t%s\n", EXPR, lineno, ftitle);
    prtree(p);
}

tlen(p) NODE   *p;
{
    switch (p -> in.type) {
	case CHAR: 
	case UCHAR: 
	    return(1);

	case SHORT: 
	case USHORT: 
	    return(2);

	case LONG: 
	case DOUBLE: 
	    return(8);

	default: 
	    return(4);
    }
}

fltprint(p) register NODE *p;
{
	/* print the value of a floating point constant to the intermediate
	 * file.
	 */

	printf("%ld\t%d\t",p->tn.lval, p->tn.rval);
}

#endif

NODE       *addroreg(l)
{
/*
 * OREG was built in clocal()
 * for an auto or formal parameter
 * now its address is being taken
 * local code must unwind it
 * back to PLUS/MINUS REG ICON
 * according to local conventions
 */
    cerror("address of OREG taken");
    return(0);
}

/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */
