/* manifest.h */
/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */

/*
 * 	(c) Copyright 1990 J B Systems
 *	This file contains non-based support modifications
 *	for operation under MPX.  Derived from Encores' base
 *	mode C compiler.
 */

/*	@(#) (Gould) $Header: manifest.h,v 5.5 89/05/12 12:43:55 pcc Rel-3_0 $		  */

/*
    C compiler for Gould processors, base register instruction set.

    Ported from the 4.1c Berkeley Standard
	Distribution source for a VAX portable C compiler.
*/

#include <stdio.h>
/*	manifest constant file for the lex/yacc interface */

#define ERROR 1
#define NAME 2
#define STRING 3
#define ICON 4
#define FCON 5
#define PLUS 6
#define MINUS 8
#define MUL 11
#define AND 14
#define OR 17
#define ER 19
#define QUEST 21
#define COLON 22
#define ANDAND 23
#define OROR 24

/* the defines for ASOP, RELOP, EQUOP, DIVOP,
   SHIFTOP, ICOP, UNOP, and STROP have been
   moved to mfile1				*/
/*	reserved words, etc */
#define TYPE 33
#define CLASS 34
#define STRUCT 35
#define RETURN 36
#define GOTO 37
#define IF 38
#define ELSE 39
#define SWITCH 40
#define BREAK 41
#define CONTINUE 42
#define WHILE 43
#define DO 44
#define FOR 45
#define DEFAULT 46
#define CASE 47
#define SIZEOF 48
#define ENUM 49


/*	little symbols, etc. */
/*	namely,

	LP	(
	RP	)

	LC	{
	RC	}

	LB	[
	RB	]

	CM	,
	SM	;

	*/

/*  These defines are being moved to mfile1
    to alleviate preprocessor problems with
    second pass files.  
# define LP 50
# define RP 51
# define LC 52
# define RC 53
*/
#define LB 54
#define RB 55
#define CM 56
#define SM 57
#define ASSIGN 58
#ifdef MPX
#define ASM 59
#endif /* MPX */

/*	END OF YACC */

/*	left over tree building operators */
#define COMOP 59
#define DIV 60
#define MOD 62
#define LS 64
#define RS 66
#define DOT 68
#define STREF 69
#define CALL 70
#define FORTCALL 73
#define NOT 76
#define COMPL 77
#define INCR 78
#define DECR 79
#define EQ 80
#define NE 81
#define LE 82
#define LT 83
#define GE 84
#define GT 85
#define ULE 86
#define ULT 87
#define UGE 88
#define UGT 89
#ifdef MPX
#define SRA 90
#define SLA 92
#else
#define SETBIT 90
#define TESTBIT 91
#define RESETBIT 92
#define ARS 93
#endif
#define REG 94
#define OREG 95
#define CCODES 96
#define FREE 97
#define STASG 98
#define STARG 99
#define STCALL 100

/*	some conversion operators */
#define FLD 103
#define SCONV 104
#define PCONV 105
#define PMCONV 106
#define PVCONV 107

/*	special node operators, used for special contexts */
#define FORCE 108
#define CBRANCH 109
#define INIT 110
#define CAST 111

# define LNAME 112	/* atomic local automatic */
# define PNAME 113	/* atomic local parm */
# define TNAME 114	/* optimizer stack temporary */
# define TREG 115	/* optimizer register temporary */

# define OCONVLEAF 116	/* optimizer conversion node - leaf */
# define OCONVTREE 117	/* optimizer conversion node - tree */
# define LADDR 118	/* addr of a local */
# define PADDR 119	/* addr of a param */
# define ADDR 120	/* addr of anything else */

# define LEAFNOP 121	/* leaf no-op - used by optimizer */
# define UNARYNOP 122	/* unary no-op - ditto */

# define LTEMP 123	/* Loop invariant temporary */
# define STATNAME 124	/* Atomic local static - used mostly bo Fortran */
# define STADDR 125	/* Address of a STATNAME */

# define INCALL 126	/* inline call */

			/* 127 and 128 for UNARY INCALL, etc. */

# define STLABEL 129	/* statement label */

#define UMULP	130		/* load, given physical address */
#define ASGP	131		/* store given physical address */
#define UANDP	132		/* get phys address given logical addr */
#define MCON    133             /* ICON >=0 && <= ffffff */

	/* THIS MUST BE THE LAST DEFINITION */

#define LABCON	137		/* for f77 PCO only - here for completeness */
#define B3MASK	0x1000

 /* DSIZE is the size of the dope array */
#define DSIZE LABCON+1

/*	node types */
#define LTYPE 02
#define UTYPE 04
#define BITYPE 010

/*	type names, used in symbol table building */
#define TNULL PTR	/* pointer to UNDEF */
#define TVOID FTN	/* function returning UNDEF (for void) */
#define UNDEF 0
#define FARG 1
#define CHAR 2
#define SHORT 3
#define INT 4
#define LONG 5
#define FLOAT 6
#define DOUBLE 7
#define STRTY 8
#define UNIONTY 9
#define ENUMTY 10
#define MOETY 11
#define UCHAR 12
#define USHORT 13
#define UNSIGNED 14
#define ULONG 15

#define ASG 1+
#define UNARY 2+
#define NOASG (-1)+
#define NOUNARY (-2)+

/*	various flags */
#define NOLAB (-1)

/* type modifiers */

#define PTR  020
#define FTN  040
#define ARY  060

/* type packing constants */

#define TMASK 060
#define TMASK1 0300
#define TMASK2  0360
#define BTMASK 017
#define BTSHIFT 4
#define TSHIFT 2

/*	macros	*/

#define MODTYPE(x,y) x = ( (x)&(~BTMASK))|(y)	/* set basic type of x to y */
#define BTYPE(x)  ( (x)&BTMASK)			/* basic type of x */
#define ISUNSIGNED(x) ((x)<=ULONG&&(x)>=UCHAR)
#define UNSIGNABLE(x) ((x)<=LONG&&(x)>=CHAR)
#define ENUNSIGN(x) ((x)+(UNSIGNED-INT))
#define DEUNSIGN(x) ((x)+(INT-UNSIGNED))
#define ISPTR(x) (( (x)&TMASK)==PTR)
#define ISFTN(x)  (( (x)&TMASK)==FTN)		/* is x a function type */
#define ISARY(x)   (( (x)&TMASK)==ARY)		/* is x an array type */
#define INCREF(x) ((( (x)&~BTMASK)<<TSHIFT)|PTR|( (x)&BTMASK))
#define DECREF(x) ((( (x)>>TSHIFT)&~BTMASK)|( (x)&BTMASK))
#define SETOFF(x,y)   if( (x)%(y) != 0 ) (x) = ( ((x)/(y) + 1) * (y))
 /* advance x to a multiple of y */
#define NOFIT(x,y,z)   ( ( (x)%(z) + (y) ) > (z) )
 /* can y bits be added to x without overflowing z */
 /* pack and unpack field descriptors (size and offset) */
#define PKFIELD(s,o) (( (unsigned)(o)<<6)| (unsigned)(s) )
#define UPKFSZ(v)  ( (v) &077)
#define UPKFOFF(v) ( (v) >>6)

/*	operator information */

#define TYFLG 016
#define ASGFLG 01
#define LOGFLG 020

#define SIMPFLG 040
#define COMMFLG 0100
#define DIVFLG 0200
#define FLOFLG 0400
#define LTYFLG 01000
#define CALLFLG 02000
#define MULFLG 04000
#define SHFFLG 010000
#define ASGOPFLG 020000

#define SPFLG 040000
#define BITFLG 0100000		/* bit operators */

#define COMMUTEFLG 0200000	/* commutative operators */

#define optype(o) (dope[o]&TYFLG)
#define asgop(o) (dope[o]&ASGFLG)
#define logop(o) (dope[o]&LOGFLG)
#define callop(o) (dope[o]&CALLFLG)

#define commuteop(o) (dope[o]&COMMUTEFLG)

/*	table sizes	*/

#ifndef FORT
#define TREESZ 1000	/*used to be 350*//* space for building parse tree */
#else
#define TREESZ 1000
#endif

char       *tstr();
extern int  tstrused;
extern char    *tstrbuf[], **curtstr;
#define	freetstr()	curtstr = tstrbuf, tstrused = 0

/*	common defined variables */

extern int  nerrors;		/* number of errors seen so far */

typedef union ndu   NODE;
typedef int     TWORD;
#define NIL (NODE *)0
extern int  dope[];		/* a vector containing operator information */
extern char    *opst[];		/* a vector containing names for ops */

extern unsigned offsz, caloff();

#ifdef ONEPASS
 /* in one-pass operation, define the tree nodes */

union       ndu
{

    struct {
	int         op;
	int         rall;
	TWORD       type;
	int         su;
	char       *name;
	int         stalign;
	NODE       *left;
	NODE       *right;
    }           in;			/* interior node */

    struct {
	int         op;
	int         rall;
	TWORD       type;
	int         su;
	char       *name;
	int         stalign;
	CONSZ       lval;
	int         rval;
    } tn;				/* terminal node */

    struct {
	int         op, rall;
	TWORD       type;
	int         su;
	int         label;		/* for use with branching */
    } bn;				/* branch node */

    struct {
	int         op, rall;
	TWORD       type;
	int         su;
	int         stsize;		/* sizes of structure objects */
	int         stalign;		/* alignment of structure objects */
    } stn;				/* structure node */

    struct {
	int         op;
	int         cdim;
	TWORD       type;
	int         csiz;
    } fn;				/* front node */

    struct {
 /* this structure is used when a floating point constant is being computed */
	int         op;
	int         cdim;
	TWORD       type;
	int         csiz;
	double      dval;
    } fpn;				/* floating point node */

};
#endif

/* define NOBUG to eliminate debug code */
#ifdef NOBUG
#define BUG4
#endif

#ifdef BUG2
#define BUG1
#endif

#ifdef BUG3
#define BUG2
#define BUG1
#endif

#ifdef BUG4
#define BUG1
#define BUG2
#define BUG3
#endif

#ifndef ONEPASS

#ifndef EXPR
#define EXPR '*'
#endif

#ifndef BBEG
#define BBEG '['
#endif
#ifndef BEND
#define BEND ']'
#endif

# ifndef IBRANCH
# define IBRANCH '>'
# endif
# ifndef ILABEL
# define ILABEL '<'
# endif
# ifndef FBEGIN
# define FBEGIN '{'
# endif
# ifndef FEND
# define FEND '}'
# endif
# ifndef IRETURN
# define IRETURN 'R'
# endif
# ifndef ESWITCH
# define ESWITCH 'S'
# endif
# ifndef STABINFO
# define STABINFO '@'
# endif
# ifndef PFHERE
# define PFHERE 'H'
# endif
# ifndef PFETCH
# define PFETCH 'P'
# endif
# ifndef PSAVE
# define PSAVE 'V'
# endif
# ifndef IDATA
# define IDATA 'D'
# endif
# ifndef ITEXT
# define ITEXT 'T'
# endif
# ifndef IASM
# define IASM 'A'
# endif

# else /* ONEPASS */

/* make IDATA and ITEXT tabs for ONEPASS version */
# ifndef IDATA
# define IDATA '\t'
# endif
# ifndef ITEXT
# define ITEXT '\t'
# endif

# endif /* ONEPASS */

/* stack offsets, also see mfile1.h, mfile2.h */

#define MAXARGSIZE 3200		/* 3200 bits == 100 words */

/* switch definitions */

#define SWITSZ 500	/*500*/		/* size of switch table */

struct      sw
{
    CONSZ       sval;
    int         slab;
};

extern struct sw    swtab[];

/*
 * 	(c) Copyright 1986 Gould Inc.
 * 	    All Rights Reserved.
 */
