/*                                                                              
************************************************************************        
*                                                                      *        
*                    PROPRIETARY INFORMATION                           *        
*                    -----------------------                           *        
*   THE INFORMATION CONTAINED HEREIN IS PROPRIETARY TO ENCORE          *        
*   COMPUTER CORPORATION AND/OR ITS VENDORS, AND ITS USE, DISCLOSURE,  *        
*   OR DUPLICATION IS SUBJECT TO THE RESTRICTIONS STATED IN THE        *        
*   STANDARD ENCORE COMPUTER CORPORATION LICENSE TERMS AND CONDITIONS  *        
*   OR THE APPROPRIATE THIRD-PARTY SUBLICENSE AGREEMENT.               *        
*                                                                      *        
*                       RESTRICTED RIGHTS                              *        
*                       -----------------                              *        
*   USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT       *        
*   TO RESTRICTIONS AS SET FOURTH IN SUBDIVISION (c) (1) (ii) OF       *        
*   THE RIGHTS IN TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT       *        
*   252.227.7013                                                       *        
************************************************************************        
* (C) COPYRIGHT 1989 ENCORE COMPUTER CORPORATION                       *        
*     ALL RIGHTS RESERVED                                              *        
************************************************************************        
*                                                                               
         PROGRAM   J.TDEFI         MPX-32_3.5.01                                
*                                                                               
************************************************************************        
*        MPX-32 REVISION 3 RELEASE 3.5  CHANGE HISTORY                 *        
************************************************************************        
*                                                                               
*   VERSION 3.5.01  BL7                                                         
*                                                                               
*        S890152   11/16/89 10814  ADDED ANOTHER ARGUMENT TO    S890152         
*                                  ROUTINE PSCAN (AMOUNT TO     S890152         
*                                  INCREMENT LOOP) TO FIX THE   S890152         
*                                  WAY THE ROUTINE DETERMINED   S890152         
*                                  WHETHER A 2-CHAR CODE WAS    S890152         
*                                  ALREADY IN THE PARTITION.    S890152         
************************************************************************        
*        MPX-32 REVISION 3 RELEASE 3.4  CHANGE HISTORY                 *        
************************************************************************        
*                                                                               
*   VERSION 3.4.01                                                              
*                                                                               
*        Q017-34   09/08/87  9342  CORRECTED FUNCTION ALPHANUM  Q017-34         
*                                  TO ALLOW STRINGS WITH 0-9    Q017-34         
*                                  IN THEM INSTEAD OF ONLY 0-1. Q017-34         
************************************************************************        
*        MPX-32 REVISION 3 RELEASE 3.3  CHANGE HISTORY                 *        
************************************************************************        
*                                                                               
*   VERSION 3.3.00                                                              
*                                                                               
*        C001-33   09/11/86  9342  CREATED ORIGINAL VERSION OF  C001-33         
*                                  SJ.TDEFI                     C001-33         
*                                                                               
*   VERSION 3.3.01                                                              
*                                                                               
*        Q140-33   10/28/86  9342  Put in fix for QAR 01.       Q140-33         
*                                  Incorrect octal constants    Q140-33         
*                                  being generated.             Q140-33         
*                                                                               
*        Q134-33   10/29/86  9342  Put in fix for QAR 02.       Q134-33         
*                                  Check for UDT allocated or   Q134-33         
*                                  otherwise busy.              Q134-33         
*                                                                               
*        Q138-33   10/30/86  9342  Put in fix for QAR 01.       Q138-33         
*                                  Check for 0 valid entries    Q138-33         
*                                  in LOGONFLE, TERMDEF and     Q138-33         
*                                  TDEFLIST.  If zero, exit.    Q138-33         
*                                  Prevents MF01.               Q138-33         
************************************************************************        
*/                                                                              
                                                                                
#include <stdio.h>                                                              
                                                                                
#define ESC               0x1B                                                  
#define C_TDEFA           0x0C20                                                
#define C_UDTA            0x0B38                                                
#define C_UDTN            0x0C38                                                
#define UDTSIZE           16                                                    
#define CAPFILE           "@SYSTEM(SYSTEM)TDEFLIST"                             
#define LOGONF            "@SYSTEM(SYSTEM)LOGONFLE"                             
#define TERMF             "@SYSTEM(SYSTEM)TERMDEF"                              
#define READ              "r"                                                   
                                                                                
/*                                                                              
************************************************************************        
*   J.TDEFI reads the files LOGONFLE, TDEFLIST, and TERMDEF.  It then  *        
*   proceeds to build the partition TERMPART, filling it with a list   *        
*   of valid terminal definition strings, their abbreviations, and a   *        
*   list of valid terminal names.  This data is a subset of the        *        
*   TERMDEF file and is determined by the TERM= specification in       *        
*   LOGONFLE.                                                          *        
************************************************************************        
*   The following are exit messages which will be output to the        *        
*   console when J.TDEFI exits.                                        *        
************************************************************************        
*/                                                                              
                                                                                
char *error00 = "\15\12\7\7 Initialization of TERMPART complete. ";             
char *null00 = "TERMDEF is available.\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";           
char *error01 = "\15\12\7\7 Include of TERMPART by J.TDEFI failed.";            
char *null01 = " TERMDEF not initialized.\0\0\0\0\0\0\0\0\0\0\0\0\0\0";         
char *error02 = "\15\12\7\7 Open of TDEFLIST by J.TDEFI failed. ";              
char *null02 = "TERMDEF not initialized.\n\0\0\0\0\0\0\0\0\0\0\0\0\0";          
char *error03 = "\15\12\7\7 Open of LOGONFLE by J.TDEFI failed.";               
char *null03 = " TERMDEF not initialized.\n\0\0\0\0\0\0\0\0\0\0\0\0\0";         
char *error04 = "\15\12\7\7 Open of TERMDEF by J.TDEFI failed.";                
char *null04 = " TERMDEF not initialized.\n\0\0\0\0\0\0\0\0\0\0\0\0\0";         
char *error05 = "\15\12\7\7 Overflow of partition by J.TDEFI. ";                
char *null05 = "TERMDEF not initialized.\n\0\0\0\0\0\0\0\0\0\0\0\0\0";          
char *warn00 = "\15\12\7\7 A Duplicate Terminal Name was found.";               
char *wnull00 = "Initialization continuing.\n\0\0\0\0\0\0\0\0\0\0\0\0";         
static char *copyright = "(C) COPYRIGHT 1989 ENCORE COMPUTER CORP.";            
/*                                                                              
************************************************************************        
*   These are the definitions of the cells used in the doubly linked   *        
*   lists of control strings, terminal declarations from LOGONFLE, and *        
*   terminal definitions from TERMDEF.                                 *        
************************************************************************        
*/                                                                              
                                                                                
struct cscell {              /* Cell in the list of control strings */          
  int   csnum;               /* Control String number.              */          
  struct cscell  *next;      /* Next cell in the link list.         */          
  struct cscell  *prev;      /* Previous cell in the link list.     */          
  char  name[3];             /* The name of the control string.     */          
  } *cshead, *cstail, *cstr; /* Head, tail, and cell of the list.   */          
                                                                                
struct tdefn {               /* A cell in the list of termdefs.     */          
  int   typenum;             /* The def number to be put in the UDT.*/          
  struct tdefn   *next;      /* The next def in the list.           */          
  struct tdefn   *prev;      /* The previous def in the list.       */          
  char  defstr[1024];        /* Complete termdef string.            */          
  } *p, *head, *tail;        /* Head, tail and def of the list.     */          
                                                                                
struct logdef {              /* Cell in list of requested terminals.*/          
  int   dvc;                 /* The devices channel and subchannel  */          
  int   typenum;             /* The default def number for terminal.*/          
  int   *udt;                /* The UDT address for this terminal.  */          
  struct logdef  *next;      /* The next requested type in the list.*/          
  struct logdef  *prev;      /* The previous requested type in list.*/          
  char  tdefstr[24];         /* The terminal logonfle entry.        */          
  } *unit,*ttyhead,*ttytail; /* The head, tail, and termtype of list*/          
                                                                                
                                                                                
char *partstart,             /* The start of the partition "TERMPART"*/         
     *partend,               /* The end of the partition "TERMPART".*/          
     *putaddr,               /* The current address into partition. */          
     *termlist,              /* Address of the termlist section     */          
     *lookup,                /* Address of the lookup section       */          
     *rawdata,               /* Address of the raw data sectin      */          
     *tempstr,               /* A temporary storage area for strings*/          
     *getpart(),             /* Procedure which includes "TERMPART".*/          
     *BldCapList(),          /* Procedure that builds cntrl str list*/          
     *getdef(),              /* The procedure which gets a tdef.    */          
     *getnam(),              /* procedure that gets termtype out tdef*/         
     *pscan(),               /* A procedure which scans a string for*/          
                             /* a substring.                        */          
     *TDefParse();           /* A procedure which parses the control*/          
                             /* string from the termdef file.       */          
                                                                                
int  *partbegin,             /* The start of the partition          */          
     *tdefaddr,              /* The address of C.TDEFA              */          
     cscnt,                  /* The number valid control strings    */          
     regs[8],                /* The registers for mpxsvc.           */          
     lenterm,                /* The number of terminal types        */          
     lenraw,                 /* The length of the raw data          */          
     AlphaNum(),             /* An alphannumeric checker.           */          
     STRlen(),               /* A procedure to get the string length*/          
     scopy(),                /* A procedure to copy substrings.     */          
     getdvc(),               /* A procedure to get the int ch/subch */          
     *getudt(),              /* A procedure to get the UDT address  */          
     isthere(),              /* A procedure to find a term name     */          
                             /* type section of TERMPART.           */          
     putnam(),               /* A procedure to put a name n TERMPART*/          
     initnam(),              /* A procedure to initialize name sect */          
     ConvertStr();           /* A procedure to translate a cntrl str*/          
                                                                                
/*                                                                              
************************************************************************        
*                         J  .  T  D  E  F  I                          *        
*                         -------------------                          *        
************************************************************************        
*/                                                                              
                                                                                
main()                             /* The main section of SJ.TDEFI */           
{                                                                               
                                                                                
  tdefaddr = (int *)C_TDEFA;                                                    
                                                                                
  SetUnPriv();                     /* Go into unpriviledged mode. */            
                                                                                
  partstart = getpart();           /* include the partition. */                 
  partbegin = (int *)partstart;                                                 
                                                                                
  while (*(partstart + 4) & 0x80) {                                             
     regs[5] = -1;                 /* While the partition is SVC'd, */          
                                   /* wait 1 second */                          
     regs[6] = 0;                                                               
     regs[7] = 0;                                                               
     mpxsvc(0x1054,regs,regs);                                                  
     }                                                                          
                                                                                
  SetPriv();                       /* Go into privileged mode. */               
  asm(" zmw x'c20'");              /* Zero partition address in the */          
                                   /* communications region */                  
  SetUnPriv();                     /* Go into unprivileged mode. */             
                                                                                
  putaddr = BldCapList(partstart + 32); /* Init the caplist sect and */         
                                        /* return start of term sect */         
                                                                                
  while ((int)putaddr % 8 != 0) (int)putaddr++;  /* Doubleword bound */         
                                                 /* write address */            
                                                                                
  CkOverflow(putaddr,partend);                                                  
                                                                                
  termlist = putaddr;              /* Save start address of */                  
                                   /* termname section. */                      
                                                                                
  DoTTypes();                      /* Build the linked list of */               
                                   /* termnames and termdefs */                 
                                                                                
  SetTTypes(putaddr);              /* Write the valid termnames */              
                                   /* in the partition */                       
                                                                                
  SetUDTs();                       /* Write the valid terminal */               
                                   /* numbers in UDT. */                        
                                                                                
  lenterm = tail->typenum;         /* Save number of valid termname */          
                                   /* entries. */                               
                                                                                
  /* Set write address at the next valid free space */                          
  putaddr = (char *)((int)termlist + (lenterm * 16));                           
                                                                                
  while ((int)putaddr % 8 != 0) (int)putaddr++;  /* Doubleword bound */         
                                                 /* write address */            
                                                                                
  CkOverflow(putaddr,partend);                                                  
                                                                                
  lookup = putaddr;                                                             
                                                                                
  rawdata = (char *) ((int)lookup + 4*lenterm*cscnt + 4);                       
                                                                                
  while ((int)rawdata % 8 != 0) (int)rawdata++;  /* Doubleword bound */         
                                                 /* write address */            
                                                                                
  CkOverflow(putaddr,partend);                                                  
                                                                                
  putaddr = rawdata;                                                            
                                                                                
  lenraw = ConvertStr(putaddr);    /* Translate the control strings */          
                                   /* and put in raw data section.  */          
                                   /* Return length of it. */                   
/*                                                                              
************************************************************************        
*   Set up the first 8 words of the partition with the addresses and   *        
*   unit lengths of each section of the partition.                     *        
************************************************************************        
*/                                                                              
                                                                                
  *partbegin =  32;                                                             
  *(partbegin+1) = cscnt;                                                       
  *(partbegin+2) = (int)termlist - (int)partstart;                              
  *(partbegin+3) = lenterm;                                                     
  *(partbegin+4) = (int)lookup - (int)partstart;                                
  *(partbegin+5) = lenterm*cscnt;                                               
  *(partbegin+6) = (int)rawdata - (int)partstart;                               
  *(partbegin+7) = lenraw;                                                      
                                                                                
  SetPriv();                                                                    
  asm(" lw   r2.,>partsta");                                                    
  asm(" lear r2.,0,r2.");          /* Save the physical address of */           
                                   /* the partition */                          
  asm(" stw  r2.,x'c20'");                                                      
  SetUnPriv();                     /* Go unprivileged */                        
                                                                                
  exittdefi(0,error00);            /* Exit */                                   
}                                                                               
                                                                                
/*                                                                              
************************************************************************        
* (C) COPYRIGHT 1989 ENCORE COMPUTER CORPORATION                       *        
*     ALL RIGHTS RESERVED                                              *        
************************************************************************        
*                         G  E  T  P  A  R  T                          *        
*                         -------------------                          *        
*   This procedure includes the static partition TERMPART which is to  *        
*   be used in the generation of terminal control strings for screen   *        
*   formatting. No parameters are passed to it and it returns the      *        
*   starting address of the partition.                                 *        
************************************************************************        
*/                                                                              
                                                                                
char *                                                                          
getpart()                                                                       
{                                                                               
  char *pname = "@SYSTEM(SYSTEM)TERMPART\0";                                    
  char *tptr;                                                                   
  int l;                                                                        
  int partlen;                                                                  
  int cnp[6];                                                                   
                                                                                
  for (l = 0;l != 6;cnp[l++] = 0);                                              
  cnp[2] = 0xc0000000;             /* cnp to get part r/w exclusive */          
                                                                                
  for (l = 0;l != 8;regs[l++] = 0);                                             
                                                                                
  /* setup the PNV in register 1 and do the INCLUDE of TERMPART */              
  regs[1] = (STRlen(pname) << 24) | (int)pname;                                 
  regs[7] = (int)cnp;                                                           
  mpxsvc (0x2040,regs,regs);                                                    
                                                                                
  /* if return status from the include is not 0 exit with error 1 */            
  if ((cnp[2] & 0x0000ffff) == 1)  /* If no partition, no message */            
     exit(0);                                                                   
                                                                                
  if ((cnp[2] & 0x0000ffff) != 0)  /* If other error, message */                
     exittdefi(01,error01);                                                     
                                                                                
  tptr = (char *)regs[3];                                                       
                                                                                
  regs[5] = (0x00ffffff & regs[5]) + 4;   /* set to point to art wd 1*/         
  regs[5] = 0x00ffffff & *(int *)regs[5]; /* set to point to smt     */         
  regs[5] += 88;                          /* set to point at pg ct   */         
  regs[5] = *(int *)regs[5] & 0x0000ffff; /* get number of pages     */         
  partlen = regs[5] * 2048;               /* get byte size of part   */         
  partend = (char *)(regs[3] + partlen);  /* calculate the end addr  */         
                                                                                
  for (;partlen-- != 0; *tptr++ ='\0');   /* zero out the partition  */         
                                                                                
  return((char *)regs[3]);                /* return the start address*/         
                                                                                
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                     B  L  D  C  A  P  L  I  S  T                     *        
*                     ----------------------------                     *        
*   This procedure builds the list of valid control strings in the     *        
*   sysgened partition.  Also, duplication is checked and avoided for  *        
*   efficient memory usage.                                            *        
************************************************************************        
*/                                                                              
                                                                                
char *                                                                          
BldCapList(putaddr)                                                             
char *putaddr;                                                                  
{                                                                               
  FILE  *capf;                                                                  
  char  line[132];                                                              
  char  *partcap;                                                               
  int   gotone;                                           /* Q134-33 */         
                                                                                
  gotone = 0;                                             /* Q134-33 */         
  partcap = putaddr;                                                            
                                                                                
  if ((capf = fopen(CAPFILE,READ)) == NULL)                                     
     exittdefi(02,error02);                                                     
                                                                                
  cscnt = 1;                                                                    
                                                                                
  cstr = (struct cscell *)malloc(sizeof(*cstr));                                
  cshead = cstail = cstr;                                                       
  cstr->next = cstr->prev = NULL;                                               
                                                                                
  for (; fgets(line,132,capf) != NULL;) {                                       
     if(*line != '*') {                                                         
        scopy(cstr->name,line,2);         /*  Copy the cs name       */         
        cstr->csnum = 0;                  /*  Zero cs number         */         
        cstr->name[2]='=';                /*  Set up name for search */         
      /*if ((!pscan(partcap,putaddr,cstr->name,2)) &&*/   /* S890152 */         
        if ((!pscan(partcap,putaddr,cstr->name,2,2)) &&   /* S890152 */         
                          (AlphaNum(cstr->name[0])) &&                          
                          (AlphaNum(cstr->name[1]))) {                          
           gotone = 1;                                    /* Q134-33 */         
           cstr->csnum = cscnt;           /* Assign the cs count     */         
           *putaddr++ = cstr->name[0];    /* Save the defname in part*/         
           *putaddr++ = cstr->name[1];    /* Save the defname in part*/         
           CkOverflow(putaddr,partend);   /* At end of partition?    */         
           if (cshead != cstr) {          /* Link in list of cs cells*/         
              cstr->prev = cstail;                                              
              cstr->next = cstail->next;                                        
              cstail->next = cstr;                                              
              cstail = cstr;                                                    
              }                                                                 
           cscnt++;                       /*  Increment the cs count  */        
           cstr = (struct cscell *)malloc(sizeof(*cstr)); /* new cell */        
           }                                                                    
        }                                                                       
     }                                                                          
                                                                                
  fclose (capf);                   /* close TDEFLIST */                         
                                                                                
  if(gotone == 0) exit(0);                                /* Q134-33 */         
                                                                                
  return(putaddr);                 /* return current save address */            
}                                                                               
                                                                                
/*                                                                              
************************************************************************        
*                            S  C  O  P  Y                             *        
*                            -------------                             *        
*   This routine copies a string of length n from t to s.              *        
************************************************************************        
*/                                                                              
                                                                                
int                                                                             
scopy(s,t,n)                                                                    
char *s,*t;                                                                     
int  n;                                                                         
{                                                                               
  for (;n-- != 0; *s++ = *t++);                                                 
}                                                                               
                                                                                
/*                                                                              
************************************************************************        
*                            P  S  C  A  N                             *        
*                            -------------                             *        
*   This procedure scans for a substring in a string.  It is passed    *        
*   the range to search in [start..endofstring], the substring to      *        
*   find, and the length of the substring.                             *        
************************************************************************        
*/                                                                              
                                                                                
char *                                                                          
/*pscan (s,t,str,l)*/                                     /* S890152 */         
pscan (s,t,str,l,ia)                                      /* S890152 */         
char *s,*t,*str;                                                                
int  l;                                                                         
int  ia;                           /* increment amount */ /* S890152 */         
{                                                                               
  char  *x,*y,*z;                  /* temporary string variables */             
  int   j;                         /* counter to check for length */            
                                                                                
/*for (x=s; x < t-l+1;x++) { */                           /* S890152 */         
  for (x=s; x < t-l+1;x+=ia) {                            /* S890152 */         
     y = str;                      /* set y to point at substring */            
     z = x;                        /* set z to point at current */              
                                   /* search area */                            
                                                                                
     for (j=0; (*x++ == *y++) && (j != l);j++);  /* scan for match */           
     if (j == l)                   /* if lengths match, string found */         
        return(z);                 /* return pointer */                         
     x = z;                                                                     
     }                                                                          
                                                                                
  return(NULL);                    /* if no match, return null */               
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                        D  O  T  T  Y  P  E  S                        *        
*                        ----------------------                        *        
*   This procedure sets up the list of valid terminal types in the     *        
*   partition. It prevents the duplication of a terminal type in this  *        
*   area for more efficient memory usage.                              *        
************************************************************************        
*/                                                                              
                                                                                
DoTTypes()                                                                      
{                                                                               
  FILE  *log,*tdeff;                                                            
  char  *tstr = "TERM=";                                                        
  char  aln[132],*xstr,*termd,*tnend,*tname;                                    
  char  *colon = ":";                                                           
  char  *line,*tline;                                                           
  char  def[8];                                                                 
  char  *(partterm[8]);                                                         
  int   *udtwhere,udtnumbr;                                                     
  int   i,console,count,ctypen,ii;                                              
  int   gotone;                                           /* Q134-33 */         
                                                                                
  gotone = 0;                                             /* Q134-33 */         
                                                                                
                                                                                
  if ((log = fopen(LOGONF,READ)) == NULL) {   /* open LOGONFLE */               
     exittdefi(03,error03);                   /* if error then exit */          
     }                                                                          
                                                                                
  if ((tdeff = fopen(TERMF,READ)) == NULL) {  /* open TERMDEF */                
     exittdefi(04,error04);                   /* if error then exit */          
     }                                                                          
                                                                                
/*                                                                              
************************************************************************        
*   Initialize the count of terminal types and initial link lists.     *        
************************************************************************        
*/                                                                              
                                                                                
  count = 1;                                                                    
  p = (struct tdefn *)malloc(sizeof(*p));                                       
  unit = (struct logdef *)malloc(sizeof(*unit));                                
  head = tail = p;                                                              
  p->prev = NULL;                                                               
  p->next = NULL;                                                               
  ttyhead = ttytail = unit;                                                     
  unit->prev = NULL;                                                            
  unit->next = NULL;                                                            
                                                                                
/*                                                                              
************************************************************************        
* (C) COPYRIGHT 1989 ENCORE COMPUTER CORPORATION                       *        
*     ALL RIGHTS RESERVED                                              *        
************************************************************************        
*   This section of code should build a doubly linked list of terminal *        
*   entries from LOGONFLE.  Each entry in the list contains the term   *        
*   name, channel and subchannel address, and udt address.             *        
************************************************************************        
*/                                                                              
                                                                                
  console = 0;                                                                  
  for (;fgets(aln,132,log) != NULL;) {                                          
   /*termd = pscan (aln,aln+STRlen(aln),tstr,5);*/        /* S890152 */         
     termd = pscan (aln,aln+STRlen(aln),tstr,5,1);        /* S890152 */         
                                                                                
     unit->dvc = 0;          /* init typenum */                                 
     if ((termd == NULL) && (console == 0)) {                                   
      /*termd = pscan(aln,aln+STRlen(aln),"CONS=\0",5);*/ /* S890152 */         
        termd = pscan(aln,aln+STRlen(aln),"CONS=\0",5,1); /* S890152 */         
        if (termd != NULL) {                                                    
           console = 1;                                                         
        }                                                                       
     }                                                                          
                                                                                
     for(ii = 0; ii < 18; unit->tdefstr[ii++] = '\0');                          
     ii = 0;                                                                    
     if (termd) {                                                               
        gotone = 1;                                       /* Q134-33 */         
        for (;*termd++ != '=';);                                                
        unit->tdefstr[0] = '\7';                                                
        for (ii=1;(ii < 16) && (*termd > ' ');                                  
                  unit->tdefstr[ii++] = *termd++);                              
        for(ii = 16;(unit->tdefstr[ii] == '\0') && (ii > 0); ii--);             
        if (ii > 16) ii = 16;                                                   
        if (unit->tdefstr[ii] != '\7')                                          
           unit->tdefstr[ii+1] = '\7';                                          
        }                                                                       
                                                                                
     unit->typenum = 0;            /* init typenum */                           
     if (console == 1) {                                                        
        console = 2;                                                            
        udtwhere = (int *)*(int *)C_UDTA;                                       
        udtnumbr = *(int *)C_UDTN >> 16;                                        
                                                                                
        for (i = 0;(i != udtnumbr) &&                                           
                   ((udtwhere[1] & 0x00FF0000) != 0x000d0000);                  
            udtwhere = (int *)((int)udtwhere + UDTSIZE*4));                     
                                                                                
        if ((udtwhere[1] & 0x00FF0000) == 0x000d0000) {                         
           unit->udt = udtwhere;                 /* get udt address */          
           unit->dvc = udtwhere[1] & 0x0000FFFF;    /* get mnemonic */          
           }                                                                    
        else {                                                                  
           unit->udt = 0;          /* get udt address */                        
           unit->dvc = 0;          /* get device mnemonic */                    
           }                                                                    
        }                                                                       
     else {                                                                     
        unit->dvc = getdvc(aln);                                                
        unit->udt = getudt(unit->dvc);                                          
        }                                                                       
     if ((ttyhead != unit) && (STRlen(unit->tdefstr) != 0)) {                   
        unit->prev = ttytail;      /* link in list */                           
        unit->next = ttytail->next;                                             
        ttytail->next = unit;                                                   
        ttytail = unit;                                                         
        count++;                                                                
        }                                                                       
     if (STRlen(unit->tdefstr) != 0)                                            
        unit = (struct logdef *)malloc(sizeof(*unit)); /* new cell*/            
     }                                                                          
                                                                                
/*                                                                              
************************************************************************        
*   This section of code should build a doubly linked list of terminal *        
*   definitions which have been specified in LOGONFLE.  It should also *        
*   assign terminal type numbers to them and the associated terminal   *        
*   entries in LOGONFLE.                                               *        
************************************************************************        
*/                                                                              
                                                                                
  if (gotone == 0) exit(0);                               /* Q134-33 */         
  else gotone = 0;                                        /* Q134-33 */         
                                                                                
  ctypen = 1;                      /* initialize TERMTYPE NUMBER */             
                                                                                
  for (;(getdef(tdeff,p->defstr)) != NULL;) {    /* do until eof */             
                                                                                
     p->typenum = 0;                                                            
     tnend = pscan (p->defstr,(char *)(p->defstr + STRlen(p->defstr))           
                 /*,colon,1);*/   /* find end of names */ /* S890152 */         
                   ,colon,1,1);   /* find end of names */ /* S890152 */         
                                                                                
     for (unit = ttyhead; (unit != NULL) && (count !=0);                        
                          unit = unit->next) {                                  
        tname = NULL;              /* get a unit definition */                  
                                                                                
       /* if name scan def */                                                   
        if (((*unit).tdefstr[0] != '\0') && (unit->typenum == 0))               
           tname = pscan (p->defstr,tnend,unit->tdefstr                         
                       /*,STRlen(unit->tdefstr));*/       /* S890152 */         
                         ,STRlen(unit->tdefstr,1));       /* S890152 */         
                                                                                
        if (tname != NULL) {                                                    
            count--;               /* if found set termtype nums */             
            unit->typenum = ctypen;                                             
            p->typenum = ctypen;                                                
           }                                                                    
        }                                                                       
                                                                                
     if (p->typenum != 0) {        /* if def requested link */                  
        gotone = 1;                                       /* Q134-33 */         
        if (head != p) {                                                        
           p->prev = tail;                                                      
           p->next = tail->next;                                                
           tail->next = p;                                                      
           tail = p;                                                            
           }                                                                    
        ctypen++;                  /* increment termtype number */              
        p = (struct tdefn *)malloc(sizeof(*p)); /* get new cell */              
        }                                                                       
     }                                                                          
                                                                                
  if (gotone == 0) exit(0);                               /* Q134-33 */         
                                                                                
  return;                                                                       
                                                                                
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                           G  E  T  D  V  C                           *        
*                           ----------------                           *        
*   This is basically an atox (alpha to hex) conversion routine except *        
*   that it translates only the first four bytes of the string passed  *        
*   to it and if there is an illegal character there, it returns null. *        
************************************************************************        
*/                                                                              
                                                                                
int                                                                             
getdvc(s)                                                                       
char *s;                                                                        
{                                                                               
  int i;                                                                        
  int j;                                                                        
                                                                                
  j = 0;                                                                        
  for (i=0; i++ != 4;s++) {                                                     
     if ((*s >= '0') && (*s <= '9'))                                            
        j = (j << 4) | (int)(*s - '0');                                         
     else if ((*s >= 'A') && (*s <= 'F'))                                       
        j = (j << 4) | ((int)(*s - 'A') + 10) ;                                 
     else if ((*s >= 'a') && (*s <= 'f'))                                       
        j = (j << 4) | ((int)(*s - 'a') + 10) ;                                 
     else                                                                       
        return(0);                                                              
     }                                                                          
                                                                                
  return(j);                                                                    
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                           G  E  T  U  D  T                           *        
*                           ----------------                           *        
*   This routine should return the address to the UDT which has the    *        
*   same channel and subchannel that is passed to it.  Note that the   *        
*   task has to be privileged when executing this code and it must     *        
*   also have included the "SYSEQU.H" file.                            *        
************************************************************************        
*/                                                                              
                                                                                
int *                                                                           
getudt(s)                                                                       
int s;                                                                          
{                                                                               
  int   *udtwhere,udtnumbr;                                                     
  int   i;                                                                      
                                                                                
  if (s==0) return(NULL);                                                       
                                                                                
  udtwhere = (int *)*(int *)C_UDTA;                                             
  udtnumbr = *(int *)C_UDTN >> 16;                                              
                                                                                
  SetPriv();                                                                    
  for (i = 0; i != udtnumbr;                                                    
              udtwhere = (int *)((int)udtwhere + UDTSIZE*4)) {                  
     if ((udtwhere[1] & 0x0000FFFF) == s) {                                     
    /*  udtwhere[7] = 0; */        /* reset the unit number*/                   
        SetUnPriv();                                                            
        return(udtwhere);                                                       
        }                                                                       
     i++;                                                                       
     }                                                                          
  SetUnPriv();                                                                  
                                                                                
  return(NULL);                                                                 
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                           G  E  T  D  E  F                           *        
*                           ----------------                           *        
*   This routine should return a complete terminal definition from the *        
*   TERMDEF file.  In the TERMDEF file, a "#" in column 1 denotes a    *        
*   comment and a "\" at the end of line is a continuation character.  *        
************************************************************************        
*/                                                                              
                                                                                
char *                                                                          
getdef(s,dfn)                                                                   
FILE *s;                                                                        
char dfn[];                                                                     
{                                                                               
  char ln[132];                                                                 
  char *line;                                                                   
  char *lend;                                                                   
  int  i,flg;                                                                   
                                                                                
  i = 0;                                                                        
  dfn[0] = '\7';                                                                
  dfn[1] = NULL;                                                                
                                                                                
  while ((line = fgets(ln,132,s)) != NULL) {                                    
     for (lend = (char *)((int)line + STRlen(line));                            
           *lend <= ' '; *lend-- = '\0');                                       
     flg =0;                                                                    
     if (*lend == '\\') {                                                       
        *lend-- = '\0';                                                         
        flg = 1;                                                                
        }                                                                       
     if ((*line == ':') && (*(char *)((int)dfn +                                
                            STRlen((char *)dfn)) == ':'))                       
        *line++ = '\0';                                                         
     for (;*line <= ' '; line++);                                               
     if ((*line != '#') && (dfn[0] == NULL))                                    
        while (dfn[i++] = *line++);                                             
     else if ((!flg) && (*line != '#')) {                                       
        strcat((char *)dfn,line);                                               
        delimname((char *)dfn);                                                 
        return((char *)dfn);                                                    
        }                                                                       
     else if (*line != '#')                                                     
           strcat((char *)dfn,line);                                            
     }                                                                          
                                                                                
  if (dfn[1] == NULL) return(NULL);                                             
  delimname((char *)dfn);                                                       
  return((char *)dfn);                                                          
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                      D  E  L  I  M  N  A  M  E                       *        
*                      -------------------------                       *        
*   This routine takes the definition string and changes list of       *        
*   valid terminal names to a simplified list of names delimited       *        
*   by a BELL (char 07).                                               *        
************************************************************************        
*/                                                                              
                                                                                
delimname(str)                                                                  
char *str;                                                                      
{                                                                               
  while ((*str == ' ') || (*str == '|') || (*str == '\7'))                      
     *str++ = '\7';                                                             
                                                                                
  while (*str != ':') {                                                         
     while ((*str != ' ') && (*str != '|') &&                                   
            (*str != ':') && (*str != '\0'))                                    
        str++;                                                                  
     while ((*str != '|') && (*str != '\0') && (*str != ':'))                   
        *str++ = '\7';                                                          
     while ((*str == '|') || (*str == ' ') || (*str == '\7'))                   
        *str++ = '\7';                                                          
     }                                                                          
                                                                                
  return;                                                                       
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
* (C) COPYRIGHT 1989 ENCORE COMPUTER CORPORATION                       *        
*     ALL RIGHTS RESERVED                                              *        
************************************************************************        
*                         S  E  T  U  D  T  S                          *        
*                         -------------------                          *        
*   This routine uses the udt addresses in the unit list and sets the  *        
*   current and default terminal types to the unit->typenum value.     *        
************************************************************************        
*/                                                                              
                                                                                
SetUDTs()                                                                       
{                                                                               
  int   *udtray;                                                                
                                                                                
  SetPriv();                                                                    
                                                                                
  for (unit = ttyhead; unit != NULL; unit = unit->next) {                       
     udtray = (int *)0;                                   /* Q138-33 */         
     if ((unit->dvc != -1) && (unit->udt > 0)) {          /* Q138-33 */         
        udtray = unit->udt;                                                     
        if (!(*(udtray+1) & 0x30000000) &&                /* Q138-33 */         
            !(*(udtray+4) & 0x50000000))                  /* Q138-33 */         
           *(udtray+7) = unit->typenum |                                        
                        (unit->typenum << 16);                                  
        else                                              /* Q138-33 */         
           *(udtray+7) = (*(udtray+7) & 0xffff0000) |     /* Q138-33 */         
                           unit->typenum;                 /* Q138-33 */         
        }                                                 /* Q138-33 */         
                                                                                
     else if (unit->dvc == -1) SetConsole();              /* Q138-33 */         
     }                                                                          
                                                                                
  SetUnPriv();                                                                  
                                                                                
  return(1);                                                                    
                                                                                
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                     S  E  T  C  O  N  S  O  L  E                     *        
*                     ----------------------------                     *        
*   This routine should return the address to the UDT which has the    *        
*   same channel and subchannel that is passed to it.  Note that the   *        
*   task has to be privileged when executing this code and it must     *        
*   also have included the "SYSEQU.H" file.                            *        
************************************************************************        
*/                                                                              
                                                                                
SetConsole()                                                                    
{                                                                               
  int   *udtwhere,udtnumbr;                                                     
  int   i;                                                                      
                                                                                
  udtwhere = (int *)*(int *)C_UDTA;                                             
  udtnumbr = *(int *)C_UDTN >> 16;                                              
                                                                                
  SetPriv();                                                                    
  for (i = 0; i != udtnumbr;                                                    
              udtwhere = (int *)((int)udtwhere + UDTSIZE*4)) {                  
     if (udtwhere[1] & 0x00FF0000) {                                            
        udtwhere[7] = unit->typenum | (unit->typenum << 16);                    
        SetUnPriv();                                                            
        }                                                                       
     i++;                                                                       
     }                                                                          
  SetUnPriv();                                                                  
                                                                                
  return(NULL);                                                                 
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                      S  E  T  T  T  Y  P  E  S                       *        
*                      -------------------------                       *        
*   This procedure takes the current termdef in the list and finds     *        
*   the names available to fill the termlist section of TERMPART and   *        
*   calls putnam to put them in the proper slot.                       *        
************************************************************************        
*/                                                                              
                                                                                
SetTTypes(putaddr)                                                              
char *putaddr;                                                                  
{                                                                               
  int   l;                                                                      
  char  tnam[17];                                                               
                                                                                
  for (p = head; p != NULL; p = p->next) {                                      
     initnam(putaddr);                                                          
     tempstr = (char *)p->defstr;                                               
     while ((getnam(tnam)) != NULL) {                                           
        l = STRlen(tnam);                                                       
        switch (l) {                                                            
           case 0: break;                                                       
           case 1: case 2: case 3:                                              
              if (isthere(tnam,l,putaddr)) break;                               
              putnam(tnam,l,putaddr);                                           
              break;                                                            
           default:                                                             
              if (isthere(tnam,l,putaddr)) break;                               
              putnam(tnam,l,putaddr);                                           
              break;                                                            
           }                                                                    
        }                                                                       
     putaddr += 16;                                                             
     CkOverflow(putaddr,partend);                                               
     }                                                                          
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                           G  E  T  N  A  M                           *        
*                           ----------------                           *        
*   This procedure gets a terminal name from a TERMDEF.                *        
************************************************************************        
*/                                                                              
                                                                                
char *                                                                          
getnam(sx)                                                                      
char sx[17];                                                                    
{                                                                               
  int   i;                                                                      
                                                                                
  i = 0;                                                                        
  while (*tempstr == '\7') tempstr++;                                           
                                                                                
  if (*tempstr == '\\') return(NULL);                                           
                                                                                
  for (i=0;(i < 16) && (*tempstr != '\7') && (*tempstr != '\\')                 
                    && (*tempstr != ':');                                       
            sx[i++] = *tempstr++);                                              
                                                                                
  for (;i < 17; sx[i++] = '\0');                                                
                                                                                
  while ((*tempstr != '\7') && (*tempstr != '\\')) tempstr++;                   
                                                                                
  return((char *)sx);                                                           
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                         I  S  T  H  E  R  E                          *        
*                         -------------------                          *        
*   This procedure checks to see if a name of a certain length has     *        
*   already been added and returns 1 if so.                            *        
************************************************************************        
*/                                                                              
                                                                                
int                                                                             
isthere(t,l,whar)                                                               
char t[17];                                                                     
int  l;                                                                         
char *whar;                                                                     
{                                                                               
  int   i,offset;                                                               
  char  *ckaddr,*taddr;                                                         
                                                                                
  offset = l;                                                                   
                                                                                
  if (l == 3) offset = 5;                                                       
  if (l >  3) offset = 8;                                                       
                                                                                
  for (ckaddr = termlist; ckaddr < whar; ckaddr += 16) {                        
     taddr = ckaddr + offset;                                                   
     for (i = 0; (i != l) && (*taddr++ == t[i]);i++);                           
     if (i == l) {                                                              
      errormsg(warn00);                                                         
      return(1);                                                                
      }                                                                         
     }                                                                          
                                                                                
  if (*(whar + offset) != ' ') return(1);                                       
                                                                                
  return(0);                                                                    
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                           P  U  T  N  A  M                           *        
*                           ----------------                           *        
*   This procedure receieves a string, a slot length, and an address   *        
*   and puts the string at that address.                               *        
************************************************************************        
*/                                                                              
                                                                                
int                                                                             
putnam(t,l,where)                                                               
char t[17];                                                                     
int  l;                                                                         
char *where;                                                                    
{                                                                               
  int   i,offset;                                                               
                                                                                
  offset = l;                                                                   
                                                                                
  if (l == 3) offset = 5;                                                       
  if (l >  3) offset = 8;                                                       
                                                                                
  where += offset;                                                              
  for (i = 0; i < l; *where++ = t[i++]);                                        
  return(1);                                                                    
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                         I  N  I  T  N  A  M                          *        
*                         -------------------                          *        
*   This procedure blank fills a termlist name area in the partition.  *        
************************************************************************        
*/                                                                              
                                                                                
int                                                                             
initnam(where)                                                                  
char *where;                                                                    
{                                                                               
  int   i;                                                                      
                                                                                
  for (i = 0; i++ != 16; *where++ = ' ');                                       
  return (1);                                                                   
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                     C  O  N  V  E  R  T  S  T  R                     *        
*                     ----------------------------                     *        
*   This procedure receives an address and translates all valid cntrl  *        
*   strings in a TERMDEF and puts them in the raw data area of the     *        
*   partition and saves the address and length of each in the proper   *        
*   area of the lookup area.                                           *        
************************************************************************        
*/                                                                              
                                                                                
int                                                                             
ConvertStr(putaddr)                                                             
char *putaddr;                                                                  
{                                                                               
  char  *csbuf,*ptr,*kah;                                                       
  int   found,i;                                                                
  int   *lookslot;                                                              
  int   tlen;                                                                   
                                                                                
  tlen = 0;                                                                     
  for (p = head; p != NULL; p = p->next) {                                      
     for (cstr = cshead; cstr != NULL; cstr = cstr->next) {                     
                                                                                
        ptr = p->defstr;                                                        
                                                                                
        csbuf = pscan(p->defstr,(char *)((int)p->defstr +                       
                      STRlen(p->defstr))                                        
                   /*,(char *)cstr->name,2);*/            /* S890152 */         
                     ,(char *)cstr->name,2,1);            /* S890152 */         
                                                                                
        lookslot = (int *)((int)lookup + (p->typenum - 1) * (cscnt*4)           
                                       + (cstr->csnum - 1) * 4);                
                                                                                
        *lookslot = 0;                                                          
                                                                                
        while (csbuf) {                                                         
           csbuf += 2;                                                          
           if ((*csbuf == ':') || (*csbuf == '=') || (*csbuf == '#')) {         
              putaddr = TDefParse(putaddr,lookslot,csbuf);                      
              csbuf = NULL;                                                     
              }                                                                 
           else                                                                 
              csbuf = pscan(csbuf,(char *)((int)csbuf + STRlen(csbuf))          
                         /*,(char *)cstr->name,2);*/      /* S890152 */         
                           ,(char *)cstr->name,2,1);      /* S890152 */         
           }                                                                    
        }                                                                       
     }                                                                          
  lookslot = (int *)((int)lookup + (tail->typenum * cscnt)*4);                  
  *lookslot = (int)putaddr - (int)partstart;                                    
  tlen = (int)putaddr - (int)rawdata;                                           
                                                                                
  return(tlen);                                                                 
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
* (C) COPYRIGHT 1989 ENCORE COMPUTER CORPORATION                       *        
*     ALL RIGHTS RESERVED                                              *        
************************************************************************        
*                      T  D  E  F  P  A  R  S  E                       *        
*                      -------------------------                       *        
*   This routine does the actual translation of a control string       *        
*   according to the value of the string.  It also does the actual     *        
*   storage of the string, its address, and its length in the          *        
*   partition.                                                         *        
************************************************************************        
*/                                                                              
                                                                                
char *                                                                          
TDefParse(putaddr,slot,s)                                                       
char *putaddr;                                                                  
int  *slot;                                                                     
char *s;                                                                        
{                                                                               
                                                                                
  *slot++ = (int)(putaddr - partstart);                                         
                                                                                
  if (*s == ':') {                                                              
     *putaddr++ = 1;                                                            
     return(putaddr);                                                           
     }                                                                          
  else if (*s == '#') {                                                         
     for (*s++; (*s) && (*s >= '0') && (*s <= '9');                             
        *putaddr++ = *s++);                                                     
     return(putaddr);                                                           
     }                                                                          
                                                                                
  s++;                                                                          
                                                                                
  while ((*s) && (*s != ':')) {                                                 
     switch (*s) {                                                              
        case '^':                                                               
           *putaddr = *(++s) - (char)0x40;                                      
           break;                                                               
        case '\\':                                                              
           *s++;                                                                
           switch (*s) {                                                        
              case 'E':                                                         
                 *putaddr = (char) 0x1B;                                        
                 break;                                                         
              case 'n':                                                         
                 *putaddr = (char) 0x0a;                                        
                 break;                                                         
              case 'r':                                                         
                 *putaddr = (char) 0x0d;                                        
                 break;                                                         
              case 't':                                                         
                 *putaddr = (char) 0x09;                                        
                 break;                                                         
              case 'b':                                                         
                 *putaddr = (char) 0x08;                                        
                 break;                                                         
              case 'f':                                                         
                 *putaddr = (char) 0x0c;                                        
                 break;                                                         
              default: {                                                        
                 if ((*s >= '0') && (*s <= '7')) {                              
                    *putaddr = (*s     - '0') * 64 +      /* Q140-33 */         
                               (*(s+1) - '0') *  8 +      /* Q140-33 */         
                               (*(s+2) - '0');            /* Q140-33 */         
                    s += 2;                                                     
                    }                                                           
                 else {                                                         
                    *putaddr = *s;                                              
                    }                                                           
                 }                                                              
              }                                                                 
           break;                                                               
        default: {                                                              
           *putaddr = *s;                                                       
           }                                                                    
        }                                                                       
     putaddr++;                                                                 
     s++;                                                                       
     }                                                                          
                                                                                
  CkOverflow(putaddr,partend);                                                  
                                                                                
  return(putaddr);                                                              
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                      E  X  I  T  T  D  E  F  I                       *        
*                      -------------------------                       *        
*   This procedure receives an error number and a msg.  It puts the    *        
*   errornum in the first byte of the partition and outputs the msg    *        
*   to the console. It then exits the program.  No further processing  *        
*   is done.                                                           *        
************************************************************************        
*/                                                                              
                                                                                
exittdefi(errnum,msg)                                                           
int  errnum;                                                                    
char *msg;                                                                      
{                                                                               
  int   *part1;                                                                 
  int   tcpb[3],i;                                                              
                                                                                
  for (i=0;i != 3;tcpb[i++] = 0);                                               
                                                                                
  tcpb[0] = (STRlen(msg) << 24) | ((int)msg & 0x00ffffff);                      
  regs[1] = (int)tcpb;                                                          
                                                                                
  if (errnum > 01) {                                                            
     part1 = (int *)partstart;                                                  
     *part1 = errnum << 24;                                                     
     }                                                                          
                                                                                
  mpxsvc(0x103f,regs,regs);                                                     
                                                                                
  exit(0);                                                                      
                                                                                
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                        E  R  R  O  R  M  S  G                        *        
*                        ----------------------                        *        
*   This procedure writes an error message to console.                 *        
************************************************************************        
*/                                                                              
                                                                                
errormsg(msg)                                                                   
char *msg;                                                                      
{                                                                               
  int   *part1;                                                                 
  int   tcpb[3],i;                                                              
                                                                                
  for (i=0;i != 3;tcpb[i++] = 0);                                               
                                                                                
  tcpb[0] = (STRlen(msg) << 24) | ((int)msg & 0x00ffffff);                      
  regs[1] = (int)tcpb;                                                          
                                                                                
  mpxsvc(0x103f,regs,regs);                                                     
                                                                                
  return;                                                                       
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                         S  E  T  P  R  I  V                          *        
*                         -------------------                          *        
*   This procedure puts J.TDEFI in priviledged mode.                   *        
************************************************************************        
*/                                                                              
                                                                                
SetPriv()                                                                       
{                                                                               
                                                                                
  mpxsvc(0x2057,regs,regs);                                                     
                                                                                
  return;                                                                       
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                      S  E  T  U  N  P  R  I  V                       *        
*                      -------------------------                       *        
*   This procedure puts J.TDEFI in unpriviledged mode.                 *        
************************************************************************        
*/                                                                              
                                                                                
SetUnPriv()                                                                     
{                                                                               
                                                                                
  mpxsvc(0x2058,regs,regs);                                                     
                                                                                
  return;                                                                       
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
*                     C  K  O  V  E  R  F  L  O  W                     *        
*                     ----------------------------                     *        
*   This procedure checks for a partition overflow.                    *        
************************************************************************        
*/                                                                              
                                                                                
CkOverflow(addr,end)                                                            
char *addr,*end;                                                                
{                                                                               
  if (addr >= end)                                                              
     exittdefi(05,error05);                                                     
                                                                                
  return;                                                                       
  }                                                                             
                                                                                
/*                                                                              
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *         
*   Ripped this out of the runtime to reduce include size.            *         
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *         
*/                                                                              
                                                                                
int                                                                             
STRlen(s)                                                                       
char *s;                                                                        
{                                                                               
  char *p = s;                                                                  
                                                                                
  while (*p != '\0') p++;                                                       
  return (p-s);                                                                 
  }                                                                             
                                                                                
int                                                                             
AlphaNum(c)                                                                     
char c;                                                                         
{                                                                               
  if  (((c >= 'A') && (c <='Z')) ||                                             
     /*((c >= '0') && (c <='1')) ||*/                     /* Q017-34 */         
       ((c >= '0') && (c <='9')) ||                       /* Q017-34 */         
       ((c >= 'a') && (c <='z')))                                               
     return(1);                                                                 
                                                                                
  return(0);                                                                    
  }                                                                             
                                                                                
/*                                                                              
************************************************************************        
* (C) COPYRIGHT 1989 ENCORE COMPUTER CORPORATION                       *        
*     ALL RIGHTS RESERVED                                              *        
************************************************************************        
*/                                                                              
