/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Statements - Control                             */
/*                          5.5.1 Continue                                   */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  3/2/84                                           */
/*  Source File :           source/stat.551.c                                */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Description :           Verify the continue statement causes the next    */
/*                          iteration of the enclosing loop to begin.        */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/stat.55.j                              */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
main()
{
        int i,j;
        FILE *fp;
        fp=fopen("stat_res bloc=y","a");
        /*
           The compiler fails if this does not compile
        */
        for ( i = 0; i < 3 ; i++)
        continue;
 
        /* Test 1
           continue statement inside a for loop */
        for ( i=j=0; i < 3 ; i++ )
        {   if ( i < 3 ) continue;
            j++;
        };
        if ( j )
        {       fail = TRUE;
                fprintf(fp,"  ** statement, continue 5.5.1-1 class 1 fail    -  exit return code : %d\n",j);
                printf("  ** statement, continue 5.5.1-1 class 1 fail    -  exit return code : %d\n",j);
        };
 
 
        /* Test 2
           continue statement inside a while loop */
        i = j = 0 ;
        while ( i < 3  )
        {       if ( i < 3 ) { i++;continue;};
                j++;
        };
        if ( j )
        {       fail = TRUE;
                fprintf(fp,"  ** statement, continue 5.5.1-2 class 1 fail    -  exit return code : %d\n",j);
                printf("  ** statement, continue 5.5.1-2 class 1 fail    -  exit return code : %d\n",j);
        };
 
        /* Test 3
           continue statement inside a do while loop */
        i = j = 0;
        do {i++;
                if ( i <= 3 ) continue;
                j++;
           } while ( i < 3 );
        if ( j )
        {       fail = TRUE;
                fprintf(fp,"  ** statement, continue 5.5.1-3 class 1 fail    -  exit return code : %d\n",j);
                printf("  ** statement, continue 5.5.1-3 class 1 fail    -  exit return code : %d\n",j);
        };
 
        /* Test 4
           verify that the continue statement applies only to loops,
           not to a switch. A continue inside a switch insides a loop
           causes the next loop iteration.
        */
        i = 0;
        while ( i < 3 )
                switch (i)
                {
                        case 0 : i++; continue;
                        case 1 : i++; continue;
                        case 2 : i++; continue;
                        case 3 : i++; continue;
                        case 4 : i++; continue;
                        case 5 : i++; continue;
                        case 6 : i++; continue;
                        case 7 : i++; continue;
                        case 8 : i++; continue;
                        case 9 : i++; continue;
                        case 10 : i++; continue;
                }
 
        if ( i != 3 )
        {       fail = TRUE;
                fprintf(fp,"  ** statement, continue 5.5.1-4 class 1 fail    -  exit return code : %d\n",i);
                printf("  ** statement, continue 5.5.1-4 class 1 fail    -  exit return code : %d\n",i);
        };
 if ( !fail )
   {fprintf(fp,"  .. statement, continue 5.5.1 class 1 pass\n");
    printf("  .. statement, continue 5.5.1 class 1 pass\n");}
fclose(fp);
}
