/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Statements - Loops                               */
/*                          5.4.1 while                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  10/25/83                                         */
/*  Source File :           source/stat.5411.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Description :           This program verify that the substatement is     */
/*                          executed repeatedly so long as the value of the  */
/*                          expression remains non-zero.                     */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/stat.54.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{       int x,y;
FILE *fp;
fp=fopen("stat_res bloc=y","a");
 
/* Test 1 */
        /* verify the syntax of while ( expression ) statement
           and expression is first evaluated before the substatement
           is executed.
        */
        x = 3; y = 1;
        while (  y = x < y ? 1 : 0 )
              { fail = TRUE;
                fprintf(fp,"  ** statement, while loops 5.4.1.1-1 class 1 fail -  exit return code : %d%d\n",x,y);
                printf("  ** statement, while loops 5.4.1.1-1 class 1 fail -  exit return code : %d%d\n",x,y);
                goto TEST2;
              }
        /* verify the expression is evaluated correctly */
        if (  y )
           { fail = TRUE;
             fprintf(fp," ** statement, while loops 5.4.1.1-1 class 1 fail    -  exit return code : %d%d\n",x,y);
             printf(" ** statement, while loops 5.4.1.1-1 class 1 fail    -  exit return code : %d%d\n",x,y);
           }
/* Test 2 */
        /* verify the substatement is executed repeatedly so long as the
           the value of the expression remains non-zero.
        */
TEST2:  x = 0;
        while ( x < 10 )
                x++;
 
        if ( x != 10 )
        { fail = TRUE;
          fprintf(fp,"  ** statement, while loops 5.4.1.1-2 class 1 fail-  exit return code : %d\n",x);
          printf("  ** statement, while loops 5.4.1.1-2 class 1 fail-  exit return code : %d\n",x);
        }
/* Test 3 */
        /* verify the assignment-expression is evaluated before
           the first substatement is executed.
        */
        x = 10; y = 2;
        while ( x %= y )
              { fail = TRUE;
                fprintf(fp,"  ** statement, while loops 5.4.1.1-3 class 1 fail    -  exit return code : %d\n",x);
                printf("  ** statement, while loops 5.4.1.1-3 class 1 fail    -  exit return code : %d\n",x);
                goto TEST4;
              }
        /* verify the expression is evaluated correctly. */
        if ( x )
        { fail = TRUE;
          fprintf(fp,"  ** statement, while loops 5.4.1.1-3 class 1 fail -  exit return code : %d\n",x);
          printf("  ** statement, while loops 5.4.1.1-3 class 1 fail -  exit return code : %d\n",x);
        }
 
/* Test 4 */
        /* continue verify the assignment-expression with /= operator */
TEST4:  x = 10; y = 2;
        while ( x /= 2 )
                ; /* null statement */
        if ( x )
        { fail = TRUE;
          fprintf(fp,"  ** statement, while loops 5.4.1.1-4 class 1 fail -  exit return code : %d\n",x);
          printf("  ** statement, while loops 5.4.1.1-4 class 1 fail -  exit return code : %d\n",x);
        }
 
if (!fail)
   {fprintf(fp,"  .. statement, While loops 5.4.1.1 class 1 pass\n");
    printf("  .. statement, While loops 5.4.1.1 class 1 pass\n");}
fclose(fp);
}
 
