/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Statements                                       */
/*                          5.3 Conditional - If                             */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Date :                  4/25/84                                          */
/*  Source File :           source/stat.5311.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*  Description :           This program verify that the expression is       */
/*                          evaluated, if it is non-zero the statement is    */
/*                          executed.                                        */
/*                          The compiler fails if this program does not      */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/stat.53.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;                                                       /* fail flag */
main()
{       int x,y;
        /* verify the syntax if (expression) statement
           expression <- expression?expression:expression
        */
        FILE *fp;
        fp=fopen("stat_res bloc=y","a");
        /* Test 1 */
        if ( (x == 1 ? 1 : 0 ) )
        {  fail = TRUE;
           fprintf(fp,"  ** statement, conditional 5.3.1.1-1 class 1 fail -  exit return code : %d\n",(x == 1 ? 1 : 0) );
           printf("  ** statement, conditional 5.3.1.1-1 class 1 fail -  exit return code : %d\n",(x == 1 ? 1 : 0) );
        }
 
        /* verify the syntax
           if ( expression,expression ) statement
          since expression <- expression,expression
        */
        /* Test 2 */
        x = 1;
        y = 0;
        if ( (x),(y) )
           { fail = TRUE;
             fprintf(fp,"  ** statement, conditional 5.3.1.1-2 class 1 fail  -  exit return code : %d%d\n",x,y);
             printf("  ** statement, conditional 5.3.1.1-2 class 1 fail  -  exit return code : %d%d\n",x,y);
           }
 
 
        /* verify the syntax
              if ( (type-name)expression ) statement
        */
        /* Test 3 */
        x = 0;
        if ( (int) x )
           { fail = TRUE;
             fprintf(fp,"  ** statement, conditional 5.3.1.1-3 class 1 fail  -  exit return code : %d\n",x);
             printf("  ** statement, conditional 5.3.1.1-3 class 1 fail  -  exit return code : %d\n",x);
           }
 
        /* verify the syntax
              if ( -- lvalue ) statement
           since  expression <- --lvalue
        */
        /* Test 4 */
        x = 1;
        if ( --x )
        {  fail = TRUE;
           fprintf(fp,"  ** statement, conditional 5.3.1.1-4 class 1 fail  -  exit return code : %d\n",x);
           printf("  ** statement, conditional 5.3.1.1-4 class 1 fail  -  exit return code : %d\n",x);
        }
 
        /* verify the syntax
                if ( primary ) statement
           expression <- primary
           primary    <- string
        */
        /* Test 5 */
        if ( "hello\n" )
           ;
        else
        {  fail = TRUE;
           fprintf(fp,"  ** statement, conditional 5.3.1.1-5 class 1 fail -  exit return code : %d\n","hello\n");
           printf("  ** statement, conditional 5.3.1.1-5 class 1 fail -  exit return code : %d\n","hello\n");
        }
 
if (!fail)
       {fprintf(fp,"  .. statement, conditional 5.3.1.1 class 1 pass\n");
        printf("  .. statement, conditional 5.3.1.1 class 1 pass\n");}
fclose(fp);
}
