/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      The C Preprocessor - Line Control                */
/*                          Section  6.4, 6.4.3                              */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.3                                         */
/*  Date :                  7/6/84                                           */
/*  Source File :           source/prep.6432.c                               */
/*  Revisions :             04/25/84    Sqa  Original UTX-32 (1.0) Release   */
/*                          07/05/84    T. Aleksa     UTX-32 1.0 Release     */
/*                          -- Modified test description.                    */
/*                                                                           */
/*  Description :           Verify that #line constant is correctly          */
/*                          handled with #include files of the form:         */
/*                             #include <filename>.                          */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/prep.64.j                              */
/*                                                                           */
/*  Associated Files :      Associated data files are include files named    */
/*                          ../data/prep.643[1-2].d.                         */
/*                          Associated work files are                        */
/*                          ../work/prep.6432.w                              */
/*                          Associated result files are                      */
/*                          ../result/prep.64.r.                             */
/*                          Any additional results are reported to the       */
/*                          default output device.                           */
/*                                                                           */
/*****************************************************************************/
 
/*      This test was originally spr0133 written against UTX Release 2.0.
        Problem description:  The control line of the form :
                #include <filename ( with missing delimiter >) causes the
                preprocessor to ignore the next line. In addition, the
                above syntax causes the preprocessor to generate incorrect
                line numbers.  This latter problem is documented in qar192
                written against UTX-32 Release 1.0. This test simply verifies
                whether the compiler produces correct line numbers with the
                proper #include syntax.  The #include syntax described above
                with the missing delimiter is tested in a different test.
 
*/
#include <stdio.h>
#include "prep.6431.d"
#include "prep.6432.d"
 
main()
{
  FILE *fp;
  fp = fopen("prep_res bloc=y","a");
  fprintf(fp," ** prep.6432 passes if correct compiler line numbers are produced.\n");
  printf(" ** prep.6432 passes if correct compiler line numbers are produced.\n");
  fclose (fp);
}
