/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Strings                 */
/*                          Section  1.2.5                                   */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/misc.1254.c                               */
/*  Revisions :             04/06/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that the compiler will detect and reject  */
/*                          a string constant assigned to a character array. */
/*                          The compiler fails if this program compiles.     */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      This test is qar189 written against UTX-32 Release 1.0               */
/*      Problem description:  When a string constant is assigned to a        */
/*              character array, the compiler gets confused and tries        */
/*              to return an error from the assembler.  The compiler         */
/*              should abort with an error message.                          */
#include <stdio.h>
main ()
{
        char string[2];
        FILE *fp;
        fp=fopen("misc_res bloc=y","a");
        *string = "b";        /* string constant */
        fprintf(fp,"..  miscellaneous, class 1.2.5.4 failed,expected compiler abort.\n");
        printf("..  miscellaneous, class 1.2.5.4 failed,expected compiler abort.\n");
        fclose(fp);
 
}
