/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Constants               */
/*                          Section  1.2                                     */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc.1223.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          02/20/84    T. Aleksa    UTX-32 1.0 Release      */
/*                          -- Revised comparisons in tests 1.2.2.3-3,       */
/*                             1.2.2.3-4, 1.2.2.3-5 which compared unsigned  */
/*                             long types to a signed constant.  Comparisons */
/*                             now compare values of unsigned long types.    */
/*                          -- Changed from class 1 to 3.                    */
/*                                                                           */
/*  Date :                  3/15/84                                          */
/*  Description :           verify that 0x0l through 0xffffffff are          */
/*                          represently correctly.                           */
/*                          This program also  tests the conformance of the  */
/*                          compiler to the syntax productions for numbers   */
/*                          specified by the reference manual.               */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/* 1.2.2.3 Long unsigned integer */
 
#include <stdio.h>
#define TRUE 1
int fail;
main()
{
FILE *fp;
fp=fopen("misc_res bloc=y","a");
/* Test 1.2.2.3-1 */
/* verify that 0x7fffffffl is the max. signed value 2147483647 */
     {   long  a;
 
        a = 0x7fffffffl;
        if ( a != 2147483647 )
        { fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.2.3-1 class 3 fail -  exit return code : %d\n",a);
        printf("  ** miscellaneous, constants 1.2.2.3-1 class 3 fail -  exit return code : %d\n",a);
        }
     }
/* Test 1.2.2.3-2 */
/* verify that 0x0l is equivalent to zero value */
     {  long b;
        b = 0x00000000l;
        if ( b != 0 )
        { fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.2.3-2 class 3 fail -  exit return code : %d\n",b);
        printf("  ** miscellaneous, constants 1.2.2.3-2 class 3 fail -  exit return code : %d\n",b);
        }
     }
 
/* Test 1.2.2.3-3 */
/* verify that 0xffffffff is the max. unsigned value 4294967295 */
     {  unsigned long x,y;
 
        x = 4294967295l;                        /* max. unsigned value */
        y = 0xffffffff;                         /* max. unsigned value in hex */
 
        if ( x != y )
        { fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.2.3-3 class 3 fail -  exit return code : %x\n",x);
        printf("  ** miscellaneous, constants 1.2.2.3-3 class 3 fail -  exit return code : %x\n",x);
        }
     }
/* Test 1.2.2.3-4 */
/*      verify that whenever a wider integer value is assigned to an integer */
/*      variable or argument that is narrower, the prefix is truncated       */
 
     {  unsigned long x;
                double y;
        y = 4294967295 + 15 * 256 * 256 * 256 * 256;
        x = y;
        if ( x != ( unsigned long ) 0xffffffff )
        { fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.2.3-4 class 3 fail -  exit return code : %x\n",x);
        printf("  ** miscellaneous, constants 1.2.2.3-4 class 3 fail -  exit return code : %x\n",x);
        }
     }
/* Test 1.2.2.3-5 */
     {  unsigned long x;
                x = 0xf * 256 * 256 * 256 * 16 + 0xf * 256 * 256 * 256
                    + 0xf * 256 * 256 * 16 + 0xf * 256 * 256 + 0xf * 256 * 16
                        + 0xf * 256 + 0xf * 16 + 0xf;
        if ( x != (unsigned long ) 0xffffffff )
        { fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.2.3-5 class 3 fail -  exit return code : %x\n",x);
        printf("  ** miscellaneous, constants 1.2.2.3-5 class 3 fail -  exit return code : %x\n",x);
        }
     }
 
 
if (!fail)
       {fprintf(fp,"  .. miscellaneous, constants 1.2.2.3 class 3 pass\n");
        printf("  .. miscellaneous, constants 1.2.2.3 class 3 pass\n");}
fclose(fp);
}
