/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous Concepts - Constants               */
/*                          Section  1.2                                     */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc.1222.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          02/20/83    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Revised comparisons is tests 1.2.2.2-3 and    */
/*                             1.2.2.2-4 which compared unsigned long types  */
/*                             to a signed constant.  Comparisons now        */
/*                             compare values of unsigned long types.        */
/*                          -- Changed from class 1 to 3.                    */
/*                                                                           */
/*  Date :                  3/15/84                                          */
/*  Description :           Verify that -2147483648 through 2147483647 sign, */
/*                          or 0 to 4,294,967,295 unsigned are represently   */
/*                          correctly.                                       */
/*                          This program also  tests the conformance of the  */
/*                          compiler to the syntax productions for numbers   */
/*                          specified by the reference manual.               */
/*                          The compiler fails if the program will not       */
/*                          compile.                                         */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
/* 1.2.2.2 Long integer */
 
#include <stdio.h>
#define TRUE 1
int fail;
main()
{
FILE *fp;
fp=fopen("misc_res bloc=y","a");
/* Test 1.2.2.2-1 */
{       long  a,b;
 
        a = 0x7fffffff;
        b = 0x80000000;
        if ( a != 2147483647 || b != -2147483648 )
           { fail = TRUE;
                fprintf(fp,"  ** miscellaneous, constants 1.2.2.2-1 class 3 fail    -  exit return code : %d%d\n",a,b);
                printf("  ** miscellaneous, constants 1.2.2.2-1 class 3 fail    -  exit return code : %d%d\n",a,b);
           }
 }
 
/* Test 1.2.2.2-2 */
{       short x,y;
 
        x = 0x7fff;
        y = 0x8000;
        if ( x != 32767 || y != -32768 )
{ fail = TRUE;
                fprintf(fp,"  ** miscellaneous, constants 1.2.2.2-2 class 3 fail    -  exit return code : %d%d\n",x,y);
                printf("  ** miscellaneous, constants 1.2.2.2-2 class 3 fail    -  exit return code : %d%d\n",x,y);
        }
}
/* Test 1.2.2.2-3 */
{       unsigned long x,y;
 
        x = 4294967295;                         /* max. unsigned value */
        y = 0xffffffff;                         /* max. unsigned value in hex */
 
        if ( x != y )
        { fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.2.2-3 class 3 fail    -  exit return code : %x\n",x);
        printf("  ** miscellaneous, constants 1.2.2.2-3 class 3 fail    -  exit return code : %x\n",x);
        }
}
/* Test 1.2.2.2-4 */
/*      verify that whenever a wider integer value is assigned to an integer */
/*      variable or argument that is narrower, the prefix is truncated       */
 
{       unsigned long x;
                double y;
        y = 4294967295 + 15 * 256 * 256 * 256 * 256;
        x = y;
        if ( x != (unsigned long) 0xffffffff )
        { fail = TRUE;
        fprintf(fp,"  ** miscellaneous, constants 1.2.2.2-4 class 3 fail    -  exit return code : %x\n",x);
        printf("  ** miscellaneous, constants 1.2.2.2-4 class 3 fail    -  exit return code : %x\n",x);
        }
}
  if ( !fail)
      { fprintf(fp,"  .. miscellaneous, constants 1.2.2.2 class 3 pass\n");
        printf("  .. miscellaneous, constants 1.2.2.2 class 3 pass\n");}
  fclose(fp);
}/* end main */
