/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous - Integer Constants                */
/*                          Section - 1.2.1.4                                */
/*  Product and Revision :  Unix 1.5                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc.1214.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          02/17/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Test modified to include pass message.        */
/*                          03/30/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added test for qar71 written againt UTX-32 1.0*/
/*                          05/14/84    T. Aleksa   UTX-32 1.0 Release       */
/*                          -- Added test for octal representation.          */
/*                                                                           */
/*  Date :                  5/18/84                                          */
/*  Description :           Verify that -32768 through 32767 (octal 77777)   */
/*                          are represented correctly.                       */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{
 short  a,b;
 FILE *fp;
 fp=fopen("misc_res bloc=y","a");
 
 a = 077777;                    /* turn off the signed bit */
 b = 0100000;                   /* turn on the signed bit */
 if ( a != 32767 || a != ( short ) 0x7fff )
 {  fail = TRUE;
    fprintf(fp,"  ** miscellaneous, constants 1.2.1.4-1 class 3 fail -  exit return code : %d%x\n",a,a);
    printf("  ** miscellaneous, constants 1.2.1.4-1 class 3 fail -  exit return code : %d%x\n",a,a); 
 }
 
 if ( b != -32768 || b != ( short ) 0x8000 )
 {  fail = TRUE;
    fprintf(fp,"  ** miscellaneous, constants 1.2.1.4-2 class 3 fail -  exit return code : %d%x\n",b,b);
    printf("  ** miscellaneous, constants 1.2.1.4-2 class 3 fail -  exit return code : %d%x\n",b,b);
 }
 
/*      Tests 3 and 4 are qar71 written against UTX-32 Release 1.0.          */
/*      Problem description:  Explicit casts to short, e.g. (short)<expr>    */
/*                            are sometimes ignored.                         */
 
if ( ( (short)~(0x8000) )  != 32767 )
{  fail = TRUE;
   fprintf(fp,"  ** miscellaneous, constants 1.2.1.4-3 class 3 fail-  exit return code : %d\n",(short)~(0x8000) );
   printf("  ** miscellaneous, constants 1.2.1.4-3 class 3 fail-  exit return code : %d\n",(short)~(0x8000) );
}
 
if ( ( (short)~( (short)0x8000 ) ) != 32767 )
{  fail = TRUE;
   fprintf(fp,"  ** miscellaneous, constants 1.2.1.4-4 class 3 fail -  exit return code : %d\n",(short)~( (short)0x8000) );
   printf("  ** miscellaneous, constants 1.2.1.4-4 class 3 fail -  exit return code : %d\n",(short)~( (short)0x8000) );
}
if ( !fail )
  {fprintf(fp,"  .. miscellaneous, constants 1.2.1.4 class 3 pass \n");
   printf("  .. miscellaneous, constants 1.2.1.4 class 3 pass \n"); }
fclose(fp);
}
 
