/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Miscellaneous - Integer Constants                */
/*                          Section - 1.2.1.2                                */
/*  Product and Revision :  Unix 1.4                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/misc.1212.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          03/21/84    T. Aleksa      UTX-32 1.0 Release    */
/*                          -- Added test for qar131.                        */
/*                          06/19/84    T. Aleksa      UTX-32 1.0 Release    */
/*                          -- Resolved qar131.                              */
/*                                                                           */
/*  Date :                  6/19/84                                          */
/*  Description :           Verify that an integer constant which begins     */
/*                          with 0x or 0X is taken to be a hexadecimal.      */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/misc.12.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{
 int a,b;
 double x, y, z, diff;
 FILE *fp;
 fp=fopen("misc_res bloc=y","a");
 
/*      Test 1          */
 
 /* verify that 0x and 0X are the same */
 a = 0x12;
 b = 0X12;
 if ( a != 18 || b != 18 )
    {fail = TRUE;
     fprintf(fp,"  ** miscellaneous, constants 1.2.1.2-1 class 1 fail -  exit return code : %x%x\n",a,b); 
     printf("  ** miscellaneous, constants 1.2.1.2-1 class 1 fail -  exit return code : %x%x\n",a,b); 
    }
 
/*      Test 2          */
 
 /* verify that hexdecimal and decimal integer can be distinguished.*/
 a = 0x16;
 b = 16;
 if ( a != 22 || b != 16 )
    {fail = TRUE;
     fprintf(fp,"  ** miscellaneous, constants 1.2.1.2-2 class 1 fail -  exit return code : %x%x\n",a,b);
     printf("  ** miscellaneous, constants 1.2.1.2-2 class 1 fail -  exit return code : %x%x\n",a,b);
    }
 
/* Tests 3, and 4 were  originally qar1 written against UTX-32 Release 2.0.   */
/* They are presently qar131 written against UTX-32 1.0 Release.              */
 
/* Problem Description:  When a hexadecimal constant consisting of more than  */
/*         8 digits is specified in an assignment statement, it seems that    */
/*         only the last 8 digits are evaluated and zero padding occurs.      */
/* Resolution:  Hexadecimal digits should only be 8 digits long because they  */
/*         are integers ( 32-bit quantity ).  Update documentation.           */
 
/*      Test 3          */
 
        x = 0x80000001;
        y = -2147483647;
 
        if ( x != y )
           { fail = TRUE;
             fprintf(fp,"  ** miscellaneous, constants 1.2.1.2-3 class 1 fail - exit return code : %23.20e\n", x );
             printf("  ** miscellaneous, constants 1.2.1.2-3 class 1 fail - exit return code : %23.20e\n", x );
           }
/*      Test 4          */
 
        x = 0x7fffffff;
        y = 2147483647;
 
        if ( x != y )
           { fail = TRUE;
             fprintf(fp,"  ** miscellaneous, constants 1.2.1.2-4 class 1 fail - exit return code : %23.20e\n", x );
             printf("  ** miscellaneous, constants 1.2.1.2-4 class 1 fail - exit return code : %23.20e\n", x );
           }
 
 if ( !fail)
   {fprintf(fp,"  .. miscellaneous, constants 1.2.1.2 class 1 pass\n");
    printf("  .. miscellaneous, constants 1.2.1.2 class 1 pass\n"); }
 fclose(fp);
}
 
