/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          - Functions                                      */
/*                          Section 3.3.2.8                                  */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/extn.3328.c                               */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                                                                           */
/*                          04/10/84    T. Aleksa     UTX-32 1.0 Release     */
/*                          -- Added test for UTX 1.0 spr0007.               */
/*                                                                           */
/*  Date :                  4/23/84                                          */
/*  Description :           Verify that the value of an expression can be    */
/*                          returned from a function.                        */
/*                          The compiler fails if the pass message is not    */
/*                          displayed.                                       */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
 
/*     Functions
*/
#include <stdio.h>
#define TRUE 1
int fail;
 
main()
{
FILE *fp;
fp=fopen("extn_res bloc=y","a");
 
/*  Test 1  */
 { int p;
  
   p = max();
   if ( p != 1 )
      { fail = TRUE;
        fprintf(fp,"  ** external, functions 3.3.2.8-1 class 1 fail  -  exit return code : %d\n",p);
        printf("  ** external, functions 3.3.2.8-1 class 1 fail  -  exit return code : %d\n",p);
      }
 }
 
/*  Test 2  */
/*  The following test was originally spr0007 written against UTX Release 1.0.
    Problem Description : In producing assembly code for the expression in
            function f1, the compiler runs out of registers to work with
            and compilation aborts.  If the expression is broken down on
            separate lines, thus freeing all registers, the expression assembly
            coded correctly.
*/
 { double f1(), f2();
   double x, y, z;
 
   x = 1.0;
   y = 2.0;
 
   z = f1( x, y );
 
   if ( z != ( -40000.00 ) )
      { fail = TRUE;
        fprintf(fp,"  ** external, functions 3.3.2.8-2 class 1 fail -  exit return code : %f\n", z );
        printf("  ** external, functions 3.3.2.8-2 class 1 fail -  exit return code : %f\n", z );
      }
 }
   if ( !fail )
     {fprintf(fp,"  .. external, functions 3.3.2.8 class 1 pass\n");
      printf("  .. external, functions 3.3.2.8 class 1 pass\n");}
   fclose(fp);
 
}
max()     /*  Test 1  */
{
   int a,b;
   a = 10;
   b = -10;
   return ( a > b ? 1 : 0 );
}
 
double f1( a, b )       /*  Test 2  */
double a, b;
{
   return( 100.0000 * a * -1.000000 * b * a * f2( a, b ) );
}
 
double f2( a, b)        /*  Test 2  */
double a, b;
{
   return( 100.0000 * a * b );
}
