/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          - Functions                                      */
/*                          Section 3.3.1.6                                  */
/*  Product and Revision :  Unix 1.3                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/extn.33162.c                              */
/*  Revisions :             04/11/84    Sqa   Original UTX-32 1.0 Release    */
/*                          07/30/84    T. Aleksa      UTX-32 1.0 Release    */
/*                          -- Revised test.                                 */
/*  Date :                  11/20/84                                         */
/*  Description :           Verify that the compiler will allow a default    */
/*                          int declaration.                                 */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*    This test was originally spr0043 written against UTX Release 1.0.
      Problem description:  The compiler aborts with a syntax error when
              an int declaration is defaulted.
 
      This test is qar217 written against UTX-32 Release 1.0.  The test fails
      if the program does not compile.
 
*/
 
#include <stdio.h>
main()
{
        int a, b;
        FILE *fp;
        fp=fopen("extn_res bloc=y","a");
        b = 3;
        a = func( b );
 
        if ( a == 3 )
          {fprintf(fp,"  .. external, default type 3.3.1.6.2 class 2 pass\n");
           printf("  .. external, default type 3.3.1.6.2 class 2 pass\n");}
        else
          {fprintf(fp,"  ** external, default type 3.3.1.6.2 class 2 fail  -  exit return code : %d\n", a );
           printf("  ** external, default type 3.3.1.6.2 class 2 fail  -  exit return code : %d\n", a );}
        fclose(fp);
}
func(xx)     /*  declaration  "int xx;" defaulted */
{
return ( xx );
}
