 
/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          Functions, Arguments                             */
/*                          Section   3.3, 3.3.1                             */
/*  Author :                Tina Aleksa                                      */
/*  Product and Revision :  Unix 1.2                                         */
/*  Date :                  4/23/84                                          */
/*  Source File :           source/extn.33125.c                              */
/*  Revisions :             03/21/84    Sqa  Original UTX-32 (1.0) Release   */
/*                                                                           */
/*  Description :           Verify that function names used within pointer   */
/*                          arithmetic produce an appropriate compiler error.*/
/*                          The compiler fails if this program compiles.     */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.33.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
/*      This test is qar133 written against UTX-32 1.0 Release.  It was      */
/*      originally qar104 written against UTX 2.0 Release.                   */
 
/*      Problem description:  When a function identifier name is used        */
/*              within an expression containing pointer arithmetic, the      */
/*              compiler tries to determine the size of what the function    */
/*              identifier points to and therefore fails.  Functions have    */
/*              no size in this context.  The error message the compiler     */
/*              produces for this case is very misleading and should         */
/*              therefore be changed.                                        */
 
/*      The invalid error message produced by UTX-32 1.0 Release is:         */ /*              compiler takes size of function                              */
 
/*      The compiler fails if this test compiles.                            */
 
#include <stdio.h>
extern main();
main()
{
FILE *fp;
fp=fopen("extn_res bloc=y","a");
        fprintf(fp," ** extn.33125 fail  %x\n", main - 0x84L);
        printf(" ** extn.33125 fail  %x\n", main - 0x84L);
fclose(fp);
}
