/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      External Definitions and Declarations            */
/*                          External Data - Section 3.1                      */
/*                          Local Complex types - Section 3.1.2              */
/*  Product and Revision :  Unix 1.2                                         */
/*  Author :                Tina Aleksa                                      */
/*  Source File :           source/extn.3124.c                               */
/*  Revisions :             04/15/85    Sqa     Original UTX-32 1.2 Release  */
/*                                                                           */
/*  Date :                  4/16/85                                          */
/*  Descriptions :          For structures, arrays, fields, and unions def-  */
/*                          ined and declared (implicitly by context or      */
/*                          explicitly using the extern storage class        */
/*                          specifier ) in the same file:                    */
/*                          Verify that the variables can be referenced      */
/*                          correctly from the point of an identifier's      */
/*                          definition to the end of the file.               */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/extn.31.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define  TRUE  1;
int     fail;
 
int in[10];
short int si[20];
long int li[30];
short sh[40];
long lg[50];
char ch[60];
unsigned un[70];
unsigned int ui[80];
unsigned short us[90];
unsigned short int usi[100];
unsigned long ul[110];
unsigned long int uli[120];
unsigned char uc[130];
float fl[140];
long float lf[150];
double db[160];
 
struct test1 {
               int      test_a;
               char     test_b;
               float    test_c;
               unsigned test_d;
} test_struct;
 
union test2 {
               int      test_a;
               char     test_b;
               float    test_c;
               unsigned test_d;
} test_union;
 
struct test3 {
               unsigned test_a   :  1;
               unsigned test_b   :  2;
               unsigned test_c   :  3;
               unsigned test_d   :  4;
} test_field;
 
main()
{
/*  Block 1 :
    declare variables explicitly using the extern storage class specifier
*/
 
        extern int in[10];
        extern short int si[20];
        extern long int li[30];
        extern short sh[40];
        extern long lg[50];
        extern char ch[60];
        extern unsigned un[70];
        extern unsigned int ui[80];
        extern unsigned short us[90];
        extern unsigned short int usi[100];
        extern unsigned long ul[110];
        extern unsigned long int uli[120];
        extern unsigned char uc[130];
        extern float fl[140];
        extern long float lf[150];
        extern double db[160];
 
        extern struct test_struct;
        extern struct test_field;
        extern union test_union;
        FILE *fp;
        fp=fopen("extn_res bloc=y","a");       /* open FILE  for results */
 
        /*  verify that variables are initialized to zero  */
 
        if ( *in  != 0 || *si  != 0 || *li != 0 || *sh != 0 ||
             *lg  != 0 || *fl  != 0 || *lf != 0 || *db != 0 ||
             *ch != 0  || *un  != 0 || *ui != 0 || *us != 0 ||
             *usi != 0 || *uli != 0 || *uc != 0 || *ul != 0 ||
             test_struct.test_a != 0 || test_union.test_b != 0 ||
             test_field.test_c != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** external, local complex types 3.1.2.4-1 class 1 fail - exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_b, test_field.test_c );
              printf("  ** external, local complex types 3.1.2.4-1 class 1 fail - exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_b, test_field.test_c );
           }
 
       { /*added in*/
     /*  Block 2 :  declare variables
     */
     int in[10];
     short int si[20];
     long int li[30];
     short sh[40];
     long lg[50];
     char ch[60];
     unsigned un[70];
     unsigned int ui[80];
     unsigned short us[90];
     unsigned short int usi[100];
     unsigned long ul[110];
     unsigned long int uli[120];
     unsigned char uc[130];
     float fl[140];
     long float lf[150];
     double db[160];
     struct test1 { int test_a;
                    char test_b;
                    float test_c;
                    unsigned test_d;
     } test_struct;
     union test2  { int test_a;
                    char test_b;
                    float test_c;
                    unsigned test_d;
     } test_union;
     struct test3 { unsigned test_a  :  1;
                    unsigned test_b  :  2;
                    unsigned test_c  :  3;
                    unsigned test_d  :  4;
     } test_field;
 
   /*  assign values and verify results
   */
 
   in[0] = 11;
   si[0] = 21;
   li[0] = 31;
   sh[0] = 41;
   lg[0] = 51;
   fl[0] = 61.0;
   lf[0] = 71.0;
   db[0] = 81.0;
   ch[0] = 91;
   un[0] = 101;
   ui[0] = 111;
   us[0] = 121;
   usi[0] = 131;
   uli[0] = 141;
   uc[0] = 151;
   ul[0] = 161;
   test_struct.test_a = 11;
   test_union.test_a = 11;
   test_field.test_a = 0;
 
   if ( *in  != 11  || *si  != 21   || *li != 31   || *sh != 41   ||
        *lg  != 51  || *fl  != 61.0 || *lf != 71.0 || *db != 81.0 ||
        *ch != 91   || *un  != 101  || *ui != 111  || *us != 121  ||
        *usi != 131 || *uli != 141  || *uc != 151  || *ul != 161  ||
        test_struct.test_a != 11    || test_union.test_a != 11    ||
        test_field.test_a != 0 )
      { fail = TRUE;
        fprintf(fp,"  ** external, complex types 3.1.2.4-2 class 1 fail exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_a, test_field.test_a );
         printf("  ** external, complex types 3.1.2.4-2 class 1 fail exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_a, test_field.test_a );
      }
 
      {  /*  Block 3 :  declare variables
         */
         int in[10];
         short int si[20];
         long int li[30];
         short sh[40];
         long lg[50];
         char ch[60];
         unsigned un[70];
         unsigned int ui[80];
         unsigned short us[90];
         unsigned short int usi[100];
         unsigned long ul[110];
         unsigned long int uli[120];
         unsigned char uc[130];
         float fl[140];
         long float lf[150];
         double db[160];
         struct test1 { int test_a;
                        char test_b;
                        float test_c;
                        unsigned test_d;
         } test_struct;
         union test2  { int test_a;
                        char test_b;
                        float test_c;
                        unsigned test_d;
         } test_union;
         struct test3 { unsigned test_a  :  1;
                        unsigned test_b  :  2;
                        unsigned test_c  :  3;
                        unsigned test_d  :  4;
         } test_field;
 
       /*  assign values and verify results
       */
 
       in[0] = 10;
       si[0] = 20;
       li[0] = 30;
       sh[0] = 40;
       lg[0] = 50;
       fl[0] = 60.0;
       lf[0] = 70.0;
       db[0] = 80.0;
       ch[0] = 90;
       un[0] = 100;
       ui[0] = 110;
       us[0] = 120;
       usi[0] = 130;
       uli[0] = 140;
       uc[0] = 150;
       ul[0] = 160;
       test_struct.test_a = 10;
       test_union.test_a = 10;
       test_field.test_a = 1;
 
       if ( *in  != 10  || *si  != 20   || *li != 30   || *sh != 40   ||
            *lg  != 50  || *fl  != 60.0 || *lf != 70.0 || *db != 80.0 ||
            *ch != 90   || *un  != 100  || *ui != 110  || *us != 120  ||
            *usi != 130 || *uli != 140  || *uc != 150  || *ul != 160  ||
            test_struct.test_a != 10    || test_union.test_a != 10    ||
            test_field.test_a != 1 )
          { fail = TRUE;
            fprintf(fp,"  ** external, complex types 3.1.2.4-3 class 1 fail - exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_a, test_field.test_a );
             printf("  ** external, complex types 3.1.2.4-3 class 1 fail - exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_a, test_field.test_a );
          }
 
      } /*  end Block 3  */
 
  /*  verify that values assigned to variables in Block 2 contain correct values  */
 
   if ( *in  != 11  || *si  != 21   || *li != 31   || *sh != 41   ||
        *lg  != 51  || *fl  != 61.0 || *lf != 71.0 || *db != 81.0 ||
        *ch != 91   || *un  != 101  || *ui != 111  || *us != 121  ||
        *usi != 131 || *uli != 141  || *uc != 151  || *ul != 161  ||
        test_struct.test_a != 11    || test_union.test_a != 11    ||
        test_field.test_a != 0 )
      { fail = TRUE;
        fprintf(fp,"  ** external, complex types 3.1.2.4-4 class 1 fail - exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_a, test_field.test_a );
         printf("  ** external, complex types 3.1.2.4-4 class 1 fail - exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_a, test_field.test_a );
      }
 
  } /*  end Block 2  */
 
  /*  verify that values assigned to variables in Block 1 contain correct values  */
        if ( *in  != 0 || *si  != 0 || *li != 0 || *sh != 0 ||
             *lg  != 0 || *fl  != 0 || *lf != 0 || *db != 0 ||
             *ch != 0  || *un  != 0 || *ui != 0 || *us != 0 ||
             *usi != 0 || *uli != 0 || *uc != 0 || *ul != 0 ||
             test_struct.test_a != 0 || test_union.test_b != 0 ||
             test_field.test_c != 0 )
           { fail = TRUE;
             fprintf(fp,"  ** external, local complex types 3.1.2.4-5 class 1 fail  - exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_b, test_field.test_c );
              printf("  ** external, local complex types 3.1.2.4-5 class 1 fail  - exit return code : %d%d%d%d%d%f%f%f%d%d%d%d%d%d%d%d%d%d%d\n",
            *in,*si,*li,*sh,*lg,*fl,*lf,*db,*ch,*un,*ui,*us,*usi,*uli,*uc,*ul,
            test_struct.test_a, test_union.test_b, test_field.test_c );
           }
 
        if ( !fail )
          {fprintf(fp,"  .. external, local complex types 3.1.2.4 class 1 pass\n");
           printf("  .. external, local complex types 3.1.2.4 class 1 pass\n");}
        fclose(fp);
 
} /*  end Block 1  */
