/*****************************************************************************/
/*                                                                           */
/*  Test Function(s) :      Expressions - Bitwise logical operators          */
/*                          Section - 4.1.3.3.3                              */
/*  Product and Revision :  1.4                                              */
/*  Author :                Suifun Law                                       */
/*  Source File :           source/expr.41333.c                              */
/*  Revisions :             09/30/83    Sqa     Original UTX 2.0 Release     */
/*                          04/04/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          --  Renumbered tests.                            */
/*                          07/02/84    T. Aleksa  UTX-32 1.0 Release        */
/*                          --  Added cast to unsigned in test 5.            */
/*                                                                           */
/*  Date :                  7/2/84                                           */
/*  Description :           Verify that the bitwise AND &, OR |, and XOR ^   */
/*                          operators result in the correct operation on     */
/*                          integral types.                                  */
/*                          This program tests the bitwise XOR operator, the */
/*                          rest of the tests are on expr.41331.c and        */
/*                          expr.41332.c                                     */
/*                          The compiler fails if this program cannot be     */
/*                          compiled.                                        */
/*  Test Operation :        This 'c' source file is compiled and executed    */
/*                          under the control of the shell command file      */
/*                           ../shell/expr.41.j                              */
/*                                                                           */
/*  Associated Files :      Any results are reported to the default output   */
/*                          device.                                          */
/*                                                                           */
/*****************************************************************************/
 
#include <stdio.h>
#define TRUE  1
int fail;
 
main ()
{            
 
FILE *fp;
fp=fopen("expr_res bloc=y","a");
/* Bitwise XOR */
  {/* Test 1 */
    register int a,b;
    int          c;
    a = c =  2 ; b  = 3;                        /* a = 010   b = 011        */
    a = a ^ b;                                  /* a = 010 & 011 = 001      */
    c = c ^ 3;
    if ( a != 1 || b != 3 || c != 1 )
       {  fail = TRUE;
          fprintf(fp,"  ** expression, bitwise XOR 4.1.3.3.3-1 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
          printf("  ** expression, bitwise XOR 4.1.3.3.3-1 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
       }
  }
 
  {/* Test 2 */
    unsigned a,b,c;
    a = c = 2 ; b = 3;
    a = a ^ b;
    c = c ^ 3;
    if ( a != 1 || b != 3 || c != 1 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, bitwise XOR 4.1.3.3.3-2 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
         printf("  ** expression, bitwise XOR 4.1.3.3.3-2 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
       }
  }
 
  {/* Test 3 */
    short  a,b,c;
    a = c =  2 ; b = 3;
    a = a ^ b;
    c = c ^ 3;
    if ( a != 1 || b != 3 || c != 1 )
       { fail = TRUE;
         fprintf(fp,"  ** expression, bitwise XOR 4.1.3.3.3-3 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
         printf("  ** expression, bitwise XOR 4.1.3.3.3-3 class 1 fail -  exit return code : %d%d%d\n",a,b,c);
       }
  }
 
  {/* Test 4 */
   int a,b;
   a = -2; b = 3;                               /* a = 0xfffffffe
                                                   b = 0x00000003 */
   a = a ^ b;                                   /* a = 0xfffffffd */
   if ( a != 0xfffffffd )
         {  fail = TRUE;
            fprintf(fp,"  ** expression, bitwise XOR 4.1.3.3.3-4 class 1 fail -  exit return code : %d%d\n",a,b);
            printf("  ** expression, bitwise XOR 4.1.3.3.3-4 class 1 fail -  exit return code : %d%d\n",a,b);
         }
  }
 
  {/* Test 5 */
     unsigned a,b ;
     a = 0x0f0f0f0f;
     b = 0xf0f0f0f0;
     a = a ^ b;
     if ( a != (unsigned) 0xffffffff )
        { fail = TRUE;
          fprintf(fp," ** expression, bitwise XOR 4.1.3.3.3-5 class 1 fail -  exit return code : %x%x\n",a,b);
          printf(" ** expression, bitwise XOR 4.1.3.3.3-5 class 1 fail -  exit return code : %x%x\n",a,b);
        }
  }
 
  {/* Test 6 */
     int a,b,c,d;
     a =  1 ^ 1 ^ 0  ^  1 ^ 1  ;                /* a = 0 */
     b =  1 ^ ( 1 ^ 0 ) ^ ( 1 ^ 1 );            /* b = 0 */
     c =  ( 1 ^ 1 ) ^ ( 0 ^ 1 ) ^ 1;            /* c = 0 */
     if ( a != 0 || b != 0 || c != 0 )
        { fail = TRUE;
          fprintf(fp,"  ** expression, bitwise XOR 4.1.3.3.3-6 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
          printf("  ** expression, bitwise XOR 4.1.3.3.3-6 class 1 fail -  exit return code : %x%x%x\n",a,b,c);
        }
  }
 
  {/* Test 7 */
    int a,b;
    a = ( 1 | 0 ) ^ ( 1 & 0 );
    b = ( 1 ^ 0 ) | ( 0 ^ 1 );
    if ( a != b)
       { fail = TRUE;
         fprintf(fp,"  ** expression, bitwise operator 4.1.3.3.3-7 class 1 fail -  exit return code : %x%x\n",a,b);
         printf("  ** expression, bitwise operator 4.1.3.3.3-7 class 1 fail -  exit return code : %x%x\n",a,b);
       }
  }
  if ( !fail)
    {fprintf(fp,"  .. expression, bitwise XOR 4.1.3.3.3 class 1 pass\n");
     printf("  .. expression, bitwise XOR 4.1.3.3.3 class 1 pass\n");}
 fclose(fp);
}
 
